/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit;

import com.gitblit.IStoredSettings;
import com.gitblit.utils.FileUtils;
import com.gitblit.utils.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class FileSettings
extends IStoredSettings {
    protected File propertiesFile;
    private final Properties properties = new Properties();
    private volatile long lastModified;
    private volatile boolean forceReload;

    public FileSettings() {
        super(FileSettings.class);
    }

    public FileSettings(String file) {
        this();
        this.load(file);
    }

    public void load(String file) {
        this.propertiesFile = new File(file);
    }

    @Override
    public void merge(IStoredSettings settings) {
        super.merge(settings);
        if (this.propertiesFile == null && settings instanceof FileSettings) {
            this.propertiesFile = ((FileSettings)settings).propertiesFile;
        }
    }

    @Override
    protected synchronized Properties read() {
        if (this.propertiesFile != null && this.propertiesFile.exists() && (this.forceReload || this.propertiesFile.lastModified() > this.lastModified)) {
            FileInputStream is = null;
            try {
                this.logger.debug("loading {}", (Object)this.propertiesFile);
                Properties props = new Properties();
                is = new FileInputStream(this.propertiesFile);
                props.load(is);
                props = this.readIncludes(props);
                this.properties.clear();
                this.properties.putAll((Map<?, ?>)props);
                this.lastModified = this.propertiesFile.lastModified();
                this.forceReload = false;
            }
            catch (FileNotFoundException props) {
            }
            catch (Throwable t) {
                this.logger.error("Failed to read " + this.propertiesFile.getName(), t);
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (Throwable props) {}
                }
            }
        }
        return this.properties;
    }

    private Properties readIncludes(Properties properties) throws IOException {
        Properties baseProperties = new Properties();
        String include = (String)properties.remove("include");
        if (!StringUtils.isEmpty(include)) {
            List<String> names = StringUtils.getStringsFromValue(include, ",");
            for (String name : names) {
                if (StringUtils.isEmpty(name)) continue;
                File file = new File(this.propertiesFile.getParentFile(), name.trim());
                if (!file.exists()) {
                    file = new File(name.trim());
                }
                if (!file.exists()) {
                    this.logger.warn("failed to locate {}", (Object)file);
                    continue;
                }
                this.logger.debug("loading {}", (Object)file);
                try (FileInputStream iis = new FileInputStream(file);){
                    baseProperties.load(iis);
                }
                baseProperties = this.readIncludes(baseProperties);
            }
        }
        Properties merged = new Properties();
        merged.putAll((Map<?, ?>)baseProperties);
        merged.putAll((Map<?, ?>)properties);
        return merged;
    }

    @Override
    public boolean saveSettings() {
        String content = FileUtils.readContent(this.propertiesFile, "\n");
        for (String key : this.removals) {
            String regex2 = "(?m)^(" + this.regExEscape(key) + "\\s*+=\\s*+)(?:[^\r\n\\\\]++|\\\\(?:\r?\n|\r|.))*+$";
            content = content.replaceAll(regex2, "");
        }
        this.removals.clear();
        FileUtils.writeContent(this.propertiesFile, content);
        this.forceReload = true;
        return true;
    }

    @Override
    public synchronized boolean saveSettings(Map<String, String> settings) {
        String content = FileUtils.readContent(this.propertiesFile, "\n");
        for (Map.Entry<String, String> setting : settings.entrySet()) {
            String regex2 = "(?m)^(" + this.regExEscape(setting.getKey()) + "\\s*+=\\s*+)(?:[^\r\n\\\\]++|\\\\(?:\r?\n|\r|.))*+$";
            String oldContent = content;
            if (!(content = content.replaceAll(regex2, setting.getKey() + " = " + setting.getValue())).equals(oldContent)) continue;
            content = content + "\n" + setting.getKey() + " = " + setting.getValue();
        }
        FileUtils.writeContent(this.propertiesFile, content);
        this.forceReload = true;
        return true;
    }

    private String regExEscape(String input) {
        return input.replace(".", "\\.").replace("$", "\\$").replace("{", "\\{");
    }

    protected long lastModified() {
        return this.lastModified;
    }

    protected boolean forceReload() {
        return this.forceReload;
    }

    public String toString() {
        if (this.propertiesFile == null) {
            return "[empty]";
        }
        return this.propertiesFile.getAbsolutePath();
    }
}

