/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit;

import com.gitblit.Constants;
import com.gitblit.FileSettings;
import com.gitblit.GitblitSslContextFactory;
import com.gitblit.IStoredSettings;
import com.gitblit.authority.GitblitAuthority;
import com.gitblit.authority.NewCertificateConfig;
import com.gitblit.servlet.GitblitContext;
import com.gitblit.utils.FileUtils;
import com.gitblit.utils.StringUtils;
import com.gitblit.utils.X509Utils;
import com.unboundid.ldap.listener.InMemoryDirectoryServer;
import com.unboundid.ldap.listener.InMemoryDirectoryServerConfig;
import com.unboundid.ldap.listener.InMemoryListenerConfig;
import com.unboundid.ldif.LDIFReader;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URI;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.ProtectionDomain;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventListener;
import java.util.Properties;
import java.util.Scanner;
import org.apache.log4j.PropertyConfigurator;
import org.eclipse.jetty.security.ConstraintMapping;
import org.eclipse.jetty.security.ConstraintSecurityHandler;
import org.eclipse.jetty.security.SecurityHandler;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.session.SessionHandler;
import org.eclipse.jetty.servlet.ListenerHolder;
import org.eclipse.jetty.util.security.Constraint;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.eclipse.jetty.webapp.WebAppContext;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.storage.file.FileBasedConfig;
import org.eclipse.jgit.util.FS;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GitBlitServer {
    private static Logger logger;

    public static void main(String ... args) {
        GitBlitServer server2 = new GitBlitServer();
        ArrayList<String> filtered = new ArrayList<String>();
        String folder = "data";
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (arg.equals("--baseFolder")) {
                if (i + 1 == args.length) {
                    System.out.println("Invalid --baseFolder parameter!");
                    System.exit(-1);
                } else if (!".".equals(args[i + 1])) {
                    folder = args[i + 1];
                }
                ++i;
                continue;
            }
            filtered.add(arg);
        }
        Params.baseFolder = folder;
        Params params = new Params();
        CmdLineParser parser = new CmdLineParser((Object)params);
        try {
            parser.parseArgument(filtered);
            if (params.help.booleanValue()) {
                server2.usage(parser, null);
            }
        }
        catch (CmdLineException t) {
            server2.usage(parser, t);
        }
        if (params.stop.booleanValue()) {
            server2.stop(params);
        } else {
            server2.start(params);
        }
    }

    protected final void usage(CmdLineParser parser, CmdLineException t) {
        System.out.println("*****************************************************************");
        System.out.println(Constants.getGitBlitVersion());
        System.out.println("*****************************************************************");
        System.out.println();
        if (t != null) {
            System.out.println(t.getMessage());
            System.out.println();
        }
        if (parser != null) {
            parser.printUsage((OutputStream)System.out);
            System.out.println("\nExample:\n  java -server -Xmx1024M -cp gitblit.jar:ext/* com.gitblit.GitBlitServer  --repositoriesFolder /srv/git --httpPort 80 --httpsPort 443");
        }
        System.exit(0);
    }

    protected File getBaseFolder(Params params) {
        String path = System.getProperty("GITBLIT_HOME", Params.baseFolder);
        if (!StringUtils.isEmpty(System.getenv("GITBLIT_HOME"))) {
            path = System.getenv("GITBLIT_HOME");
        }
        return new File(path).getAbsoluteFile();
    }

    public void stop(Params params) {
        try {
            Socket s = new Socket(InetAddress.getByName("127.0.0.1"), (int)params.shutdownPort);
            OutputStream out = s.getOutputStream();
            System.out.println("Sending Shutdown Request to Gitblit");
            out.write("\r\n".getBytes());
            out.flush();
            s.close();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void start(Params params) {
        File tempDir;
        final File baseFolder = this.getBaseFolder(params);
        FileSettings settings = params.FILESETTINGS;
        if (!StringUtils.isEmpty(params.settingsfile) && new File(params.settingsfile).exists()) {
            settings = new FileSettings(params.settingsfile);
        }
        if (params.dailyLogFile.booleanValue()) {
            InputStream is = null;
            try {
                is = this.getClass().getResourceAsStream("/log4j.properties");
                Properties loggingProperties = new Properties();
                loggingProperties.load(is);
                loggingProperties.put("log4j.appender.R.File", new File(baseFolder, "logs/gitblit.log").getAbsolutePath());
                loggingProperties.put("log4j.rootCategory", "INFO, R");
                if (settings.getBoolean("web.debugMode", false)) {
                    loggingProperties.put("log4j.logger.com.gitblit", "DEBUG");
                }
                PropertyConfigurator.configure((Properties)loggingProperties);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        logger = LoggerFactory.getLogger(GitBlitServer.class);
        logger.info("\n" + Constants.getASCIIArt());
        System.setProperty("java.awt.headless", "true");
        String osname = System.getProperty("os.name");
        String osversion = System.getProperty("os.version");
        logger.info("Running on " + osname + " (" + osversion + ")");
        String javaversion = System.getProperty("java.version");
        String javavendor = System.getProperty("java.vendor");
        logger.info("JVM version " + javaversion + " (" + javavendor + ")");
        QueuedThreadPool threadPool = new QueuedThreadPool();
        int maxThreads = settings.getInteger("server.threadPoolSize", 50);
        if (maxThreads > 0) {
            threadPool.setMaxThreads(maxThreads);
        }
        Server server2 = new Server((ThreadPool)threadPool);
        server2.setStopAtShutdown(true);
        if (params.securePort > 0) {
            File certificatesConf = new File(baseFolder, "certs/authority.conf");
            File serverKeyStore = new File(baseFolder, "serverKeyStore.jks");
            File serverTrustStore = new File(baseFolder, "serverTrustStore.jks");
            File caRevocationList = new File(baseFolder, "certs/caRevocationList.crl");
            X509Utils.X509Metadata metadata = new X509Utils.X509Metadata("localhost", params.storePassword);
            if (certificatesConf.exists()) {
                FileBasedConfig config = new FileBasedConfig(certificatesConf, FS.detect());
                try {
                    config.load();
                }
                catch (Exception e) {
                    logger.error("Error parsing " + certificatesConf, (Throwable)e);
                }
                NewCertificateConfig certificateConfig = (NewCertificateConfig)NewCertificateConfig.KEY.parse((Config)config);
                certificateConfig.update(metadata);
            }
            metadata.notAfter = new Date(System.currentTimeMillis() + 315360000000L);
            X509Utils.prepareX509Infrastructure(metadata, baseFolder, new X509Utils.X509Log(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void log(String message) {
                    BufferedWriter writer = null;
                    try {
                        writer = new BufferedWriter(new FileWriter(new File(baseFolder, "certs" + File.separator + "log.txt"), true));
                        writer.write(MessageFormat.format("{0,date,yyyy-MM-dd HH:mm}: {1}", new Date(), message));
                        writer.newLine();
                        writer.flush();
                    }
                    catch (Exception e) {
                        LoggerFactory.getLogger(GitblitAuthority.class).error("Failed to append log entry!", (Throwable)e);
                    }
                    finally {
                        if (writer != null) {
                            try {
                                writer.close();
                            }
                            catch (IOException iOException) {}
                        }
                    }
                }
            });
            if (serverKeyStore.exists()) {
                logger.info("Setting up HTTPS transport on port " + params.securePort);
                GitblitSslContextFactory factory = new GitblitSslContextFactory(params.alias, serverKeyStore, serverTrustStore, params.storePassword, caRevocationList);
                Constants.TlsClientCertPolicy clientCertPolicy = Constants.TlsClientCertPolicy.fromString(params.requireClientCertificates);
                if (clientCertPolicy == Constants.TlsClientCertPolicy.REQUIRED) {
                    factory.setNeedClientAuth(true);
                } else if (clientCertPolicy == Constants.TlsClientCertPolicy.OPTIONAL) {
                    factory.setNeedClientAuth(false);
                    factory.setWantClientAuth(true);
                } else {
                    factory.setNeedClientAuth(false);
                    factory.setWantClientAuth(false);
                }
                ServerConnector connector = new ServerConnector(server2, (SslContextFactory)factory);
                connector.setIdleTimeout(settings.getLong("server.httpIdleTimeout", 30000L));
                connector.setPort(params.securePort.intValue());
                String bindInterface = settings.getString("server.httpsBindInterface", null);
                if (!StringUtils.isEmpty(bindInterface)) {
                    logger.warn(MessageFormat.format("Binding HTTPS transport on port {0,number,0} to {1}", params.securePort, bindInterface));
                    connector.setHost(bindInterface);
                }
                if (params.securePort < 1024 && !this.isWindows()) {
                    logger.warn("Gitblit needs to run with ROOT permissions for ports < 1024!");
                }
                server2.addConnector((Connector)connector);
            } else {
                logger.warn("Failed to find or load Keystore?");
                logger.warn("HTTPS transport DISABLED.");
            }
        }
        if (params.port > 0) {
            logger.info("Setting up HTTP transport on port " + params.port);
            HttpConfiguration httpConfig = new HttpConfiguration();
            if (params.port > 0 && params.securePort > 0 && settings.getBoolean("server.redirectToHttpsPort", true)) {
                httpConfig.setSecureScheme("https");
                httpConfig.setSecurePort(params.securePort.intValue());
            }
            httpConfig.setSendServerVersion(false);
            httpConfig.setSendDateHeader(false);
            ServerConnector connector = new ServerConnector(server2, new ConnectionFactory[]{new HttpConnectionFactory(httpConfig)});
            connector.setIdleTimeout(settings.getLong("server.httpIdleTimeout", 30000L));
            connector.setPort(params.port.intValue());
            String bindInterface = settings.getString("server.httpBindInterface", null);
            if (!StringUtils.isEmpty(bindInterface)) {
                logger.warn(MessageFormat.format("Binding HTTP transport on port {0,number,0} to {1}", params.port, bindInterface));
                connector.setHost(bindInterface);
            }
            if (params.port < 1024 && !this.isWindows()) {
                logger.warn("Gitblit needs to run with ROOT permissions for ports < 1024!");
            }
            server2.addConnector((Connector)connector);
        }
        if ((tempDir = FileUtils.resolveParameter("${baseFolder}", baseFolder, params.temp)).exists()) {
            try {
                org.eclipse.jgit.util.FileUtils.delete((File)tempDir, (int)3);
            }
            catch (IOException x) {
                logger.warn("Failed to delete temp dir " + tempDir.getAbsolutePath(), (Throwable)x);
            }
        }
        if (!tempDir.mkdirs()) {
            logger.warn("Failed to create temp dir " + tempDir.getAbsolutePath());
        }
        ProtectionDomain protectionDomain = GitBlitServer.class.getProtectionDomain();
        URL location = protectionDomain.getCodeSource().getLocation();
        WebAppContext rootContext = new WebAppContext();
        rootContext.setContextPath(settings.getString("server.contextPath", "/"));
        rootContext.setServer(server2);
        rootContext.setWar(location.toExternalForm());
        rootContext.setTempDirectory(tempDir);
        SessionHandler sessionHandler = rootContext.getSessionHandler();
        sessionHandler.setHttpOnly(true);
        sessionHandler.setSecureRequestOnly(params.port <= 0 && params.securePort > 0 || params.port > 0 && params.securePort > 0 && settings.getBoolean("server.redirectToHttpsPort", true));
        String realmUsers = params.userService;
        if (StringUtils.isEmpty(realmUsers)) {
            logger.error(MessageFormat.format("PLEASE SPECIFY {0}!!", "realm.userService"));
            return;
        }
        settings.overrideSetting("realm.userService", params.userService);
        settings.overrideSetting("git.repositoriesFolder", params.repositoriesFolder);
        settings.overrideSetting("git.daemonPort", params.gitPort);
        settings.overrideSetting("git.sshPort", params.sshPort);
        try {
            File ldifFile;
            if (!StringUtils.isEmpty(params.ldapLdifFile) && (ldifFile = new File(params.ldapLdifFile)) != null && ldifFile.exists()) {
                URI ldapUrl = new URI(settings.getRequiredString("realm.ldap.server"));
                String firstLine = new Scanner(ldifFile).nextLine();
                String rootDN = firstLine.substring(4);
                String bindUserName = settings.getString("realm.ldap.username", "");
                String bindPassword = settings.getString("realm.ldap.password", "");
                int port = ldapUrl.getPort();
                if (port == -1) {
                    port = 389;
                }
                InMemoryDirectoryServerConfig config = new InMemoryDirectoryServerConfig(new String[]{rootDN});
                config.addAdditionalBindCredentials(bindUserName, bindPassword);
                config.setListenerConfigs(new InMemoryListenerConfig[]{InMemoryListenerConfig.createLDAPConfig((String)"default", (int)port)});
                config.setSchema(null);
                InMemoryDirectoryServer ds = new InMemoryDirectoryServer(config);
                ds.importFromLDIF(true, new LDIFReader(ldifFile));
                ds.startListening();
                logger.info("LDAP Server started at ldap://localhost:" + port);
            }
        }
        catch (Exception e) {
            logger.warn("Unable to start LDAP server", (Throwable)e);
        }
        server2.setHandler((Handler)rootContext);
        if (params.port > 0 && params.securePort > 0 && settings.getBoolean("server.redirectToHttpsPort", true)) {
            logger.info(String.format("Configuring automatic http(%1$s) -> https(%2$s) redirects", params.port, params.securePort));
            Constraint constraint = new Constraint();
            constraint.setDataConstraint(2);
            ConstraintMapping cm = new ConstraintMapping();
            cm.setConstraint(constraint);
            cm.setPathSpec("/*");
            ConstraintSecurityHandler sh = new ConstraintSecurityHandler();
            sh.setConstraintMappings(new ConstraintMapping[]{cm});
            rootContext.setSecurityHandler((SecurityHandler)sh);
        }
        ListenerHolder gitblitHolder = new ListenerHolder(GitblitContext.class);
        gitblitHolder.setListener((EventListener)((Object)this.newGitblit(settings, baseFolder)));
        rootContext.getServletHandler().addListener(gitblitHolder);
        try {
            if (params.shutdownPort > 0) {
                ShutdownMonitorThread shutdownMonitor = new ShutdownMonitorThread(server2, params);
                shutdownMonitor.start();
            }
            server2.start();
            server2.join();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(100);
        }
    }

    protected GitblitContext newGitblit(IStoredSettings settings, File baseFolder) {
        return new GitblitContext(settings, baseFolder);
    }

    private boolean isWindows() {
        return System.getProperty("os.name").toLowerCase().indexOf("windows") > -1;
    }

    public static class Params {
        public static String baseFolder;
        private final FileSettings FILESETTINGS = new FileSettings(new File(baseFolder, "gitblit.properties").getAbsolutePath());
        @Option(name="--help", aliases={"-h"}, usage="Show this help")
        public Boolean help = false;
        @Option(name="--stop", usage="Stop Server")
        public Boolean stop = false;
        @Option(name="--tempFolder", usage="Folder for server to extract built-in webapp", metaVar="PATH")
        public String temp = this.FILESETTINGS.getString("server.tempFolder", "temp");
        @Option(name="--dailyLogFile", usage="Log to a rolling daily log file INSTEAD of stdout.")
        public Boolean dailyLogFile = false;
        @Option(name="--repositoriesFolder", usage="Git Repositories Folder", metaVar="PATH")
        public String repositoriesFolder = this.FILESETTINGS.getString("git.repositoriesFolder", "git");
        @Option(name="--userService", usage="Authentication and Authorization Service (filename or fully qualified classname)")
        public String userService = this.FILESETTINGS.getString("realm.userService", "users.conf");
        @Option(name="--httpPort", usage="HTTP port for to serve. (port <= 0 will disable this connector)", metaVar="PORT")
        public Integer port = this.FILESETTINGS.getInteger("server.httpPort", 0);
        @Option(name="--httpsPort", usage="HTTPS port to serve.  (port <= 0 will disable this connector)", metaVar="PORT")
        public Integer securePort = this.FILESETTINGS.getInteger("server.httpsPort", 8443);
        @Option(name="--gitPort", usage="Git Daemon port to serve.  (port <= 0 will disable this connector)", metaVar="PORT")
        public Integer gitPort = this.FILESETTINGS.getInteger("git.daemonPort", 9418);
        @Option(name="--sshPort", usage="Git SSH port to serve.  (port <= 0 will disable this connector)", metaVar="PORT")
        public Integer sshPort = this.FILESETTINGS.getInteger("git.sshPort", 29418);
        @Option(name="--alias", usage="Alias of SSL certificate in keystore for serving https.", metaVar="ALIAS")
        public String alias = this.FILESETTINGS.getString("server.certificateAlias", "");
        @Option(name="--storePassword", usage="Password for SSL (https) keystore.", metaVar="PASSWORD")
        public String storePassword = this.FILESETTINGS.getString("server.storePassword", "");
        @Option(name="--shutdownPort", usage="Port for Shutdown Monitor to listen on. (port <= 0 will disable this monitor)", metaVar="PORT")
        public Integer shutdownPort = this.FILESETTINGS.getInteger("server.shutdownPort", 8081);
        @Option(name="--requireClientCertificates", usage="Require client X509 certificates for https connections.")
        public String requireClientCertificates = this.FILESETTINGS.getString("server.requireClientCertificates", "optional");
        @Option(name="--settings", usage="Path to alternative settings", metaVar="FILE")
        public String settingsfile;
        @Option(name="--ldapLdifFile", usage="Path to LDIF file.  This will cause an in-memory LDAP server to be started according to gitblit settings", metaVar="FILE")
        public String ldapLdifFile;
    }

    private static class ShutdownMonitorThread
    extends Thread {
        private final ServerSocket socket;
        private final Server server;
        private final Logger logger = LoggerFactory.getLogger(ShutdownMonitorThread.class);

        public ShutdownMonitorThread(Server server2, Params params) {
            this.server = server2;
            this.setDaemon(true);
            this.setName("Gitblit Shutdown Monitor");
            ServerSocket skt = null;
            try {
                skt = new ServerSocket(params.shutdownPort, 1, InetAddress.getByName("127.0.0.1"));
            }
            catch (Exception e) {
                this.logger.warn("Could not open shutdown monitor on port " + params.shutdownPort, (Throwable)e);
            }
            this.socket = skt;
        }

        @Override
        public void run() {
            if (null != this.socket) {
                this.logger.info("Shutdown Monitor listening on port " + this.socket.getLocalPort());
                try {
                    Socket accept = this.socket.accept();
                    BufferedReader reader = new BufferedReader(new InputStreamReader(accept.getInputStream()));
                    reader.readLine();
                    this.logger.info("*****************************************************************");
                    this.logger.info("Stopping Gitblit");
                    this.logger.info("*****************************************************************");
                    this.server.stop();
                    this.server.setStopAtShutdown(false);
                    accept.close();
                    this.socket.close();
                }
                catch (Exception e) {
                    this.logger.warn("Failed to shutdown Jetty", (Throwable)e);
                }
            }
        }
    }
}

