/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit;

import com.gitblit.GitblitTrustManager;
import com.gitblit.utils.StringUtils;
import java.io.File;
import java.security.KeyStore;
import java.security.cert.CRL;
import java.util.Collection;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GitblitSslContextFactory
extends SslContextFactory {
    private static final Logger logger = LoggerFactory.getLogger(GitblitSslContextFactory.class);
    private final File caRevocationList;

    public GitblitSslContextFactory(String certAlias, File keyStore, File clientTrustStore, String storePassword, File caRevocationList) {
        super(keyStore.getAbsolutePath());
        this.caRevocationList = caRevocationList;
        if (!StringUtils.isEmpty(certAlias)) {
            logger.info("   certificate alias = " + certAlias);
            this.setCertAlias(certAlias);
        }
        this.setKeyStorePassword(storePassword);
        this.setTrustStorePath(clientTrustStore.getAbsolutePath());
        this.setTrustStorePassword(storePassword);
        this.addExcludeProtocols(new String[]{"SSLv3"});
        logger.info("   keyStorePath   = " + keyStore.getAbsolutePath());
        logger.info("   trustStorePath = " + clientTrustStore.getAbsolutePath());
        logger.info("   crlPath        = " + caRevocationList.getAbsolutePath());
    }

    protected TrustManager[] getTrustManagers(KeyStore trustStore, Collection<? extends CRL> crls) throws Exception {
        TrustManager[] managers = super.getTrustManagers(trustStore, crls);
        X509TrustManager delegate = (X509TrustManager)managers[0];
        GitblitTrustManager root = new GitblitTrustManager(delegate, this.caRevocationList);
        managers[0] = root;
        return managers;
    }
}

