/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit;

import com.gitblit.Constants;
import com.gitblit.FileSettings;
import com.gitblit.IStoredSettings;
import com.gitblit.manager.RepositoryManager;
import com.gitblit.manager.RuntimeManager;
import com.gitblit.tickets.BranchTicketService;
import com.gitblit.tickets.FileTicketService;
import com.gitblit.tickets.ITicketService;
import com.gitblit.tickets.RedisTicketService;
import com.gitblit.utils.StringUtils;
import com.gitblit.utils.XssFilter;
import java.io.File;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;

public class ReindexTickets {
    public static void main(String ... args) {
        ReindexTickets reindex = new ReindexTickets();
        ArrayList<String> filtered = new ArrayList<String>();
        String folder = "data";
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (arg.equals("--baseFolder")) {
                if (i + 1 == args.length) {
                    System.out.println("Invalid --baseFolder parameter!");
                    System.exit(-1);
                } else if (!".".equals(args[i + 1])) {
                    folder = args[i + 1];
                }
                ++i;
                continue;
            }
            filtered.add(arg);
        }
        Params.baseFolder = folder;
        Params params = new Params();
        CmdLineParser parser = new CmdLineParser((Object)params);
        try {
            parser.parseArgument(filtered);
            if (params.help.booleanValue()) {
                reindex.usage(parser, null);
                return;
            }
        }
        catch (CmdLineException t) {
            reindex.usage(parser, t);
            return;
        }
        FileSettings settings = params.FILESETTINGS;
        if (!StringUtils.isEmpty(params.settingsfile) && new File(params.settingsfile).exists()) {
            settings = new FileSettings(params.settingsfile);
        }
        reindex.reindex(new File(Params.baseFolder), settings);
        System.exit(0);
    }

    protected final void usage(CmdLineParser parser, CmdLineException t) {
        System.out.println("*****************************************************************");
        System.out.println(Constants.getGitBlitVersion());
        System.out.println("*****************************************************************");
        System.out.println();
        if (t != null) {
            System.out.println(t.getMessage());
            System.out.println();
        }
        if (parser != null) {
            parser.printUsage((OutputStream)System.out);
            System.out.println("\nExample:\n  java -cp gitblit.jar;\"%CD%/ext/*\" com.gitblit.ReindexTickets --baseFolder c:\\gitblit-data");
        }
        System.exit(0);
    }

    protected void reindex(File baseFolder, IStoredSettings settings) {
        settings.overrideSetting("web.allowLuceneIndexing", false);
        settings.overrideSetting("git.enableGarbageCollection", false);
        settings.overrideSetting("git.enableMirroring", false);
        settings.overrideSetting("web.activityCacheDays", 0);
        XssFilter.AllowXssFilter xssFilter = new XssFilter.AllowXssFilter();
        RuntimeManager runtimeManager = new RuntimeManager(settings, xssFilter, baseFolder).start();
        RepositoryManager repositoryManager = new RepositoryManager(runtimeManager, null, null).start();
        String serviceName = settings.getString("tickets.service", BranchTicketService.class.getSimpleName());
        if (StringUtils.isEmpty(serviceName)) {
            System.err.println(MessageFormat.format("Please define a ticket service in \"{0}\"", "tickets.service"));
            System.exit(1);
        }
        ITicketService ticketService = null;
        try {
            Class<?> serviceClass = Class.forName(serviceName);
            if (RedisTicketService.class.isAssignableFrom(serviceClass)) {
                ticketService = new RedisTicketService(runtimeManager, null, null, null, repositoryManager).start();
            } else if (BranchTicketService.class.isAssignableFrom(serviceClass)) {
                ticketService = new BranchTicketService(runtimeManager, null, null, null, repositoryManager).start();
            } else if (FileTicketService.class.isAssignableFrom(serviceClass)) {
                ticketService = new FileTicketService(runtimeManager, null, null, null, repositoryManager).start();
            } else {
                System.err.println("Unknown ticket service " + serviceName);
                System.exit(1);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        ticketService.reindex();
        ticketService.stop();
        repositoryManager.stop();
        runtimeManager.stop();
    }

    public static class Params {
        public static String baseFolder;
        @Option(name="--help", aliases={"-h"}, usage="Show this help")
        public Boolean help = false;
        private final FileSettings FILESETTINGS = new FileSettings(new File(baseFolder, "gitblit.properties").getAbsolutePath());
        @Option(name="--repositoriesFolder", usage="Git Repositories Folder", metaVar="PATH")
        public String repositoriesFolder = this.FILESETTINGS.getString("git.repositoriesFolder", "git");
        @Option(name="--settings", usage="Path to alternative settings", metaVar="FILE")
        public String settingsfile;
    }
}

