/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.SortedMap;
import java.util.TreeMap;

public class StoredUserConfig {
    private final File realmFileCopy;
    private SortedMap<String, Section> sections = new TreeMap<String, Section>();

    public StoredUserConfig(File realmFileCopy) {
        this.realmFileCopy = realmFileCopy;
    }

    public void setString(String section, String subsection, String name, String value) {
        String key = StoredUserConfig.generateKey(section, subsection);
        Section s = (Section)this.sections.get(key);
        if (s == null) {
            s = new Section(section, subsection);
            this.sections.put(key, s);
        }
        s.addEntry(name, value);
    }

    public void setBoolean(String section, String subsection, String name, boolean value) {
        this.setString(section, subsection, name, String.valueOf(value));
    }

    public void setStringList(String section, String subsection, String name, List<String> list) {
        for (String value : list) {
            this.setString(section, subsection, name, value);
        }
    }

    public void save() throws IOException {
        try (FileWriter fileWriter = new FileWriter(this.realmFileCopy);
             PrintWriter printWriter = new PrintWriter(fileWriter);){
            for (Map.Entry<String, Section> entry : this.sections.entrySet()) {
                StoredUserConfig.writeSection(printWriter, entry.getKey(), entry.getValue());
            }
        }
    }

    private static void writeSection(PrintWriter printWriter, String key, Section section) {
        if (section.getSubSection() == null) {
            printWriter.printf("[%s]\n", section.getName());
        } else {
            printWriter.printf("[%s \"%s\"]\n", section.getName(), section.getSubSection());
        }
        for (Entry entry : section.getEntries().values()) {
            StoredUserConfig.writeEntry(printWriter, entry.getKey(), entry.getValue());
        }
    }

    private static void writeEntry(PrintWriter printWriter, String key, String value) {
        printWriter.printf("\t%s = %s\n", key, StoredUserConfig.escape(value));
    }

    private static String escape(String value) {
        boolean quoteIt = false;
        StringBuilder fixedValue = new StringBuilder(value.length() + 20);
        block8: for (char c : value.toCharArray()) {
            switch (c) {
                case '\n': {
                    fixedValue.append("\\n");
                    continue block8;
                }
                case '\t': {
                    fixedValue.append("\\t");
                    continue block8;
                }
                case '\b': {
                    fixedValue.append("\\b");
                    continue block8;
                }
                case '\\': {
                    fixedValue.append("\\\\");
                    continue block8;
                }
                case '\"': {
                    fixedValue.append("\\\"");
                    continue block8;
                }
                case '#': 
                case ';': {
                    quoteIt = true;
                    fixedValue.append(c);
                    continue block8;
                }
                default: {
                    fixedValue.append(c);
                }
            }
        }
        if (quoteIt) {
            fixedValue.insert(0, "\"");
            fixedValue.append("\"");
        }
        return fixedValue.toString();
    }

    private static String generateKey(String key, String subKey) {
        return "k:" + key + "s:" + (subKey == null ? "" : subKey);
    }

    private static class Entry {
        private final String key;
        private final String value;

        public Entry(String key, String value) {
            this.key = key;
            this.value = value;
        }

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }

        public int hashCode() {
            return Objects.hash(this.key, this.value);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Entry other = (Entry)obj;
            return Objects.equals(this.key, other.key) && Objects.equals(this.value, other.value);
        }

        public String toString() {
            return String.format("Entry [key=%s, value=%s]", this.key, this.value);
        }
    }

    private static class Section {
        private final String name;
        private final String subSection;
        private final SortedMap<String, Entry> entries = new TreeMap<String, Entry>();

        public Section(String name, String subSection) {
            this.name = name;
            this.subSection = subSection;
        }

        public void addEntry(String key, String value) {
            this.entries.put(StoredUserConfig.generateKey(key, value), new Entry(key, value));
        }

        public String getName() {
            return this.name;
        }

        public String getSubSection() {
            return this.subSection;
        }

        public SortedMap<String, Entry> getEntries() {
            return this.entries;
        }

        public int hashCode() {
            return Objects.hash(this.name, this.subSection);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Section other = (Section)obj;
            return Objects.equals(this.name, other.name) && Objects.equals(this.subSection, other.subSection);
        }

        public String toString() {
            return String.format("Section [name=%s, subSection=%s]", this.name, this.subSection);
        }
    }
}

