/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.auth;

import com.gitblit.Constants;
import com.gitblit.IStoredSettings;
import com.gitblit.manager.IRuntimeManager;
import com.gitblit.manager.IUserManager;
import com.gitblit.models.TeamModel;
import com.gitblit.models.UserModel;
import com.gitblit.utils.DeepCopier;
import com.gitblit.utils.StringUtils;
import java.io.File;
import java.math.BigInteger;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AuthenticationProvider {
    public static NullProvider NULL_PROVIDER = new NullProvider();
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final String serviceName;
    protected File baseFolder;
    protected IStoredSettings settings;
    protected IRuntimeManager runtimeManager;
    protected IUserManager userManager;

    protected AuthenticationProvider(String serviceName) {
        this.serviceName = serviceName;
    }

    public File getFileOrFolder(String key, String defaultFileOrFolder) {
        return this.runtimeManager.getFileOrFolder(key, defaultFileOrFolder);
    }

    public final void setup(IRuntimeManager runtimeManager, IUserManager userManager) {
        this.baseFolder = runtimeManager.getBaseFolder();
        this.settings = runtimeManager.getSettings();
        this.runtimeManager = runtimeManager;
        this.userManager = userManager;
        this.setup();
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public abstract Constants.AuthenticationType getAuthenticationType();

    protected void setCookie(UserModel user) {
        if (StringUtils.isEmpty(user.cookie)) {
            user.cookie = user.createCookie();
        }
    }

    protected void updateUser(UserModel userModel) {
        BigInteger userLocalDBcheck;
        UserModel userLocalDB = this.userManager.getUserModel(userModel.getName());
        BigInteger userCurrentCheck = DeepCopier.checksum(userModel);
        if (!userCurrentCheck.equals(userLocalDBcheck = DeepCopier.checksum(userLocalDB))) {
            this.userManager.updateUserModel(userModel);
        }
    }

    protected void updateTeam(TeamModel teamModel) {
        BigInteger teamLocalDBcheck;
        TeamModel teamLocalDB = this.userManager.getTeamModel(teamModel.name);
        BigInteger teamCurrentCheck = DeepCopier.checksum(teamModel);
        if (!teamCurrentCheck.equals(teamLocalDBcheck = DeepCopier.checksum(teamLocalDB))) {
            this.userManager.updateTeamModel(teamModel);
        }
    }

    public abstract void setup();

    public abstract void stop();

    public abstract UserModel authenticate(HttpServletRequest var1);

    public abstract UserModel authenticate(String var1, char[] var2);

    public abstract Constants.AccountType getAccountType();

    public abstract boolean supportsCredentialChanges();

    public abstract boolean supportsDisplayNameChanges();

    public abstract boolean supportsEmailAddressChanges();

    public abstract boolean supportsTeamMembershipChanges();

    public abstract boolean supportsRoleChanges(UserModel var1, Constants.Role var2);

    public abstract boolean supportsRoleChanges(TeamModel var1, Constants.Role var2);

    public String toString() {
        return this.getServiceName() + " (" + this.getClass().getName() + ")";
    }

    public static class NullProvider
    extends AuthenticationProvider {
        protected NullProvider() {
            super("NULL");
        }

        @Override
        public void setup() {
        }

        @Override
        public void stop() {
        }

        @Override
        public UserModel authenticate(HttpServletRequest httpRequest) {
            return null;
        }

        @Override
        public UserModel authenticate(String username, char[] password) {
            return null;
        }

        @Override
        public Constants.AccountType getAccountType() {
            return Constants.AccountType.LOCAL;
        }

        @Override
        public Constants.AuthenticationType getAuthenticationType() {
            return null;
        }

        @Override
        public boolean supportsCredentialChanges() {
            return true;
        }

        @Override
        public boolean supportsDisplayNameChanges() {
            return true;
        }

        @Override
        public boolean supportsEmailAddressChanges() {
            return true;
        }

        @Override
        public boolean supportsTeamMembershipChanges() {
            return true;
        }

        @Override
        public boolean supportsRoleChanges(UserModel user, Constants.Role role) {
            return true;
        }

        @Override
        public boolean supportsRoleChanges(TeamModel team, Constants.Role role) {
            return true;
        }
    }

    public static abstract class UsernamePasswordAuthenticationProvider
    extends AuthenticationProvider {
        protected UsernamePasswordAuthenticationProvider(String serviceName) {
            super(serviceName);
        }

        @Override
        public UserModel authenticate(HttpServletRequest httpRequest) {
            return null;
        }

        @Override
        public Constants.AuthenticationType getAuthenticationType() {
            return Constants.AuthenticationType.CREDENTIALS;
        }

        @Override
        public void stop() {
        }
    }
}

