/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.auth;

import com.gitblit.Constants;
import com.gitblit.auth.AuthenticationProvider;
import com.gitblit.models.TeamModel;
import com.gitblit.models.UserModel;
import com.gitblit.utils.StringUtils;
import java.util.HashSet;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpHeaderAuthProvider
extends AuthenticationProvider {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected String userHeaderName;
    protected String teamHeaderName;
    protected String teamHeaderSeparator;

    public HttpHeaderAuthProvider() {
        super("httpheader");
    }

    @Override
    public void setup() {
        this.userHeaderName = this.settings.getString("realm.httpheader.userheader", null);
        this.teamHeaderName = this.settings.getString("realm.httpheader.teamheader", null);
        this.teamHeaderSeparator = this.settings.getString("realm.httpheader.teamseparator", ",");
        if (StringUtils.isEmpty(this.userHeaderName)) {
            this.logger.warn("HTTP Header authentication is enabled, but no header is not defined in realm.httpheader.userheader");
        }
    }

    @Override
    public void stop() {
    }

    @Override
    public UserModel authenticate(HttpServletRequest httpRequest) {
        String headerUserName;
        if (!(StringUtils.isEmpty(this.userHeaderName) || StringUtils.isEmpty(headerUserName = httpRequest.getHeader(this.userHeaderName)) || this.userManager.isInternalAccount(headerUserName))) {
            UserModel user;
            String headerTeamValue;
            HashSet<TeamModel> userTeams = new HashSet<TeamModel>();
            if (!StringUtils.isEmpty(this.teamHeaderName) && !StringUtils.isEmpty(headerTeamValue = httpRequest.getHeader(this.teamHeaderName))) {
                String[] headerTeamNames;
                for (String teamName : headerTeamNames = headerTeamValue.split(this.teamHeaderSeparator)) {
                    if (StringUtils.isEmpty(teamName = teamName.trim())) continue;
                    TeamModel team = this.userManager.getTeamModel(teamName);
                    if (null == team) {
                        team = new TeamModel(teamName);
                        team.accountType = Constants.AccountType.HTTPHEADER;
                        this.updateTeam(team);
                    }
                    userTeams.add(team);
                }
            }
            if ((user = this.userManager.getUserModel(headerUserName)) != null) {
                if (!StringUtils.isEmpty(this.teamHeaderName)) {
                    user.teams.clear();
                    user.teams.addAll(userTeams);
                }
                this.updateUser(user);
                return user;
            }
            if (this.settings.getBoolean("realm.httpheader.autoCreateAccounts", false)) {
                user = new UserModel(headerUserName.toLowerCase());
                user.displayName = headerUserName;
                user.password = "#externalAccount";
                user.accountType = Constants.AccountType.HTTPHEADER;
                user.teams.addAll(userTeams);
                this.updateUser(user);
                return user;
            }
        }
        return null;
    }

    @Override
    public UserModel authenticate(String username, char[] password) {
        return null;
    }

    @Override
    public Constants.AccountType getAccountType() {
        return Constants.AccountType.HTTPHEADER;
    }

    @Override
    public Constants.AuthenticationType getAuthenticationType() {
        return Constants.AuthenticationType.HTTPHEADER;
    }

    @Override
    public boolean supportsCredentialChanges() {
        return false;
    }

    @Override
    public boolean supportsDisplayNameChanges() {
        return false;
    }

    @Override
    public boolean supportsEmailAddressChanges() {
        return false;
    }

    @Override
    public boolean supportsTeamMembershipChanges() {
        return StringUtils.isEmpty(this.teamHeaderName);
    }

    @Override
    public boolean supportsRoleChanges(UserModel user, Constants.Role role) {
        return true;
    }

    @Override
    public boolean supportsRoleChanges(TeamModel team, Constants.Role role) {
        return true;
    }
}

