/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.auth;

import com.gitblit.Constants;
import com.gitblit.auth.AuthenticationProvider;
import com.gitblit.models.TeamModel;
import com.gitblit.models.UserModel;
import com.gitblit.utils.ConnectionUtils;
import com.gitblit.utils.StringUtils;
import com.google.gson.Gson;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import org.apache.commons.io.IOUtils;

public class RedmineAuthProvider
extends AuthenticationProvider.UsernamePasswordAuthenticationProvider {
    private String testingJson;

    public RedmineAuthProvider() {
        super("redmine");
    }

    @Override
    public void setup() {
    }

    @Override
    public boolean supportsCredentialChanges() {
        return false;
    }

    @Override
    public boolean supportsDisplayNameChanges() {
        return false;
    }

    @Override
    public boolean supportsEmailAddressChanges() {
        return false;
    }

    @Override
    public boolean supportsTeamMembershipChanges() {
        return false;
    }

    @Override
    public boolean supportsRoleChanges(UserModel user, Constants.Role role) {
        return true;
    }

    @Override
    public boolean supportsRoleChanges(TeamModel team, Constants.Role role) {
        return true;
    }

    @Override
    public Constants.AccountType getAccountType() {
        return Constants.AccountType.REDMINE;
    }

    @Override
    public UserModel authenticate(String username, char[] password) {
        UserModel user;
        String jsonString = null;
        try {
            jsonString = this.getCurrentUserAsJson(username, password);
        }
        catch (Exception e1) {
            this.logger.warn("Failed to authenticate via username/password against Redmine");
            try {
                jsonString = this.getCurrentUserAsJson(null, password);
                username = null;
            }
            catch (Exception e2) {
                this.logger.error("Failed to authenticate via apikey against Redmine", (Throwable)e2);
                return null;
            }
        }
        if (StringUtils.isEmpty(jsonString)) {
            this.logger.error("Received empty authentication response from Redmine");
            return null;
        }
        RedmineCurrent current = null;
        try {
            current = (RedmineCurrent)new Gson().fromJson(jsonString, RedmineCurrent.class);
        }
        catch (Exception e) {
            this.logger.error("Failed to deserialize Redmine json response: " + jsonString, (Throwable)e);
            return null;
        }
        if (StringUtils.isEmpty(username)) {
            username = current.user.mail;
        }
        if ((user = this.userManager.getUserModel(username)) == null) {
            user = new UserModel(username.toLowerCase());
        }
        this.setCookie(user);
        user.accountType = this.getAccountType();
        user.displayName = current.user.firstname + " " + current.user.lastname;
        user.emailAddress = current.user.mail;
        user.password = "#externalAccount";
        this.updateUser(user);
        return user;
    }

    private String getCurrentUserAsJson(String username, char[] password) throws IOException {
        HttpURLConnection http;
        if (this.testingJson != null) {
            return this.testingJson;
        }
        String url = this.settings.getString("realm.redmine.url", "");
        if (!url.endsWith("/")) {
            url = url.concat("/");
        }
        String apiUrl = url + "users/current.json";
        if (username == null) {
            String apiKey = String.valueOf(password);
            http = (HttpURLConnection)ConnectionUtils.openConnection(apiUrl, null, null);
            http.addRequestProperty("X-Redmine-API-Key", apiKey);
        } else {
            http = (HttpURLConnection)ConnectionUtils.openConnection(apiUrl, username, password);
        }
        http.setRequestMethod("GET");
        http.connect();
        InputStreamReader reader = new InputStreamReader(http.getInputStream());
        return IOUtils.toString((Reader)reader);
    }

    public void setTestingCurrentUserAsJson(String json) {
        this.testingJson = json;
    }

    private class RedmineCurrent {
        public RedmineUser user;

        private RedmineCurrent() {
        }

        private class RedmineUser {
            public String login;
            public String firstname;
            public String lastname;
            public String mail;

            private RedmineUser() {
            }
        }
    }
}

