/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.authority;

import com.gitblit.authority.CertificateStatus;
import com.gitblit.authority.UserCertificateModel;
import com.gitblit.client.Translation;
import com.gitblit.utils.X509Utils;
import java.math.BigInteger;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import javax.swing.table.AbstractTableModel;

public class CertificatesTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    UserCertificateModel ucm;

    @Override
    public int getRowCount() {
        return this.ucm == null || this.ucm.certs == null ? 0 : this.ucm.certs.size();
    }

    @Override
    public int getColumnCount() {
        return Columns.values().length;
    }

    @Override
    public String getColumnName(int column) {
        Columns col = Columns.values()[column];
        switch (col) {
            case SerialNumber: {
                return Translation.get("gb.serialNumber");
            }
            case Issued: {
                return Translation.get("gb.issued");
            }
            case Expires: {
                return Translation.get("gb.expires");
            }
            case Status: {
                return Translation.get("gb.status");
            }
            case Reason: {
                return Translation.get("gb.reason");
            }
        }
        return "";
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        Columns col = Columns.values()[columnIndex];
        switch (col) {
            case Status: {
                return CertificateStatus.class;
            }
            case Issued: {
                return Date.class;
            }
            case Expires: {
                return Date.class;
            }
            case SerialNumber: {
                return BigInteger.class;
            }
        }
        return String.class;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        Columns col = Columns.values()[columnIndex];
        switch (col) {
            default: 
        }
        return false;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        X509Certificate cert = this.ucm.certs.get(rowIndex);
        Columns col = Columns.values()[columnIndex];
        switch (col) {
            case Status: {
                return this.ucm.getStatus(cert);
            }
            case SerialNumber: {
                return cert.getSerialNumber();
            }
            case Issued: {
                return cert.getNotBefore();
            }
            case Expires: {
                return cert.getNotAfter();
            }
            case Reason: {
                if (!this.ucm.getStatus(cert).equals((Object)CertificateStatus.revoked)) break;
                X509Utils.RevocationReason r = this.ucm.getRevocationReason(cert.getSerialNumber());
                return Translation.get("gb." + r.name());
            }
        }
        return null;
    }

    public X509Certificate get(int modelRow) {
        return this.ucm.certs.get(modelRow);
    }

    public void setUserCertificateModel(UserCertificateModel ucm) {
        this.ucm = ucm;
        if (ucm == null) {
            return;
        }
        Collections.sort(ucm.certs, new Comparator<X509Certificate>(){

            @Override
            public int compare(X509Certificate o1, X509Certificate o2) {
                int result = o2.getNotBefore().compareTo(o1.getNotBefore());
                if (result == 0) {
                    boolean r1 = CertificatesTableModel.this.ucm.isRevoked(o1.getSerialNumber());
                    boolean r2 = CertificatesTableModel.this.ucm.isRevoked(o2.getSerialNumber());
                    if (r1 && r2 || !r1 && !r2) {
                        result = o1.getNotAfter().compareTo(o2.getNotAfter());
                    } else {
                        if (r1) {
                            return 1;
                        }
                        return -1;
                    }
                }
                return result;
            }
        });
    }

    static enum Columns {
        SerialNumber,
        Status,
        Reason,
        Issued,
        Expires;


        public String toString() {
            return this.name().replace('_', ' ');
        }
    }
}

