/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.authority;

import com.gitblit.authority.Utils;
import com.gitblit.client.Translation;
import com.gitblit.utils.X509Utils;
import java.awt.GridLayout;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class DefaultOidsPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JTextField organizationalUnit;
    private JTextField organization;
    private JTextField locality;
    private JTextField stateProvince;
    private JTextField countryCode;

    public DefaultOidsPanel(X509Utils.X509Metadata metadata) {
        this.organizationalUnit = new JTextField(metadata.getOID("OU", ""), 20);
        this.organization = new JTextField(metadata.getOID("O", ""), 20);
        this.locality = new JTextField(metadata.getOID("L", ""), 20);
        this.stateProvince = new JTextField(metadata.getOID("ST", ""), 20);
        this.countryCode = new JTextField(metadata.getOID("C", ""), 20);
        this.setLayout(new GridLayout(0, 1, 5, 5));
        this.add(Utils.newFieldPanel(Translation.get("gb.organizationalUnit") + " (OU)", this.organizationalUnit));
        this.add(Utils.newFieldPanel(Translation.get("gb.organization") + " (O)", this.organization));
        this.add(Utils.newFieldPanel(Translation.get("gb.locality") + " (L)", this.locality));
        this.add(Utils.newFieldPanel(Translation.get("gb.stateProvince") + " (ST)", this.stateProvince));
        this.add(Utils.newFieldPanel(Translation.get("gb.countryCode") + " (C)", this.countryCode));
    }

    public void update(X509Utils.X509Metadata metadata) {
        metadata.setOID("OU", this.organizationalUnit.getText());
        metadata.setOID("O", this.organization.getText());
        metadata.setOID("L", this.locality.getText());
        metadata.setOID("ST", this.stateProvince.getText());
        metadata.setOID("C", this.countryCode.getText());
    }

    public String getOrganizationalUnit() {
        return this.organizationalUnit.getText();
    }

    public String getOrganization() {
        return this.organization.getText();
    }

    public String getLocality() {
        return this.locality.getText();
    }

    public String getStateProvince() {
        return this.stateProvince.getText();
    }

    public String getCountryCode() {
        return this.countryCode.getText();
    }
}

