/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.authority;

import com.gitblit.utils.StringUtils;
import com.gitblit.utils.X509Utils;
import java.util.Date;
import org.eclipse.jgit.lib.Config;

public class NewCertificateConfig {
    public static final Config.SectionParser<NewCertificateConfig> KEY = new Config.SectionParser<NewCertificateConfig>(){

        public NewCertificateConfig parse(Config cfg) {
            return new NewCertificateConfig(cfg);
        }
    };
    public String OU;
    public String O;
    public String L;
    public String ST;
    public String C;
    public int duration;

    private NewCertificateConfig(Config c) {
        this.duration = c.getInt("new", null, "duration", 0);
        this.OU = c.getString("new", null, "organizationalUnit");
        this.O = c.getString("new", null, "organization");
        this.L = c.getString("new", null, "locality");
        this.ST = c.getString("new", null, "stateProvince");
        this.C = c.getString("new", null, "countryCode");
    }

    public void update(X509Utils.X509Metadata metadata) {
        this.update(metadata, "OU", this.OU);
        this.update(metadata, "O", this.O);
        this.update(metadata, "L", this.L);
        this.update(metadata, "ST", this.ST);
        this.update(metadata, "C", this.C);
        if (this.duration > 0) {
            metadata.notAfter = new Date(System.currentTimeMillis() + (long)this.duration * 86400000L);
        }
    }

    private void update(X509Utils.X509Metadata metadata, String oid, String value) {
        if (!StringUtils.isEmpty(value)) {
            metadata.oids.put(oid, value);
        }
    }

    public void store(Config c, X509Utils.X509Metadata metadata) {
        this.store(c, "new", "organizationalUnit", metadata.getOID("OU", null));
        this.store(c, "new", "organization", metadata.getOID("O", null));
        this.store(c, "new", "locality", metadata.getOID("L", null));
        this.store(c, "new", "stateProvince", metadata.getOID("ST", null));
        this.store(c, "new", "countryCode", metadata.getOID("C", null));
        if (this.duration <= 0) {
            c.unset("new", null, "duration");
        } else {
            c.setInt("new", null, "duration", this.duration);
        }
    }

    private void store(Config c, String section, String name, String value) {
        if (StringUtils.isEmpty(value)) {
            c.unset(section, null, name);
        } else {
            c.setString(section, null, name, value);
        }
    }
}

