/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.authority;

import com.gitblit.authority.UserCertificateModel;
import com.gitblit.models.UserModel;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jgit.lib.Config;
import org.slf4j.LoggerFactory;

public class UserCertificateConfig {
    public static final Config.SectionParser<UserCertificateConfig> KEY = new Config.SectionParser<UserCertificateConfig>(){

        public UserCertificateConfig parse(Config cfg) {
            return new UserCertificateConfig(cfg);
        }
    };
    public final List<UserCertificateModel> list;

    private UserCertificateConfig(Config c) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
        this.list = new ArrayList<UserCertificateModel>();
        for (String username : c.getSubsections("user")) {
            UserCertificateModel uc = new UserCertificateModel(new UserModel(username));
            try {
                uc.expires = df.parse(c.getString("user", username, "expires"));
            }
            catch (ParseException e) {
                LoggerFactory.getLogger(UserCertificateConfig.class).error("Failed to parse date!", (Throwable)e);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            uc.notes = c.getString("user", username, "notes");
            uc.revoked = new ArrayList<String>(Arrays.asList(c.getStringList("user", username, "revoked")));
            this.list.add(uc);
        }
    }

    public UserCertificateModel getUserCertificateModel(String username) {
        for (UserCertificateModel ucm : this.list) {
            if (!ucm.user.username.equalsIgnoreCase(username)) continue;
            return ucm;
        }
        return null;
    }
}

