/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.authority;

import com.gitblit.authority.AuthorityWorker;
import com.gitblit.authority.CertificateStatus;
import com.gitblit.authority.CertificateStatusRenderer;
import com.gitblit.authority.CertificatesTableModel;
import com.gitblit.authority.NewClientCertificateDialog;
import com.gitblit.authority.UserCertificateModel;
import com.gitblit.authority.UserOidsPanel;
import com.gitblit.authority.Utils;
import com.gitblit.authority.X509CertificateViewer;
import com.gitblit.client.HeaderPanel;
import com.gitblit.client.Translation;
import com.gitblit.models.UserModel;
import com.gitblit.utils.X509Utils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.security.cert.X509Certificate;
import java.text.MessageFormat;
import java.util.Date;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableRowSorter;

public abstract class UserCertificatePanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private Frame owner;
    private UserCertificateModel ucm;
    private UserOidsPanel oidsPanel;
    private CertificatesTableModel tableModel;
    private JButton saveUserButton;
    private JButton editUserButton;
    private JButton newCertificateButton;
    private JButton revokeCertificateButton;
    private JTable table;

    public UserCertificatePanel(Frame owner) {
        super(new BorderLayout());
        this.owner = owner;
        this.oidsPanel = new UserOidsPanel();
        JPanel fp = new JPanel(new BorderLayout(5, 5));
        fp.add((Component)this.oidsPanel, "North");
        JPanel fieldsPanel = new JPanel(new BorderLayout());
        fieldsPanel.add((Component)new HeaderPanel(Translation.get("gb.properties"), "vcard_16x16.png"), "North");
        fieldsPanel.add((Component)fp, "Center");
        this.saveUserButton = new JButton(Translation.get("gb.save"));
        this.saveUserButton.setEnabled(false);
        this.saveUserButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UserCertificatePanel.this.setEditable(false);
                String username = ((UserCertificatePanel)UserCertificatePanel.this).ucm.user.username;
                UserCertificatePanel.this.oidsPanel.updateUser(UserCertificatePanel.this.ucm);
                UserCertificatePanel.this.saveUser(username, UserCertificatePanel.this.ucm);
            }
        });
        this.editUserButton = new JButton(Translation.get("gb.edit"));
        this.editUserButton.setEnabled(false);
        this.editUserButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UserCertificatePanel.this.setEditable(true);
            }
        });
        JPanel userControls = new JPanel(new FlowLayout(0));
        userControls.add(this.editUserButton);
        userControls.add(this.saveUserButton);
        fieldsPanel.add((Component)userControls, "South");
        JPanel certificatesPanel = new JPanel(new BorderLayout());
        certificatesPanel.add((Component)new HeaderPanel(Translation.get("gb.certificates"), "rosette_16x16.png"), "North");
        this.tableModel = new CertificatesTableModel();
        this.table = Utils.newTable(this.tableModel, "yyyy-MM-dd");
        this.table.setRowSorter(new TableRowSorter<CertificatesTableModel>(this.tableModel));
        this.table.setDefaultRenderer(CertificateStatus.class, new CertificateStatusRenderer());
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                boolean enable = false;
                int row = UserCertificatePanel.this.table.getSelectedRow();
                if (row > -1) {
                    int modelIndex = UserCertificatePanel.this.table.convertRowIndexToModel(row);
                    X509Certificate cert = UserCertificatePanel.this.tableModel.get(modelIndex);
                    enable = !UserCertificatePanel.this.ucm.isRevoked(cert.getSerialNumber());
                }
                UserCertificatePanel.this.revokeCertificateButton.setEnabled(enable);
            }
        });
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    int row = UserCertificatePanel.this.table.rowAtPoint(e.getPoint());
                    int modelIndex = UserCertificatePanel.this.table.convertRowIndexToModel(row);
                    X509Certificate cert = UserCertificatePanel.this.tableModel.get(modelIndex);
                    X509CertificateViewer viewer = new X509CertificateViewer(UserCertificatePanel.this.owner, cert);
                    viewer.setVisible(true);
                }
            }
        });
        certificatesPanel.add((Component)new JScrollPane(this.table), "Center");
        this.newCertificateButton = new JButton(Translation.get("gb.newCertificate"));
        this.newCertificateButton.setEnabled(false);
        this.newCertificateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    if (UserCertificatePanel.this.saveUserButton.isEnabled()) {
                        String username = ((UserCertificatePanel)UserCertificatePanel.this).ucm.user.username;
                        UserCertificatePanel.this.setEditable(false);
                        UserCertificatePanel.this.oidsPanel.updateUser(UserCertificatePanel.this.ucm);
                        UserCertificatePanel.this.saveUser(username, UserCertificatePanel.this.ucm);
                    }
                    NewClientCertificateDialog dialog = new NewClientCertificateDialog(UserCertificatePanel.this.owner, ((UserCertificatePanel)UserCertificatePanel.this).ucm.user.getDisplayName(), UserCertificatePanel.this.getDefaultExpiration(), UserCertificatePanel.this.isAllowEmail());
                    dialog.setModal(true);
                    dialog.setVisible(true);
                    if (dialog.isCanceled()) {
                        return;
                    }
                    final boolean sendEmail = dialog.sendEmail();
                    final UserModel user = ((UserCertificatePanel)UserCertificatePanel.this).ucm.user;
                    final X509Utils.X509Metadata metadata = new X509Utils.X509Metadata(user.username, dialog.getPassword());
                    metadata.userDisplayname = user.getDisplayName();
                    metadata.emailAddress = user.emailAddress;
                    metadata.passwordHint = dialog.getPasswordHint();
                    metadata.notAfter = dialog.getExpiration();
                    AuthorityWorker worker = new AuthorityWorker(UserCertificatePanel.this.owner){

                        @Override
                        protected Boolean doRequest() throws IOException {
                            return UserCertificatePanel.this.newCertificate(UserCertificatePanel.this.ucm, metadata, sendEmail);
                        }

                        @Override
                        protected void onSuccess() {
                            JOptionPane.showMessageDialog(UserCertificatePanel.this.owner, MessageFormat.format(Translation.get("gb.clientCertificateGenerated"), user.getDisplayName()), Translation.get("gb.newCertificate"), 1);
                        }
                    };
                    worker.execute();
                }
                catch (Exception x) {
                    Utils.showException(UserCertificatePanel.this, x);
                }
            }
        });
        this.revokeCertificateButton = new JButton(Translation.get("gb.revokeCertificate"));
        this.revokeCertificateButton.setEnabled(false);
        this.revokeCertificateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    int row = UserCertificatePanel.this.table.getSelectedRow();
                    if (row < 0) {
                        return;
                    }
                    int modelIndex = UserCertificatePanel.this.table.convertRowIndexToModel(row);
                    final X509Certificate cert = UserCertificatePanel.this.tableModel.get(modelIndex);
                    Object[] choices = new String[X509Utils.RevocationReason.reasons.length];
                    for (int i = 0; i < choices.length; ++i) {
                        choices[i] = Translation.get("gb." + X509Utils.RevocationReason.reasons[i].name());
                    }
                    Object choice = JOptionPane.showInputDialog(UserCertificatePanel.this.owner, Translation.get("gb.revokeCertificateReason"), Translation.get("gb.revokeCertificate"), -1, new ImageIcon(this.getClass().getResource("/rosette_32x32.png")), choices, Translation.get("gb.unspecified"));
                    if (choice == null) {
                        return;
                    }
                    X509Utils.RevocationReason selection = X509Utils.RevocationReason.unspecified;
                    for (int i = 0; i < choices.length; ++i) {
                        if (!((String)choices[i]).equals(choice)) continue;
                        selection = X509Utils.RevocationReason.reasons[i];
                        break;
                    }
                    final X509Utils.RevocationReason reason = selection;
                    if (!UserCertificatePanel.this.ucm.isRevoked(cert.getSerialNumber())) {
                        if (((UserCertificatePanel)UserCertificatePanel.this).ucm.certs.size() == 1) {
                            ((UserCertificatePanel)UserCertificatePanel.this).ucm.expires = null;
                        } else {
                            Date newExpires = null;
                            for (X509Certificate c : ((UserCertificatePanel)UserCertificatePanel.this).ucm.certs) {
                                if (c.equals(cert) || UserCertificatePanel.this.ucm.isRevoked(c.getSerialNumber()) || newExpires != null && !c.getNotAfter().after(newExpires)) continue;
                                newExpires = c.getNotAfter();
                            }
                            ((UserCertificatePanel)UserCertificatePanel.this).ucm.expires = newExpires;
                        }
                        AuthorityWorker worker = new AuthorityWorker(UserCertificatePanel.this.owner){

                            @Override
                            protected Boolean doRequest() throws IOException {
                                return UserCertificatePanel.this.revoke(UserCertificatePanel.this.ucm, cert, reason);
                            }

                            @Override
                            protected void onSuccess() {
                                JOptionPane.showMessageDialog(UserCertificatePanel.this.owner, MessageFormat.format(Translation.get("gb.certificateRevoked"), cert.getSerialNumber(), cert.getIssuerDN().getName()), Translation.get("gb.revokeCertificate"), 1);
                            }
                        };
                        worker.execute();
                    }
                }
                catch (Exception x) {
                    Utils.showException(UserCertificatePanel.this, x);
                }
            }
        });
        JPanel certificateControls = new JPanel(new FlowLayout(0));
        certificateControls.add(this.newCertificateButton);
        certificateControls.add(this.revokeCertificateButton);
        certificatesPanel.add((Component)certificateControls, "South");
        this.add((Component)fieldsPanel, "North");
        this.add((Component)certificatesPanel, "Center");
        this.setEditable(false);
    }

    public void setUserCertificateModel(UserCertificateModel ucm) {
        this.ucm = ucm;
        this.setEditable(false);
        this.oidsPanel.setUserCertificateModel(ucm);
        this.tableModel.setUserCertificateModel(ucm);
        this.tableModel.fireTableDataChanged();
        Utils.packColumns(this.table, 5);
    }

    public void setEditable(boolean editable) {
        this.oidsPanel.setEditable(editable);
        this.editUserButton.setEnabled(!editable && this.ucm != null);
        this.saveUserButton.setEnabled(editable && this.ucm != null);
        this.newCertificateButton.setEnabled(this.ucm != null);
        this.revokeCertificateButton.setEnabled(false);
    }

    public abstract Date getDefaultExpiration();

    public abstract boolean isAllowEmail();

    public abstract boolean saveUser(String var1, UserCertificateModel var2);

    public abstract boolean newCertificate(UserCertificateModel var1, X509Utils.X509Metadata var2, boolean var3);

    public abstract boolean revoke(UserCertificateModel var1, X509Certificate var2, X509Utils.RevocationReason var3);
}

