/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.authority;

import com.gitblit.client.DateCellRenderer;
import com.gitblit.client.Translation;
import com.gitblit.utils.StringUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Insets;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Date;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class Utils {
    public static final int LABEL_WIDTH = 175;
    public static final int MARGIN = 5;
    public static final Insets INSETS = new Insets(5, 5, 5, 5);
    public static final String TIMESTAMP_FORMAT = "yyyy-MM-dd HH:mm";
    public static final String DATE_FORMAT = "yyyy-MM-dd";

    public static JTable newTable(TableModel model, String datePattern) {
        JTable table = new JTable(model);
        table.setRowHeight(table.getFont().getSize() + 8);
        table.setCellSelectionEnabled(false);
        table.setRowSelectionAllowed(true);
        table.getTableHeader().setReorderingAllowed(false);
        table.setGridColor(new Color(0xD9D9D9));
        table.setBackground(Color.white);
        table.setDefaultRenderer(Date.class, new DateCellRenderer(datePattern, Color.orange.darker()));
        return table;
    }

    public static JPanel newFieldPanel(String label, Component c) {
        return Utils.newFieldPanel(label, c, null);
    }

    public static JPanel newFieldPanel(String label, Component c, String trailingLabel) {
        JLabel jlabel = new JLabel(label);
        jlabel.setPreferredSize(new Dimension(175, 20));
        JPanel panel = new JPanel(new FlowLayout(0));
        panel.add(jlabel);
        panel.add(c);
        if (!StringUtils.isEmpty(trailingLabel)) {
            panel.add(new JLabel(trailingLabel));
        }
        return panel;
    }

    public static void showException(Component c, Throwable t) {
        StringWriter writer = new StringWriter();
        t.printStackTrace(new PrintWriter(writer));
        String stacktrace = writer.toString();
        try {
            writer.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        JTextArea textArea = new JTextArea(stacktrace);
        textArea.setFont(new Font("monospaced", 0, 11));
        JScrollPane jsp = new JScrollPane(textArea);
        jsp.setPreferredSize(new Dimension(800, 400));
        JOptionPane.showMessageDialog(c, jsp, Translation.get("gb.error"), 0);
    }

    public static void packColumns(JTable table, int margin) {
        for (int c = 0; c < table.getColumnCount(); ++c) {
            Utils.packColumn(table, c, 4);
        }
    }

    private static void packColumn(JTable table, int vColIndex, int margin) {
        DefaultTableColumnModel colModel = (DefaultTableColumnModel)table.getColumnModel();
        TableColumn col = colModel.getColumn(vColIndex);
        int width = 0;
        TableCellRenderer renderer = col.getHeaderRenderer();
        if (renderer == null) {
            renderer = table.getTableHeader().getDefaultRenderer();
        }
        Component comp = renderer.getTableCellRendererComponent(table, col.getHeaderValue(), false, false, 0, 0);
        width = comp.getPreferredSize().width;
        for (int r = 0; r < table.getRowCount(); ++r) {
            renderer = table.getCellRenderer(r, vColIndex);
            comp = renderer.getTableCellRendererComponent(table, table.getValueAt(r, vColIndex), false, false, r, vColIndex);
            width = Math.max(width, comp.getPreferredSize().width);
        }
        col.setPreferredWidth(width += 2 * margin);
    }
}

