/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.client;

import java.awt.Color;
import java.awt.Component;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.table.DefaultTableCellRenderer;

public class BranchRenderer
extends DefaultTableCellRenderer
implements ListCellRenderer {
    private static final long serialVersionUID = 1L;
    private static final String R_HEADS = "refs/heads/";
    private static final String R_REMOTES = "refs/remotes/";
    private static final String R_CHANGES = "refs/changes/";

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        this.setText(value == null ? "" : value.toString());
        if (isSelected) {
            this.setForeground(table.getSelectionForeground());
        }
        return this;
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        this.setText(value == null ? "" : value.toString());
        if (isSelected) {
            this.setBackground(list.getSelectionBackground());
            this.setForeground(list.getSelectionForeground());
        } else {
            this.setBackground(list.getBackground());
        }
        return this;
    }

    @Override
    public void setText(String text) {
        String name = text;
        Color fg = this.getForeground();
        if (name.startsWith(R_HEADS)) {
            name = name.substring(R_HEADS.length());
            fg = new Color(0, 128, 0);
        } else if (name.startsWith(R_REMOTES)) {
            name = name.substring(R_REMOTES.length());
            fg = Color.decode("#6C6CBF");
        } else if (name.startsWith(R_CHANGES)) {
            name = name.substring(R_CHANGES.length());
            fg = Color.decode("#B0E0F0");
        }
        this.setForeground(fg);
        super.setText(name);
    }
}

