/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.client;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.plaf.basic.BasicButtonUI;

public class ClosableTabComponent
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final MouseListener BUTTON_MOUSE_LISTENER = new MouseAdapter(){

        @Override
        public void mouseEntered(MouseEvent e) {
            Component component = e.getComponent();
            if (component instanceof AbstractButton) {
                AbstractButton button = (AbstractButton)component;
                button.setBorderPainted(true);
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            Component component = e.getComponent();
            if (component instanceof AbstractButton) {
                AbstractButton button = (AbstractButton)component;
                button.setBorderPainted(false);
            }
        }
    };
    private final JTabbedPane pane;
    private final JLabel label;
    private final JButton button = new TabButton();
    private final CloseTabListener closeListener;

    public ClosableTabComponent(String title, ImageIcon icon, JTabbedPane pane, CloseTabListener closeListener) {
        super(new FlowLayout(0, 0, 0));
        this.closeListener = closeListener;
        if (pane == null) {
            throw new NullPointerException("TabbedPane is null");
        }
        this.pane = pane;
        this.setOpaque(false);
        this.label = new JLabel(title);
        if (icon != null) {
            this.label.setIcon(icon);
        }
        this.add(this.label);
        this.label.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
        this.add(this.button);
        this.setBorder(BorderFactory.createEmptyBorder(2, 0, 0, 0));
    }

    private class TabButton
    extends JButton
    implements ActionListener {
        private static final long serialVersionUID = 1L;

        public TabButton() {
            int size = 17;
            this.setPreferredSize(new Dimension(size, size));
            this.setToolTipText("Close");
            this.setUI(new BasicButtonUI());
            this.setContentAreaFilled(false);
            this.setFocusable(false);
            this.setBorder(BorderFactory.createEtchedBorder());
            this.setBorderPainted(false);
            this.addMouseListener(BUTTON_MOUSE_LISTENER);
            this.setRolloverEnabled(true);
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int i = ClosableTabComponent.this.pane.indexOfTabComponent(ClosableTabComponent.this);
            Component c = ClosableTabComponent.this.pane.getComponentAt(i);
            if (i != -1) {
                ClosableTabComponent.this.pane.remove(i);
            }
            if (ClosableTabComponent.this.closeListener != null) {
                ClosableTabComponent.this.closeListener.closeTab(c);
            }
        }

        @Override
        public void updateUI() {
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            Graphics2D g2 = (Graphics2D)g;
            Stroke stroke = g2.getStroke();
            g2.setStroke(new BasicStroke(2.0f));
            g.setColor(Color.BLACK);
            if (this.getModel().isRollover()) {
                Color highlight = new Color(0, 51, 153);
                g.setColor(highlight);
            }
            int delta = 5;
            g.drawLine(delta, delta, this.getWidth() - delta - 1, this.getHeight() - delta - 1);
            g.drawLine(this.getWidth() - delta - 1, delta, delta, this.getHeight() - delta - 1);
            g2.setStroke(stroke);
            int i = ClosableTabComponent.this.pane.indexOfTabComponent(ClosableTabComponent.this);
            ClosableTabComponent.this.pane.setTitleAt(i, ClosableTabComponent.this.label.getText());
        }
    }

    public static interface CloseTabListener {
        public void closeTab(Component var1);
    }
}

