/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.client;

import com.gitblit.client.Translation;
import java.awt.Color;
import java.awt.Component;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

public class DateCellRenderer
extends DefaultTableCellRenderer {
    private static final long serialVersionUID = 1L;
    private final String pattern;

    public DateCellRenderer(String pattern, Color foreground) {
        this.pattern = pattern == null ? "yyyy-MM-dd HH:mm" : pattern;
        this.setForeground(foreground);
        this.setHorizontalAlignment(0);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        if (value instanceof Date) {
            String dateString;
            String title;
            Date date = (Date)value;
            if (date.getTime() == 0L) {
                title = "--";
                dateString = "never";
            } else {
                title = date.getTime() - System.currentTimeMillis() > 0L ? Translation.getTimeUtils().inFuture(date) : Translation.getTimeUtils().timeAgo(date);
                dateString = new SimpleDateFormat(this.pattern).format((Date)value);
            }
            if (System.currentTimeMillis() - date.getTime() > 864000000L) {
                String tmp = dateString;
                dateString = title;
                title = tmp;
            }
            this.setText(title);
            this.setToolTipText(dateString);
        }
        return this;
    }
}

