/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.client;

import com.gitblit.client.GitblitRegistration;
import com.gitblit.client.HeaderPanel;
import com.gitblit.client.Translation;
import com.gitblit.utils.StringUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRootPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;

public class EditRegistrationDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private JTextField urlField;
    private JTextField nameField;
    private JTextField accountField;
    private JPasswordField passwordField;
    private JCheckBox savePassword;
    private boolean canceled;
    private HeaderPanel headerPanel;

    public EditRegistrationDialog(Window owner) {
        this(owner, null, false);
    }

    public EditRegistrationDialog(Window owner, GitblitRegistration reg, boolean isLogin) {
        super(owner);
        this.initialize(reg, isLogin);
    }

    @Override
    protected JRootPane createRootPane() {
        KeyStroke stroke = KeyStroke.getKeyStroke(27, 0);
        JRootPane rootPane = new JRootPane();
        rootPane.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EditRegistrationDialog.this.setVisible(false);
            }
        }, stroke, 2);
        return rootPane;
    }

    private void initialize(GitblitRegistration reg, boolean isLogin) {
        this.setIconImage(new ImageIcon(this.getClass().getResource("/gitblt-favicon.png")).getImage());
        this.canceled = true;
        this.urlField = new JTextField(reg == null ? "" : reg.url, 30);
        this.nameField = new JTextField(reg == null ? "" : reg.name);
        this.accountField = new JTextField(reg == null ? "" : reg.account);
        this.passwordField = new JPasswordField(reg == null ? "" : new String(reg.password));
        this.savePassword = new JCheckBox("save password (passwords are NOT encrypted!)");
        this.savePassword.setSelected(reg == null ? false : reg.password != null && reg.password.length > 0);
        JPanel panel = new JPanel(new GridLayout(0, 1, 5, 5));
        panel.add(this.newLabelPanel(Translation.get("gb.name"), this.nameField));
        panel.add(this.newLabelPanel(Translation.get("gb.url"), this.urlField));
        panel.add(this.newLabelPanel(Translation.get("gb.username"), this.accountField));
        panel.add(this.newLabelPanel(Translation.get("gb.password"), this.passwordField));
        panel.add(this.newLabelPanel("", this.savePassword));
        JButton cancel = new JButton(Translation.get("gb.cancel"));
        cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                EditRegistrationDialog.this.setVisible(false);
            }
        });
        final JButton save = new JButton(Translation.get(isLogin ? "gb.login" : "gb.save"));
        save.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (EditRegistrationDialog.this.validateFields()) {
                    EditRegistrationDialog.this.canceled = false;
                    EditRegistrationDialog.this.setVisible(false);
                }
            }
        });
        this.passwordField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                save.doClick();
            }
        });
        JPanel controls = new JPanel();
        controls.add(cancel);
        controls.add(save);
        if (reg == null) {
            this.setTitle(Translation.get("gb.create"));
            this.headerPanel = new HeaderPanel(Translation.get("gb.create"), null);
        } else {
            this.setTitle(Translation.get(isLogin ? "gb.login" : "gb.edit"));
            this.headerPanel = new HeaderPanel(reg.name, null);
        }
        final Insets insets = new Insets(5, 5, 5, 5);
        JPanel centerPanel = new JPanel(new BorderLayout(5, 5)){
            private static final long serialVersionUID = 1L;

            @Override
            public Insets getInsets() {
                return insets;
            }
        };
        centerPanel.add((Component)this.headerPanel, "North");
        centerPanel.add((Component)panel, "Center");
        centerPanel.add((Component)controls, "South");
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)centerPanel, "Center");
        this.pack();
        this.setModal(true);
        if (isLogin) {
            this.passwordField.requestFocus();
        }
    }

    private JPanel newLabelPanel(String text, JComponent field) {
        JLabel label = new JLabel(text);
        label.setFont(label.getFont().deriveFont(1));
        label.setPreferredSize(new Dimension(75, 10));
        JPanel jpanel = new JPanel(new BorderLayout());
        jpanel.add((Component)label, "West");
        jpanel.add((Component)field, "Center");
        return jpanel;
    }

    private boolean validateFields() {
        String name = this.nameField.getText();
        if (StringUtils.isEmpty(name)) {
            this.error("Please enter a name for this registration!");
            return false;
        }
        String url = this.urlField.getText();
        if (StringUtils.isEmpty(url)) {
            this.error("Please enter a url for this registration!");
            return false;
        }
        return true;
    }

    private void error(String message) {
        JOptionPane.showMessageDialog(this, message, Translation.get("gb.error"), 0);
    }

    public GitblitRegistration getRegistration() {
        if (this.canceled) {
            return null;
        }
        GitblitRegistration reg = new GitblitRegistration(this.nameField.getText(), this.urlField.getText(), this.accountField.getText(), this.passwordField.getPassword());
        reg.savePassword = this.savePassword.isSelected();
        return reg;
    }
}

