/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.client;

import com.gitblit.Constants;
import com.gitblit.client.JPalette;
import com.gitblit.client.RegistrantPermissionsPanel;
import com.gitblit.client.Translation;
import com.gitblit.models.RegistrantAccessPermission;
import com.gitblit.models.RepositoryModel;
import com.gitblit.utils.ArrayUtils;
import com.gitblit.utils.StringUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import org.eclipse.jgit.lib.Repository;

public class EditRepositoryDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private final String repositoryName;
    private final RepositoryModel repository;
    private boolean isCreate;
    private boolean canceled = true;
    private JTextField nameField;
    private JTextField descriptionField;
    private JCheckBox acceptNewPatchsets;
    private JCheckBox acceptNewTickets;
    private JCheckBox requireApproval;
    private JComboBox mergeToField;
    private JCheckBox useIncrementalPushTags;
    private JCheckBox showRemoteBranches;
    private JCheckBox skipSizeCalculation;
    private JCheckBox skipSummaryMetrics;
    private JCheckBox isFrozen;
    private JTextField mailingListsField;
    private JComboBox accessRestriction;
    private JRadioButton allowAuthenticated;
    private JRadioButton allowNamed;
    private JCheckBox allowForks;
    private JCheckBox verifyCommitter;
    private JComboBox federationStrategy;
    private JPalette<String> ownersPalette;
    private JComboBox headRefField;
    private JComboBox gcPeriod;
    private JTextField gcThreshold;
    private JComboBox maxActivityCommits;
    private RegistrantPermissionsPanel usersPalette;
    private JPalette<String> setsPalette;
    private RegistrantPermissionsPanel teamsPalette;
    private JPalette<String> indexedBranchesPalette;
    private JPalette<String> preReceivePalette;
    private JLabel preReceiveInherited;
    private JPalette<String> postReceivePalette;
    private JLabel postReceiveInherited;
    private Set<String> repositoryNames;
    private JPanel customFieldsPanel;
    private List<JTextField> customTextfields;

    public EditRepositoryDialog(int protocolVersion) {
        this(protocolVersion, new RepositoryModel());
        this.isCreate = true;
        this.setTitle(Translation.get("gb.newRepository"));
    }

    public EditRepositoryDialog(int protocolVersion, RepositoryModel aRepository) {
        this.repositoryName = aRepository.name;
        this.repository = new RepositoryModel();
        this.repositoryNames = new HashSet<String>();
        this.isCreate = false;
        this.initialize(protocolVersion, aRepository);
        this.setModal(true);
        this.setResizable(false);
        this.setTitle(Translation.get("gb.edit") + ": " + aRepository.name);
        this.setIconImage(new ImageIcon(this.getClass().getResource("/gitblt-favicon.png")).getImage());
    }

    @Override
    protected JRootPane createRootPane() {
        KeyStroke stroke = KeyStroke.getKeyStroke(27, 0);
        JRootPane rootPane = new JRootPane();
        rootPane.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EditRepositoryDialog.this.setVisible(false);
            }
        }, stroke, 2);
        return rootPane;
    }

    private void initialize(int protocolVersion, RepositoryModel anRepository) {
        this.nameField = new JTextField(anRepository.name == null ? "" : anRepository.name, 35);
        this.descriptionField = new JTextField(anRepository.description == null ? "" : anRepository.description, 35);
        JTextField originField = new JTextField(anRepository.origin == null ? "" : anRepository.origin, 40);
        originField.setEditable(false);
        if (ArrayUtils.isEmpty(anRepository.availableRefs)) {
            this.headRefField = new JComboBox();
            this.headRefField.setEnabled(false);
        } else {
            this.headRefField = new JComboBox<Object>(anRepository.availableRefs.toArray());
            this.headRefField.setSelectedItem(anRepository.HEAD);
        }
        Integer[] gcPeriods = new Integer[]{1, 2, 3, 4, 5, 7, 10, 14};
        this.gcPeriod = new JComboBox<Integer>(gcPeriods);
        this.gcPeriod.setSelectedItem(anRepository.gcPeriod);
        this.gcThreshold = new JTextField(8);
        this.gcThreshold.setText(anRepository.gcThreshold);
        this.ownersPalette = new JPalette(true);
        this.acceptNewTickets = new JCheckBox(Translation.get("gb.acceptsNewTicketsDescription"), anRepository.acceptNewTickets);
        this.acceptNewPatchsets = new JCheckBox(Translation.get("gb.acceptsNewPatchsetsDescription"), anRepository.acceptNewPatchsets);
        this.requireApproval = new JCheckBox(Translation.get("gb.requireApprovalDescription"), anRepository.requireApproval);
        if (ArrayUtils.isEmpty(anRepository.availableRefs)) {
            this.mergeToField = new JComboBox();
            this.mergeToField.setEnabled(false);
        } else {
            this.mergeToField = new JComboBox<Object>(anRepository.availableRefs.toArray());
            this.mergeToField.setSelectedItem(anRepository.mergeTo);
        }
        this.useIncrementalPushTags = new JCheckBox(Translation.get("gb.useIncrementalPushTagsDescription"), anRepository.useIncrementalPushTags);
        this.showRemoteBranches = new JCheckBox(Translation.get("gb.showRemoteBranchesDescription"), anRepository.showRemoteBranches);
        this.skipSizeCalculation = new JCheckBox(Translation.get("gb.skipSizeCalculationDescription"), anRepository.skipSizeCalculation);
        this.skipSummaryMetrics = new JCheckBox(Translation.get("gb.skipSummaryMetricsDescription"), anRepository.skipSummaryMetrics);
        this.isFrozen = new JCheckBox(Translation.get("gb.isFrozenDescription"), anRepository.isFrozen);
        this.maxActivityCommits = new JComboBox<Integer>(new Integer[]{-1, 0, 25, 50, 75, 100, 150, 250, 500});
        this.maxActivityCommits.setSelectedItem(anRepository.maxActivityCommits);
        this.mailingListsField = new JTextField(ArrayUtils.isEmpty(anRepository.mailingLists) ? "" : StringUtils.flattenStrings(anRepository.mailingLists, " "), 50);
        this.accessRestriction = new JComboBox<Constants.AccessRestrictionType>(Constants.AccessRestrictionType.values());
        this.accessRestriction.setRenderer(new AccessRestrictionRenderer());
        this.accessRestriction.setSelectedItem((Object)anRepository.accessRestriction);
        this.accessRestriction.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    Constants.AccessRestrictionType art = (Constants.AccessRestrictionType)((Object)EditRepositoryDialog.this.accessRestriction.getSelectedItem());
                    EditRepositoryDialog.this.setupAccessPermissions(art);
                }
            }
        });
        boolean authenticated = anRepository.authorizationControl != null && Constants.AuthorizationControl.AUTHENTICATED.equals((Object)anRepository.authorizationControl);
        this.allowAuthenticated = new JRadioButton(Translation.get("gb.allowAuthenticatedDescription"));
        this.allowAuthenticated.setSelected(authenticated);
        this.allowAuthenticated.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    EditRepositoryDialog.this.usersPalette.setEnabled(false);
                    EditRepositoryDialog.this.teamsPalette.setEnabled(false);
                }
            }
        });
        this.allowNamed = new JRadioButton(Translation.get("gb.allowNamedDescription"));
        this.allowNamed.setSelected(!authenticated);
        this.allowNamed.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    EditRepositoryDialog.this.usersPalette.setEnabled(true);
                    EditRepositoryDialog.this.teamsPalette.setEnabled(true);
                }
            }
        });
        ButtonGroup group = new ButtonGroup();
        group.add(this.allowAuthenticated);
        group.add(this.allowNamed);
        JPanel authorizationPanel = new JPanel(new GridLayout(0, 1));
        authorizationPanel.add(this.allowAuthenticated);
        authorizationPanel.add(this.allowNamed);
        this.allowForks = new JCheckBox(Translation.get("gb.allowForksDescription"), anRepository.allowForks);
        this.verifyCommitter = new JCheckBox(Translation.get("gb.verifyCommitterDescription"), anRepository.verifyCommitter);
        ArrayList<Constants.FederationStrategy> federationStrategies = new ArrayList<Constants.FederationStrategy>(Arrays.asList(Constants.FederationStrategy.values()));
        if (StringUtils.isEmpty(anRepository.origin)) {
            federationStrategies.remove((Object)Constants.FederationStrategy.FEDERATE_ORIGIN);
        }
        this.federationStrategy = new JComboBox<Object>(federationStrategies.toArray());
        this.federationStrategy.setRenderer(new FederationStrategyRenderer());
        this.federationStrategy.setSelectedItem((Object)anRepository.federationStrategy);
        JPanel fieldsPanel = new JPanel(new GridLayout(0, 1));
        fieldsPanel.add(this.newFieldPanel(Translation.get("gb.name"), this.nameField));
        fieldsPanel.add(this.newFieldPanel(Translation.get("gb.description"), this.descriptionField));
        fieldsPanel.add(this.newFieldPanel(Translation.get("gb.origin"), originField));
        fieldsPanel.add(this.newFieldPanel(Translation.get("gb.headRef"), this.headRefField));
        fieldsPanel.add(this.newFieldPanel(Translation.get("gb.gcPeriod"), this.gcPeriod));
        fieldsPanel.add(this.newFieldPanel(Translation.get("gb.gcThreshold"), this.gcThreshold));
        fieldsPanel.add(this.newFieldPanel(Translation.get("gb.acceptsNewTickets"), this.acceptNewTickets));
        fieldsPanel.add(this.newFieldPanel(Translation.get("gb.acceptsNewPatchsets"), this.acceptNewPatchsets));
        fieldsPanel.add(this.newFieldPanel(Translation.get("gb.requireApproval"), this.requireApproval));
        fieldsPanel.add(this.newFieldPanel(Translation.get("gb.mergeTo"), this.mergeToField));
        fieldsPanel.add(this.newFieldPanel(Translation.get("gb.enableIncrementalPushTags"), this.useIncrementalPushTags));
        fieldsPanel.add(this.newFieldPanel(Translation.get("gb.showRemoteBranches"), this.showRemoteBranches));
        fieldsPanel.add(this.newFieldPanel(Translation.get("gb.skipSizeCalculation"), this.skipSizeCalculation));
        fieldsPanel.add(this.newFieldPanel(Translation.get("gb.skipSummaryMetrics"), this.skipSummaryMetrics));
        fieldsPanel.add(this.newFieldPanel(Translation.get("gb.maxActivityCommits"), this.maxActivityCommits));
        fieldsPanel.add(this.newFieldPanel(Translation.get("gb.mailingLists"), this.mailingListsField));
        JPanel clonePushPanel = new JPanel(new GridLayout(0, 1));
        clonePushPanel.add(this.newFieldPanel(Translation.get("gb.isFrozen"), this.isFrozen));
        clonePushPanel.add(this.newFieldPanel(Translation.get("gb.allowForks"), this.allowForks));
        clonePushPanel.add(this.newFieldPanel(Translation.get("gb.verifyCommitter"), this.verifyCommitter));
        this.usersPalette = new RegistrantPermissionsPanel(Constants.RegistrantType.USER);
        JPanel northFieldsPanel = new JPanel(new BorderLayout(0, 5));
        northFieldsPanel.add((Component)this.newFieldPanel(Translation.get("gb.owners"), this.ownersPalette), "North");
        northFieldsPanel.add((Component)this.newFieldPanel(Translation.get("gb.accessRestriction"), this.accessRestriction), "Center");
        JPanel northAccessPanel = new JPanel(new BorderLayout(5, 5));
        northAccessPanel.add((Component)northFieldsPanel, "North");
        northAccessPanel.add((Component)this.newFieldPanel(Translation.get("gb.authorizationControl"), authorizationPanel), "Center");
        northAccessPanel.add((Component)clonePushPanel, "South");
        JPanel accessPanel = new JPanel(new BorderLayout(5, 5));
        accessPanel.add((Component)northAccessPanel, "North");
        accessPanel.add((Component)this.newFieldPanel(Translation.get("gb.userPermissions"), this.usersPalette), "Center");
        this.teamsPalette = new RegistrantPermissionsPanel(Constants.RegistrantType.TEAM);
        JPanel teamsPanel = new JPanel(new BorderLayout(5, 5));
        teamsPanel.add((Component)this.newFieldPanel(Translation.get("gb.teamPermissions"), this.teamsPalette), "Center");
        this.setsPalette = new JPalette();
        JPanel federationPanel = new JPanel(new BorderLayout(5, 5));
        federationPanel.add((Component)this.newFieldPanel(Translation.get("gb.federationStrategy"), this.federationStrategy), "North");
        federationPanel.add((Component)this.newFieldPanel(Translation.get("gb.federationSets"), this.setsPalette), "Center");
        this.indexedBranchesPalette = new JPalette();
        JPanel indexedBranchesPanel = new JPanel(new BorderLayout(5, 5));
        indexedBranchesPanel.add((Component)this.newFieldPanel(Translation.get("gb.indexedBranches"), this.indexedBranchesPalette), "Center");
        this.preReceivePalette = new JPalette(true);
        this.preReceiveInherited = new JLabel();
        JPanel preReceivePanel = new JPanel(new BorderLayout(5, 5));
        preReceivePanel.add(this.preReceivePalette, "Center");
        preReceivePanel.add((Component)this.preReceiveInherited, "West");
        this.postReceivePalette = new JPalette(true);
        this.postReceiveInherited = new JLabel();
        JPanel postReceivePanel = new JPanel(new BorderLayout(5, 5));
        postReceivePanel.add(this.postReceivePalette, "Center");
        postReceivePanel.add((Component)this.postReceiveInherited, "West");
        this.customFieldsPanel = new JPanel();
        this.customFieldsPanel.setLayout(new BoxLayout(this.customFieldsPanel, 1));
        JScrollPane customFieldsScrollPane = new JScrollPane(this.customFieldsPanel);
        customFieldsScrollPane.setHorizontalScrollBarPolicy(31);
        customFieldsScrollPane.setVerticalScrollBarPolicy(20);
        JTabbedPane panel = new JTabbedPane(1);
        panel.addTab(Translation.get("gb.general"), fieldsPanel);
        panel.addTab(Translation.get("gb.accessRestriction"), accessPanel);
        if (protocolVersion >= 2) {
            panel.addTab(Translation.get("gb.teams"), teamsPanel);
        }
        panel.addTab(Translation.get("gb.federation"), federationPanel);
        if (protocolVersion >= 3) {
            panel.addTab(Translation.get("gb.indexedBranches"), indexedBranchesPanel);
        }
        panel.addTab(Translation.get("gb.preReceiveScripts"), preReceivePanel);
        panel.addTab(Translation.get("gb.postReceiveScripts"), postReceivePanel);
        panel.addTab(Translation.get("gb.customFields"), customFieldsScrollPane);
        this.setupAccessPermissions(anRepository.accessRestriction);
        JButton createButton = new JButton(Translation.get("gb.save"));
        createButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (EditRepositoryDialog.this.validateFields()) {
                    EditRepositoryDialog.this.canceled = false;
                    EditRepositoryDialog.this.setVisible(false);
                }
            }
        });
        JButton cancelButton = new JButton(Translation.get("gb.cancel"));
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                EditRepositoryDialog.this.canceled = true;
                EditRepositoryDialog.this.setVisible(false);
            }
        });
        JPanel controls = new JPanel();
        controls.add(cancelButton);
        controls.add(createButton);
        final Insets _insets = new Insets(5, 5, 5, 5);
        JPanel centerPanel = new JPanel(new BorderLayout(5, 5)){
            private static final long serialVersionUID = 1L;

            @Override
            public Insets getInsets() {
                return _insets;
            }
        };
        centerPanel.add((Component)panel, "Center");
        centerPanel.add((Component)controls, "South");
        this.getContentPane().setLayout(new BorderLayout(5, 5));
        this.getContentPane().add((Component)centerPanel, "Center");
        this.pack();
        this.nameField.requestFocus();
    }

    private JPanel newFieldPanel(String label, JComponent comp) {
        return this.newFieldPanel(label, 150, comp);
    }

    private JPanel newFieldPanel(String label, int labelSize, JComponent comp) {
        JLabel fieldLabel = new JLabel(label);
        fieldLabel.setFont(fieldLabel.getFont().deriveFont(1));
        fieldLabel.setPreferredSize(new Dimension(labelSize, 20));
        JPanel panel = new JPanel(new FlowLayout(0, 10, 0));
        panel.add(fieldLabel);
        panel.add(comp);
        return panel;
    }

    private void setupAccessPermissions(Constants.AccessRestrictionType art) {
        if (Constants.AccessRestrictionType.NONE.equals((Object)art)) {
            this.usersPalette.setEnabled(false);
            this.teamsPalette.setEnabled(false);
            this.allowAuthenticated.setEnabled(false);
            this.allowNamed.setEnabled(false);
            this.verifyCommitter.setEnabled(false);
        } else {
            this.allowAuthenticated.setEnabled(true);
            this.allowNamed.setEnabled(true);
            this.verifyCommitter.setEnabled(true);
            if (this.allowNamed.isSelected()) {
                this.usersPalette.setEnabled(true);
                this.teamsPalette.setEnabled(true);
            }
        }
    }

    private boolean validateFields() {
        Character c;
        String rname = this.nameField.getText();
        if (StringUtils.isEmpty(rname)) {
            this.error("Please enter a repository name!");
            return false;
        }
        rname = rname.replace('\\', '/');
        if ((rname = rname.replace("//", "/")).startsWith("/")) {
            this.error("Leading root folder references (/) are prohibited.");
            return false;
        }
        if (rname.startsWith("../")) {
            this.error("Relative folder references (../) are prohibited.");
            return false;
        }
        if (rname.contains("/../")) {
            this.error("Relative folder references (../) are prohibited.");
            return false;
        }
        if (rname.endsWith("/")) {
            rname = rname.substring(0, rname.length() - 1);
        }
        if ((c = StringUtils.findInvalidCharacter(rname)) != null) {
            this.error(MessageFormat.format("Illegal character ''{0}'' in repository name!", c));
            return false;
        }
        if (this.isCreate) {
            if (this.repositoryNames.contains(rname.toLowerCase())) {
                this.error(MessageFormat.format("Can not create repository ''{0}'' because it already exists.", rname));
                return false;
            }
        } else if (!this.repositoryName.equalsIgnoreCase(rname) && this.repositoryNames.contains(rname.toLowerCase())) {
            this.error(MessageFormat.format("Failed to rename ''{0}'' because ''{1}'' already exists.", this.repositoryName, rname));
            return false;
        }
        if (this.accessRestriction.getSelectedItem() == null) {
            this.error("Please select access restriction!");
            return false;
        }
        if (this.federationStrategy.getSelectedItem() == null) {
            this.error("Please select federation strategy!");
            return false;
        }
        this.repository.name = rname;
        this.repository.description = this.descriptionField.getText();
        this.repository.owners.clear();
        this.repository.owners.addAll(this.ownersPalette.getSelections());
        this.repository.HEAD = this.headRefField.getSelectedItem() == null ? null : this.headRefField.getSelectedItem().toString();
        this.repository.gcPeriod = (Integer)this.gcPeriod.getSelectedItem();
        this.repository.gcThreshold = this.gcThreshold.getText();
        this.repository.acceptNewPatchsets = this.acceptNewPatchsets.isSelected();
        this.repository.acceptNewTickets = this.acceptNewTickets.isSelected();
        this.repository.requireApproval = this.requireApproval.isSelected();
        this.repository.mergeTo = this.mergeToField.getSelectedItem() == null ? null : Repository.shortenRefName((String)this.mergeToField.getSelectedItem().toString());
        this.repository.useIncrementalPushTags = this.useIncrementalPushTags.isSelected();
        this.repository.showRemoteBranches = this.showRemoteBranches.isSelected();
        this.repository.skipSizeCalculation = this.skipSizeCalculation.isSelected();
        this.repository.skipSummaryMetrics = this.skipSummaryMetrics.isSelected();
        this.repository.maxActivityCommits = (Integer)this.maxActivityCommits.getSelectedItem();
        this.repository.isFrozen = this.isFrozen.isSelected();
        this.repository.allowForks = this.allowForks.isSelected();
        this.repository.verifyCommitter = this.verifyCommitter.isSelected();
        String ml = this.mailingListsField.getText();
        if (!StringUtils.isEmpty(ml)) {
            HashSet<String> list = new HashSet<String>();
            for (String address : ml.split("(,|\\s)")) {
                if (StringUtils.isEmpty(address)) continue;
                list.add(address.toLowerCase());
            }
            this.repository.mailingLists = new ArrayList<String>(list);
        }
        this.repository.accessRestriction = (Constants.AccessRestrictionType)((Object)this.accessRestriction.getSelectedItem());
        this.repository.authorizationControl = this.allowAuthenticated.isSelected() ? Constants.AuthorizationControl.AUTHENTICATED : Constants.AuthorizationControl.NAMED;
        this.repository.federationStrategy = (Constants.FederationStrategy)((Object)this.federationStrategy.getSelectedItem());
        if (this.repository.federationStrategy.exceeds(Constants.FederationStrategy.EXCLUDE)) {
            this.repository.federationSets = this.setsPalette.getSelections();
        }
        this.repository.indexedBranches = this.indexedBranchesPalette.getSelections();
        this.repository.preReceiveScripts = this.preReceivePalette.getSelections();
        this.repository.postReceiveScripts = this.postReceivePalette.getSelections();
        this.repository.customFields = new LinkedHashMap<String, String>();
        if (this.customTextfields != null) {
            for (JTextField field : this.customTextfields) {
                String key = field.getName();
                String value = field.getText();
                this.repository.customFields.put(key, value);
            }
        }
        return true;
    }

    private void error(String message) {
        JOptionPane.showMessageDialog(this, message, Translation.get("gb.error"), 0);
    }

    public void setAccessRestriction(Constants.AccessRestrictionType restriction) {
        this.accessRestriction.setSelectedItem((Object)restriction);
        this.setupAccessPermissions(restriction);
    }

    public void setAuthorizationControl(Constants.AuthorizationControl authorization) {
        boolean authenticated = authorization != null && Constants.AuthorizationControl.AUTHENTICATED.equals((Object)authorization);
        this.allowAuthenticated.setSelected(authenticated);
        this.allowNamed.setSelected(!authenticated);
    }

    public void setUsers(List<String> owners, List<String> all, List<RegistrantAccessPermission> permissions) {
        this.ownersPalette.setObjects(all, owners);
        this.usersPalette.setObjects(all, permissions);
    }

    public void setTeams(List<String> all, List<RegistrantAccessPermission> permissions) {
        this.teamsPalette.setObjects(all, permissions);
    }

    public void setRepositories(List<RepositoryModel> repositories) {
        this.repositoryNames.clear();
        for (RepositoryModel repository : repositories) {
            this.repositoryNames.add(repository.name.toLowerCase());
        }
    }

    public void setFederationSets(List<String> all, List<String> selected) {
        this.setsPalette.setObjects(all, selected);
    }

    public void setIndexedBranches(List<String> all, List<String> selected) {
        this.indexedBranchesPalette.setObjects(all, selected);
    }

    public void setPreReceiveScripts(List<String> all, List<String> inherited, List<String> selected) {
        this.preReceivePalette.setObjects(all, selected);
        this.showInherited(inherited, this.preReceiveInherited);
    }

    public void setPostReceiveScripts(List<String> all, List<String> inherited, List<String> selected) {
        this.postReceivePalette.setObjects(all, selected);
        this.showInherited(inherited, this.postReceiveInherited);
    }

    private void showInherited(List<String> list, JLabel label) {
        StringBuilder sb = new StringBuilder();
        if (list != null && list.size() > 0) {
            sb.append("<html><body><b>INHERITED</b><ul style=\"margin-left:5px;list-style-type: none;\">");
            for (String script : list) {
                sb.append("<li>").append(script).append("</li>");
            }
            sb.append("</ul></body></html>");
        }
        label.setText(sb.toString());
    }

    public RepositoryModel getRepository() {
        if (this.canceled) {
            return null;
        }
        return this.repository;
    }

    public List<RegistrantAccessPermission> getUserAccessPermissions() {
        return this.usersPalette.getPermissions();
    }

    public List<RegistrantAccessPermission> getTeamAccessPermissions() {
        return this.teamsPalette.getPermissions();
    }

    public void setCustomFields(RepositoryModel repository, Map<String, String> customFields) {
        this.customFieldsPanel.removeAll();
        this.customTextfields = new ArrayList<JTextField>();
        final Insets insets = new Insets(5, 5, 5, 5);
        JPanel fields = new JPanel(new GridLayout(0, 1, 0, 5)){
            private static final long serialVersionUID = 1L;

            @Override
            public Insets getInsets() {
                return insets;
            }
        };
        for (Map.Entry<String, String> entry : customFields.entrySet()) {
            String field = entry.getKey();
            String value = "";
            if (repository.customFields != null && repository.customFields.containsKey(field)) {
                value = repository.customFields.get(field);
            }
            JTextField textField = new JTextField(value);
            textField.setName(field);
            textField.setPreferredSize(new Dimension(450, 26));
            fields.add(this.newFieldPanel(entry.getValue(), 250, textField));
            this.customTextfields.add(textField);
        }
        JScrollPane jsp = new JScrollPane(fields);
        jsp.getVerticalScrollBar().setBlockIncrement(100);
        jsp.getVerticalScrollBar().setUnitIncrement(100);
        jsp.setViewportBorder(null);
        this.customFieldsPanel.setLayout(new FlowLayout(0));
        this.customFieldsPanel.add(jsp);
    }

    private class FederationStrategyRenderer
    extends JLabel
    implements ListCellRenderer {
        private static final long serialVersionUID = 1L;

        private FederationStrategyRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value instanceof Constants.FederationStrategy) {
                Constants.FederationStrategy strategy = (Constants.FederationStrategy)((Object)value);
                switch (strategy) {
                    case EXCLUDE: {
                        this.setText(Translation.get("gb.excludeFromFederation"));
                        break;
                    }
                    case FEDERATE_THIS: {
                        this.setText(Translation.get("gb.federateThis"));
                        break;
                    }
                    case FEDERATE_ORIGIN: {
                        this.setText(Translation.get("gb.federateOrigin"));
                    }
                }
            } else {
                this.setText(value.toString());
            }
            return this;
        }
    }

    private class AccessRestrictionRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = 1L;

        private AccessRestrictionRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value instanceof Constants.AccessRestrictionType) {
                Constants.AccessRestrictionType restriction = (Constants.AccessRestrictionType)((Object)value);
                switch (restriction) {
                    case NONE: {
                        this.setText(Translation.get("gb.notRestricted"));
                        break;
                    }
                    case PUSH: {
                        this.setText(Translation.get("gb.pushRestricted"));
                        break;
                    }
                    case CLONE: {
                        this.setText(Translation.get("gb.cloneRestricted"));
                        break;
                    }
                    case VIEW: {
                        this.setText(Translation.get("gb.viewRestricted"));
                    }
                }
            } else {
                this.setText(value.toString());
            }
            return this;
        }
    }
}

