/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.client;

import com.gitblit.Constants;
import com.gitblit.client.JPalette;
import com.gitblit.client.RegistrantPermissionsPanel;
import com.gitblit.client.Translation;
import com.gitblit.models.RegistrantAccessPermission;
import com.gitblit.models.RepositoryModel;
import com.gitblit.models.ServerSettings;
import com.gitblit.models.TeamModel;
import com.gitblit.models.UserModel;
import com.gitblit.utils.PasswordHash;
import com.gitblit.utils.StringUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRootPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;

public class EditUserDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private final String username;
    private final UserModel user;
    private final ServerSettings settings;
    private boolean isCreate;
    private boolean canceled = true;
    private JTextField usernameField;
    private JPasswordField passwordField;
    private JPasswordField confirmPasswordField;
    private JTextField displayNameField;
    private JTextField emailAddressField;
    private JCheckBox canAdminCheckbox;
    private JCheckBox canForkCheckbox;
    private JCheckBox canCreateCheckbox;
    private JCheckBox notFederatedCheckbox;
    private JCheckBox disabledCheckbox;
    private JTextField organizationalUnitField;
    private JTextField organizationField;
    private JTextField localityField;
    private JTextField stateProvinceField;
    private JTextField countryCodeField;
    private RegistrantPermissionsPanel repositoryPalette;
    private JPalette<TeamModel> teamsPalette;
    private Set<String> usernames;

    public EditUserDialog(int protocolVersion, ServerSettings settings) {
        this(protocolVersion, new UserModel(""), settings);
        this.isCreate = true;
        this.setTitle(Translation.get("gb.newUser"));
    }

    public EditUserDialog(int protocolVersion, UserModel anUser, ServerSettings settings) {
        this.username = anUser.username;
        this.user = new UserModel("");
        this.settings = settings;
        this.usernames = new HashSet<String>();
        this.isCreate = false;
        this.initialize(protocolVersion, anUser);
        this.setModal(true);
        this.setTitle(Translation.get("gb.edit") + ": " + anUser.username);
        this.setIconImage(new ImageIcon(this.getClass().getResource("/gitblt-favicon.png")).getImage());
    }

    @Override
    protected JRootPane createRootPane() {
        KeyStroke stroke = KeyStroke.getKeyStroke(27, 0);
        JRootPane rootPane = new JRootPane();
        rootPane.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EditUserDialog.this.setVisible(false);
            }
        }, stroke, 2);
        return rootPane;
    }

    private void initialize(int protocolVersion, UserModel anUser) {
        this.usernameField = new JTextField(anUser.username == null ? "" : anUser.username, 25);
        this.passwordField = new JPasswordField(anUser.password == null ? "" : anUser.password, 25);
        this.confirmPasswordField = new JPasswordField(anUser.password == null ? "" : anUser.password, 25);
        this.displayNameField = new JTextField(anUser.displayName == null ? "" : anUser.displayName, 25);
        this.emailAddressField = new JTextField(anUser.emailAddress == null ? "" : anUser.emailAddress, 25);
        this.canAdminCheckbox = new JCheckBox(Translation.get("gb.canAdminDescription"), anUser.canAdmin);
        this.canForkCheckbox = new JCheckBox(Translation.get("gb.canForkDescription"), anUser.canFork);
        this.canCreateCheckbox = new JCheckBox(Translation.get("gb.canCreateDescription"), anUser.canCreate);
        this.notFederatedCheckbox = new JCheckBox(Translation.get("gb.excludeFromFederationDescription"), anUser.excludeFromFederation);
        this.disabledCheckbox = new JCheckBox(Translation.get("gb.disableUserDescription"), anUser.disabled);
        this.organizationalUnitField = new JTextField(anUser.organizationalUnit == null ? "" : anUser.organizationalUnit, 25);
        this.organizationField = new JTextField(anUser.organization == null ? "" : anUser.organization, 25);
        this.localityField = new JTextField(anUser.locality == null ? "" : anUser.locality, 25);
        this.stateProvinceField = new JTextField(anUser.stateProvince == null ? "" : anUser.stateProvince, 25);
        this.countryCodeField = new JTextField(anUser.countryCode == null ? "" : anUser.countryCode, 15);
        this.usernameField.setEnabled(anUser.isLocalAccount());
        this.passwordField.setEnabled(anUser.isLocalAccount());
        this.confirmPasswordField.setEnabled(anUser.isLocalAccount());
        JPanel fieldsPanel = new JPanel(new GridLayout(0, 1));
        fieldsPanel.add(this.newFieldPanel(Translation.get("gb.username"), this.usernameField));
        fieldsPanel.add(this.newFieldPanel(Translation.get("gb.password"), this.passwordField));
        fieldsPanel.add(this.newFieldPanel(Translation.get("gb.confirmPassword"), this.confirmPasswordField));
        fieldsPanel.add(this.newFieldPanel(Translation.get("gb.displayName"), this.displayNameField));
        fieldsPanel.add(this.newFieldPanel(Translation.get("gb.emailAddress"), this.emailAddressField));
        fieldsPanel.add(this.newFieldPanel(Translation.get("gb.canAdmin"), this.canAdminCheckbox));
        fieldsPanel.add(this.newFieldPanel(Translation.get("gb.canFork"), this.canForkCheckbox));
        fieldsPanel.add(this.newFieldPanel(Translation.get("gb.canCreate"), this.canCreateCheckbox));
        fieldsPanel.add(this.newFieldPanel(Translation.get("gb.excludeFromFederation"), this.notFederatedCheckbox));
        fieldsPanel.add(this.newFieldPanel(Translation.get("gb.disableUser"), this.disabledCheckbox));
        JPanel attributesPanel = new JPanel(new GridLayout(0, 1, 5, 2));
        attributesPanel.add(this.newFieldPanel(Translation.get("gb.organizationalUnit") + " (OU)", this.organizationalUnitField));
        attributesPanel.add(this.newFieldPanel(Translation.get("gb.organization") + " (O)", this.organizationField));
        attributesPanel.add(this.newFieldPanel(Translation.get("gb.locality") + " (L)", this.localityField));
        attributesPanel.add(this.newFieldPanel(Translation.get("gb.stateProvince") + " (ST)", this.stateProvinceField));
        attributesPanel.add(this.newFieldPanel(Translation.get("gb.countryCode") + " (C)", this.countryCodeField));
        final Insets _insets = new Insets(5, 5, 5, 5);
        this.repositoryPalette = new RegistrantPermissionsPanel(Constants.RegistrantType.REPOSITORY);
        this.teamsPalette = new JPalette();
        JPanel fieldsPanelTop = new JPanel(new BorderLayout());
        fieldsPanelTop.add((Component)fieldsPanel, "North");
        JPanel attributesPanelTop = new JPanel(new BorderLayout());
        attributesPanelTop.add((Component)attributesPanel, "North");
        JPanel repositoriesPanel = new JPanel(new BorderLayout()){
            private static final long serialVersionUID = 1L;

            @Override
            public Insets getInsets() {
                return _insets;
            }
        };
        repositoriesPanel.add((Component)this.repositoryPalette, "Center");
        JPanel teamsPanel = new JPanel(new BorderLayout()){
            private static final long serialVersionUID = 1L;

            @Override
            public Insets getInsets() {
                return _insets;
            }
        };
        teamsPanel.add(this.teamsPalette, "Center");
        JTabbedPane panel = new JTabbedPane(1);
        panel.addTab(Translation.get("gb.general"), fieldsPanelTop);
        panel.addTab(Translation.get("gb.attributes"), attributesPanelTop);
        if (protocolVersion > 1) {
            panel.addTab(Translation.get("gb.teamMemberships"), teamsPanel);
        }
        panel.addTab(Translation.get("gb.restrictedRepositories"), repositoriesPanel);
        JButton createButton = new JButton(Translation.get("gb.save"));
        createButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (EditUserDialog.this.validateFields()) {
                    EditUserDialog.this.canceled = false;
                    EditUserDialog.this.setVisible(false);
                }
            }
        });
        JButton cancelButton = new JButton(Translation.get("gb.cancel"));
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                EditUserDialog.this.canceled = true;
                EditUserDialog.this.setVisible(false);
            }
        });
        JPanel controls = new JPanel();
        controls.add(cancelButton);
        controls.add(createButton);
        JPanel centerPanel = new JPanel(new BorderLayout(5, 5)){
            private static final long serialVersionUID = 1L;

            @Override
            public Insets getInsets() {
                return _insets;
            }
        };
        centerPanel.add((Component)panel, "Center");
        centerPanel.add((Component)controls, "South");
        this.getContentPane().setLayout(new BorderLayout(5, 5));
        this.getContentPane().add((Component)centerPanel, "Center");
        this.pack();
    }

    private JPanel newFieldPanel(String label, JComponent comp) {
        JLabel fieldLabel = new JLabel(label);
        fieldLabel.setFont(fieldLabel.getFont().deriveFont(1));
        fieldLabel.setPreferredSize(new Dimension(150, 20));
        JPanel panel = new JPanel(new FlowLayout(0, 10, 0));
        panel.add(fieldLabel);
        panel.add(comp);
        return panel;
    }

    private boolean validateFields() {
        String password;
        if (StringUtils.isEmpty(this.usernameField.getText())) {
            this.error("Please enter a username!");
            return false;
        }
        String uname = this.usernameField.getText().toLowerCase();
        boolean rename = false;
        if (this.isCreate) {
            if (this.usernames.contains(uname)) {
                this.error(MessageFormat.format("Username ''{0}'' is unavailable.", uname));
                return false;
            }
        } else {
            boolean bl = rename = !StringUtils.isEmpty(this.username) && !this.username.equalsIgnoreCase(uname);
            if (rename && this.usernames.contains(uname)) {
                this.error(MessageFormat.format("Failed to rename ''{0}'' because ''{1}'' already exists.", this.username, uname));
                return false;
            }
        }
        this.user.username = uname;
        int minLength = this.settings.get("realm.minPasswordLength").getInteger(5);
        if (minLength < 4) {
            minLength = 4;
        }
        if (StringUtils.isEmpty(password = new String(this.passwordField.getPassword())) || password.length() < minLength) {
            this.error(MessageFormat.format("Password is too short. Minimum length is {0} characters.", minLength));
            return false;
        }
        if (!PasswordHash.isHashedEntry(password)) {
            String cpw = new String(this.confirmPasswordField.getPassword());
            if (cpw == null || cpw.length() != password.length()) {
                this.error("Please confirm the password!");
                return false;
            }
            if (!password.equals(cpw)) {
                this.error("Passwords do not match!");
                return false;
            }
            this.user.cookie = this.user.createCookie();
            String type = this.settings.get("realm.passwordStorage").getString(PasswordHash.getDefaultType().name());
            PasswordHash pwdHash = PasswordHash.instanceOf(type);
            this.user.password = pwdHash != null ? pwdHash.toHashedEntry(password, this.user.username) : password;
        } else {
            if (rename && password.toUpperCase().startsWith(PasswordHash.Type.CMD5.name())) {
                this.error("Gitblit is configured for combined-md5 password hashing. You must enter a new password on account rename.");
                return false;
            }
            this.user.password = password;
        }
        this.user.displayName = this.displayNameField.getText().trim();
        this.user.emailAddress = this.emailAddressField.getText().trim();
        this.user.canAdmin = this.canAdminCheckbox.isSelected();
        this.user.canFork = this.canForkCheckbox.isSelected();
        this.user.canCreate = this.canCreateCheckbox.isSelected();
        this.user.excludeFromFederation = this.notFederatedCheckbox.isSelected();
        this.user.disabled = this.disabledCheckbox.isSelected();
        this.user.organizationalUnit = this.organizationalUnitField.getText().trim();
        this.user.organization = this.organizationField.getText().trim();
        this.user.locality = this.localityField.getText().trim();
        this.user.stateProvince = this.stateProvinceField.getText().trim();
        this.user.countryCode = this.countryCodeField.getText().trim();
        for (RegistrantAccessPermission rp : this.repositoryPalette.getPermissions()) {
            this.user.setRepositoryPermission(rp.registrant, rp.permission);
        }
        this.user.teams.clear();
        this.user.teams.addAll(this.teamsPalette.getSelections());
        return true;
    }

    private void error(String message) {
        JOptionPane.showMessageDialog(this, message, Translation.get("gb.error"), 0);
    }

    public void setUsers(List<UserModel> users) {
        this.usernames.clear();
        for (UserModel user : users) {
            this.usernames.add(user.username.toLowerCase());
        }
    }

    public void setRepositories(List<RepositoryModel> repositories, List<RegistrantAccessPermission> permissions) {
        String prefix;
        HashMap<String, RepositoryModel> repoMap = new HashMap<String, RepositoryModel>();
        ArrayList<String> restricted = new ArrayList<String>();
        for (RepositoryModel repo : repositories) {
            if (!repo.isOwner(this.username) && !repo.isUsersPersonalRepository(this.username) && repo.accessRestriction.exceeds(Constants.AccessRestrictionType.NONE) && repo.authorizationControl.equals((Object)Constants.AuthorizationControl.NAMED)) {
                restricted.add(repo.name);
            }
            repoMap.put(repo.name.toLowerCase(), repo);
        }
        StringUtils.sortRepositorynames(restricted);
        ArrayList<String> list = new ArrayList<String>();
        list.add(".*");
        if (this.settings.hasKey("git.userRepositoryPrefix")) {
            prefix = this.settings.get((String)"git.userRepositoryPrefix").currentValue;
            if (StringUtils.isEmpty(prefix)) {
                prefix = "~";
            }
        } else {
            prefix = "~";
        }
        if (prefix.length() == 1) {
            list.add("[^" + prefix + "].*");
        }
        String lastProject = null;
        for (String repo : restricted) {
            String projectPath = StringUtils.getFirstPathElement(repo).toLowerCase();
            if (lastProject == null || !lastProject.equalsIgnoreCase(projectPath)) {
                lastProject = projectPath;
                if (!StringUtils.isEmpty(projectPath)) {
                    list.add(projectPath + "/.*");
                }
            }
            list.add(repo);
        }
        if (permissions == null) {
            permissions = new ArrayList<RegistrantAccessPermission>();
        } else {
            for (RegistrantAccessPermission rp : permissions) {
                list.remove(rp.registrant.toLowerCase());
            }
        }
        for (RegistrantAccessPermission permission : permissions) {
            if (!permission.mutable || !Constants.PermissionType.EXPLICIT.equals((Object)permission.permissionType)) continue;
            RepositoryModel rm = (RepositoryModel)repoMap.get(permission.registrant.toLowerCase());
            if (rm == null) {
                permission.permissionType = Constants.PermissionType.MISSING;
                permission.mutable = false;
                continue;
            }
            boolean isOwner = rm.isOwner(this.username);
            if (!isOwner) continue;
            permission.permissionType = Constants.PermissionType.OWNER;
            permission.mutable = false;
        }
        this.repositoryPalette.setObjects(list, permissions);
    }

    public void setTeams(List<TeamModel> teams, List<TeamModel> selected) {
        Collections.sort(teams);
        if (selected != null) {
            Collections.sort(selected);
        }
        this.teamsPalette.setObjects(teams, selected);
    }

    public UserModel getUser() {
        if (this.canceled) {
            return null;
        }
        return this.user;
    }
}

