/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.client;

import com.gitblit.client.Translation;
import com.gitblit.models.FeedEntryModel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public class FeedEntryTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    List<FeedEntryModel> entries = new ArrayList<FeedEntryModel>();

    public void setEntries(List<FeedEntryModel> entries) {
        this.entries = entries;
        Collections.sort(entries);
    }

    @Override
    public int getRowCount() {
        return this.entries.size();
    }

    @Override
    public int getColumnCount() {
        return Columns.values().length;
    }

    @Override
    public String getColumnName(int column) {
        Columns col = Columns.values()[column];
        switch (col) {
            case Date: {
                return Translation.get("gb.date");
            }
            case Repository: {
                return Translation.get("gb.repository");
            }
            case Branch: {
                return Translation.get("gb.branch");
            }
            case Author: {
                return Translation.get("gb.author");
            }
            case Message: {
                return Translation.get("gb.message");
            }
        }
        return "";
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        if (Columns.Date.ordinal() == columnIndex) {
            return Date.class;
        }
        if (Columns.Message.ordinal() == columnIndex) {
            return FeedEntryModel.class;
        }
        return String.class;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        FeedEntryModel entry = this.entries.get(rowIndex);
        Columns col = Columns.values()[columnIndex];
        switch (col) {
            case Date: {
                return entry.published;
            }
            case Repository: {
                return entry.repository;
            }
            case Branch: {
                return entry.branch;
            }
            case Author: {
                return entry.author;
            }
            case Message: {
                return entry;
            }
        }
        return null;
    }

    public FeedEntryModel get(int modelRow) {
        return this.entries.get(modelRow);
    }

    static enum Columns {
        Date,
        Repository,
        Branch,
        Author,
        Message;


        public String toString() {
            return this.name().replace('_', ' ');
        }
    }
}

