/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.client;

import com.gitblit.client.BranchRenderer;
import com.gitblit.client.FeedEntryTableModel;
import com.gitblit.client.GitblitClient;
import com.gitblit.client.GitblitWorker;
import com.gitblit.client.HeaderPanel;
import com.gitblit.client.MessageRenderer;
import com.gitblit.client.NameRenderer;
import com.gitblit.client.Translation;
import com.gitblit.client.Utils;
import com.gitblit.models.FeedEntryModel;
import com.gitblit.models.FeedModel;
import com.gitblit.utils.StringUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.RowFilter;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableRowSorter;

public abstract class FeedsPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private final GitblitClient gitblit;
    private final String ALL = "*";
    private FeedEntryTableModel tableModel;
    private TableRowSorter<FeedEntryTableModel> defaultSorter;
    private HeaderPanel header;
    private JTable table;
    private DefaultComboBoxModel repositoryChoices;
    private JComboBox repositorySelector;
    private DefaultComboBoxModel authorChoices;
    private JComboBox authorSelector;
    private int page;
    private JButton prev;
    private JButton next;

    public FeedsPanel(GitblitClient gitblit) {
        this.gitblit = gitblit;
        this.initialize();
    }

    private void initialize() {
        this.prev = new JButton("<");
        this.prev.setToolTipText(Translation.get("gb.pagePrevious"));
        this.prev.setEnabled(false);
        this.prev.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FeedsPanel.this.refreshFeeds(--FeedsPanel.this.page);
            }
        });
        this.next = new JButton(">");
        this.next.setToolTipText(Translation.get("gb.pageNext"));
        this.next.setEnabled(false);
        this.next.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FeedsPanel.this.refreshFeeds(++FeedsPanel.this.page);
            }
        });
        JButton refreshFeeds = new JButton(Translation.get("gb.refresh"));
        refreshFeeds.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FeedsPanel.this.refreshFeeds(0);
            }
        });
        final JButton viewCommit = new JButton(Translation.get("gb.view"));
        viewCommit.setEnabled(false);
        viewCommit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FeedsPanel.this.viewCommit();
            }
        });
        final JButton viewCommitDiff = new JButton(Translation.get("gb.commitdiff"));
        viewCommitDiff.setEnabled(false);
        viewCommitDiff.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FeedsPanel.this.viewCommitDiff();
            }
        });
        final JButton viewTree = new JButton(Translation.get("gb.tree"));
        viewTree.setEnabled(false);
        viewTree.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FeedsPanel.this.viewTree();
            }
        });
        JButton subscribeFeeds = new JButton(Translation.get("gb.subscribe") + "...");
        subscribeFeeds.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FeedsPanel.this.subscribeFeeds(FeedsPanel.this.gitblit.getAvailableFeeds());
            }
        });
        JPanel controls = new JPanel(new FlowLayout(1, 5, 0));
        controls.add(refreshFeeds);
        controls.add(subscribeFeeds);
        controls.add(viewCommit);
        controls.add(viewCommitDiff);
        controls.add(viewTree);
        NameRenderer nameRenderer = new NameRenderer();
        this.tableModel = new FeedEntryTableModel();
        this.header = new HeaderPanel(Translation.get("gb.activity"), "feed_16x16.png");
        this.table = Utils.newTable(this.tableModel, "yyyy-MM-dd");
        this.defaultSorter = new TableRowSorter<FeedEntryTableModel>(this.tableModel);
        String name = this.table.getColumnName(FeedEntryTableModel.Columns.Author.ordinal());
        this.table.getColumn(name).setCellRenderer(nameRenderer);
        name = this.table.getColumnName(FeedEntryTableModel.Columns.Repository.ordinal());
        this.table.getColumn(name).setCellRenderer(nameRenderer);
        name = this.table.getColumnName(FeedEntryTableModel.Columns.Branch.ordinal());
        this.table.getColumn(name).setCellRenderer(new BranchRenderer());
        name = this.table.getColumnName(FeedEntryTableModel.Columns.Message.ordinal());
        this.table.getColumn(name).setCellRenderer(new MessageRenderer(this.gitblit));
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    if (e.isControlDown()) {
                        FeedsPanel.this.viewCommitDiff();
                    } else {
                        FeedsPanel.this.viewCommit();
                    }
                }
            }
        });
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                boolean singleSelection = FeedsPanel.this.table.getSelectedRowCount() == 1;
                viewCommit.setEnabled(singleSelection);
                viewCommitDiff.setEnabled(singleSelection);
                viewTree.setEnabled(singleSelection);
            }
        });
        this.repositoryChoices = new DefaultComboBoxModel();
        this.repositorySelector = new JComboBox(this.repositoryChoices);
        this.repositorySelector.setRenderer(nameRenderer);
        this.repositorySelector.setForeground(nameRenderer.getForeground());
        this.repositorySelector.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                String selectedAuthor = null;
                if (FeedsPanel.this.authorSelector.getSelectedIndex() > -1) {
                    selectedAuthor = FeedsPanel.this.authorSelector.getSelectedItem().toString();
                }
                FeedsPanel.this.updateAuthors();
                if (selectedAuthor != null && FeedsPanel.this.authorChoices.getIndexOf(selectedAuthor) > -1) {
                    FeedsPanel.this.authorChoices.setSelectedItem(selectedAuthor);
                }
                FeedsPanel.this.filterFeeds();
            }
        });
        this.authorChoices = new DefaultComboBoxModel();
        this.authorSelector = new JComboBox(this.authorChoices);
        this.authorSelector.setRenderer(nameRenderer);
        this.authorSelector.setForeground(nameRenderer.getForeground());
        this.authorSelector.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                FeedsPanel.this.filterFeeds();
            }
        });
        JPanel northControls = new JPanel(new FlowLayout(0, 5, 0));
        northControls.add(new JLabel(Translation.get("gb.repository")));
        northControls.add(this.repositorySelector);
        northControls.add(new JLabel(Translation.get("gb.author")));
        northControls.add(this.authorSelector);
        JPanel northPanel = new JPanel(new BorderLayout(0, 5));
        northPanel.add((Component)this.header, "North");
        northPanel.add((Component)northControls, "Center");
        this.setLayout(new BorderLayout(5, 5));
        this.add((Component)northPanel, "North");
        this.add((Component)new JScrollPane(this.table), "Center");
        this.add((Component)controls, "South");
    }

    @Override
    public Insets getInsets() {
        return Utils.INSETS;
    }

    protected void refreshFeeds(final int page) {
        this.page = page;
        GitblitWorker worker = new GitblitWorker(this, null){

            @Override
            protected Boolean doRequest() throws IOException {
                FeedsPanel.this.gitblit.refreshSubscribedFeeds(page);
                return true;
            }

            @Override
            protected void onSuccess() {
                FeedsPanel.this.updateTable(false);
            }
        };
        worker.execute();
    }

    protected abstract void subscribeFeeds(List<FeedModel> var1);

    protected void updateTable(boolean pack) {
        this.tableModel.entries.clear();
        this.tableModel.entries.addAll(this.gitblit.getSyndicatedEntries());
        this.tableModel.fireTableDataChanged();
        this.header.setText(Translation.get("gb.activity") + " (" + this.gitblit.getSyndicatedEntries().size() + (this.page > 0 ? ", pg " + (this.page + 1) : "") + ")");
        if (pack) {
            Utils.packColumns(this.table, 5);
        }
        this.table.scrollRectToVisible(new Rectangle(this.table.getCellRect(0, 0, true)));
        if (this.page == 0) {
            HashSet<String> uniqueRepositories = new HashSet<String>();
            for (FeedEntryModel entry : this.tableModel.entries) {
                uniqueRepositories.add(entry.repository);
            }
            ArrayList<String> sortedRespositories = new ArrayList<String>(uniqueRepositories);
            StringUtils.sortRepositorynames(sortedRespositories);
            this.repositoryChoices.removeAllElements();
            this.repositoryChoices.addElement("*");
            for (String repo : sortedRespositories) {
                this.repositoryChoices.addElement(repo);
            }
        }
        this.next.setEnabled(this.tableModel.entries.size() > 0);
        this.prev.setEnabled(this.page > 0);
    }

    private void updateAuthors() {
        String repository = "*";
        if (this.repositorySelector.getSelectedIndex() > -1) {
            repository = this.repositorySelector.getSelectedItem().toString();
        }
        HashSet<String> uniqueAuthors = new HashSet<String>();
        for (FeedEntryModel entry : this.tableModel.entries) {
            if (!repository.equals("*") && !entry.repository.equalsIgnoreCase(repository)) continue;
            uniqueAuthors.add(entry.author);
        }
        ArrayList sortedAuthors = new ArrayList(uniqueAuthors);
        Collections.sort(sortedAuthors);
        this.authorChoices.removeAllElements();
        this.authorChoices.addElement("*");
        for (String author : sortedAuthors) {
            this.authorChoices.addElement(author);
        }
    }

    protected FeedEntryModel getSelectedSyndicatedEntry() {
        int viewRow = this.table.getSelectedRow();
        int modelRow = this.table.convertRowIndexToModel(viewRow);
        FeedEntryModel entry = this.tableModel.get(modelRow);
        return entry;
    }

    protected void viewCommit() {
        FeedEntryModel entry = this.getSelectedSyndicatedEntry();
        Utils.browse(entry.link);
    }

    protected void viewCommitDiff() {
        FeedEntryModel entry = this.getSelectedSyndicatedEntry();
        Utils.browse(entry.link.replace("/commit/", "/commitdiff/"));
    }

    protected void viewTree() {
        FeedEntryModel entry = this.getSelectedSyndicatedEntry();
        Utils.browse(entry.link.replace("/commit/", "/tree/"));
    }

    protected void filterFeeds() {
        final String repository = this.repositorySelector.getSelectedIndex() > -1 ? this.repositorySelector.getSelectedItem().toString() : "*";
        final String author = this.authorSelector.getSelectedIndex() > -1 ? this.authorSelector.getSelectedItem().toString() : "*";
        if (repository.equals("*") && author.equals("*")) {
            this.table.setRowSorter(this.defaultSorter);
            return;
        }
        final int repositoryIndex = FeedEntryTableModel.Columns.Repository.ordinal();
        final int authorIndex = FeedEntryTableModel.Columns.Author.ordinal();
        RowFilter<FeedEntryTableModel, Object> containsFilter = repository.equals("*") ? new RowFilter<FeedEntryTableModel, Object>(){

            @Override
            public boolean include(RowFilter.Entry<? extends FeedEntryTableModel, ? extends Object> entry) {
                return entry.getStringValue(authorIndex).equalsIgnoreCase(author);
            }
        } : (author.equals("*") ? new RowFilter<FeedEntryTableModel, Object>(){

            @Override
            public boolean include(RowFilter.Entry<? extends FeedEntryTableModel, ? extends Object> entry) {
                return entry.getStringValue(repositoryIndex).equalsIgnoreCase(repository);
            }
        } : new RowFilter<FeedEntryTableModel, Object>(){

            @Override
            public boolean include(RowFilter.Entry<? extends FeedEntryTableModel, ? extends Object> entry) {
                boolean authorMatch = entry.getStringValue(authorIndex).equalsIgnoreCase(author);
                boolean repositoryMatch = entry.getStringValue(repositoryIndex).equalsIgnoreCase(repository);
                return authorMatch && repositoryMatch;
            }
        });
        TableRowSorter<FeedEntryTableModel> sorter = new TableRowSorter<FeedEntryTableModel>(this.tableModel);
        sorter.setRowFilter(containsFilter);
        this.table.setRowSorter(sorter);
    }
}

