/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.client;

import com.gitblit.Constants;
import com.gitblit.client.GitblitRegistration;
import com.gitblit.models.FederationModel;
import com.gitblit.models.FeedEntryModel;
import com.gitblit.models.FeedModel;
import com.gitblit.models.RegistrantAccessPermission;
import com.gitblit.models.RepositoryModel;
import com.gitblit.models.ServerSettings;
import com.gitblit.models.ServerStatus;
import com.gitblit.models.TeamModel;
import com.gitblit.models.UserModel;
import com.gitblit.utils.ArrayUtils;
import com.gitblit.utils.RpcUtils;
import com.gitblit.utils.StringUtils;
import com.gitblit.utils.SyndicationUtils;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class GitblitClient
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Date NEVER = new Date(0L);
    protected final GitblitRegistration reg;
    public final String url;
    public final String account;
    private final char[] password;
    private volatile int protocolVersion;
    private volatile boolean allowManagement;
    private volatile boolean allowAdministration;
    private volatile ServerSettings settings;
    private final List<RepositoryModel> allRepositories;
    private final List<UserModel> allUsers;
    private final List<TeamModel> allTeams;
    private final List<FederationModel> federationRegistrations;
    private final List<FeedModel> availableFeeds;
    private final List<FeedEntryModel> syndicatedEntries;
    private final Set<String> subscribedRepositories;
    private ServerStatus status;

    public GitblitClient(GitblitRegistration reg) {
        this.reg = reg;
        this.url = reg.url;
        this.account = reg.account;
        this.password = reg.password;
        this.allUsers = new ArrayList<UserModel>();
        this.allTeams = new ArrayList<TeamModel>();
        this.allRepositories = new ArrayList<RepositoryModel>();
        this.federationRegistrations = new ArrayList<FederationModel>();
        this.availableFeeds = new ArrayList<FeedModel>();
        this.syndicatedEntries = new ArrayList<FeedEntryModel>();
        this.subscribedRepositories = new HashSet<String>();
    }

    public void login() throws IOException {
        this.protocolVersion = RpcUtils.getProtocolVersion(this.url, this.account, this.password);
        this.refreshSettings();
        this.refreshAvailableFeeds();
        this.refreshRepositories();
        this.refreshSubscribedFeeds(0);
        this.refreshUsers();
        if (this.protocolVersion > 1) {
            this.refreshTeams();
        }
        this.allowManagement = true;
        this.refreshStatus();
        this.allowAdministration = true;
    }

    public int getProtocolVersion() {
        return this.protocolVersion;
    }

    public boolean allowManagement() {
        return this.allowManagement;
    }

    public boolean allowAdministration() {
        return this.allowAdministration;
    }

    public boolean isOwner(RepositoryModel model) {
        return model.isOwner(this.account);
    }

    public String getURL(String action, String repository, String objectId) {
        boolean mounted = this.settings.get("web.mountParameters").getBoolean(true);
        StringBuilder sb = new StringBuilder();
        sb.append(this.url);
        sb.append('/');
        sb.append(action);
        sb.append('/');
        if (mounted) {
            sb.append(StringUtils.encodeURL(repository));
            if (!StringUtils.isEmpty(objectId)) {
                sb.append('/');
                sb.append(objectId);
            }
            return sb.toString();
        }
        sb.append("?r=");
        sb.append(repository);
        if (!StringUtils.isEmpty(objectId)) {
            sb.append("&h=");
            sb.append(objectId);
        }
        return sb.toString();
    }

    public Constants.AccessRestrictionType getDefaultAccessRestriction() {
        String restriction = "PUSH";
        if (this.settings.hasKey("git.defaultAccessRestriction")) {
            restriction = this.settings.get((String)"git.defaultAccessRestriction").currentValue;
        }
        return Constants.AccessRestrictionType.fromName(restriction);
    }

    public Constants.AuthorizationControl getDefaultAuthorizationControl() {
        String authorization = null;
        if (this.settings.hasKey("git.defaultAuthorizationControl")) {
            authorization = this.settings.get((String)"git.defaultAuthorizationControl").currentValue;
        }
        return Constants.AuthorizationControl.fromName(authorization);
    }

    public List<String> getPreReceiveScriptsInherited(RepositoryModel repository) {
        LinkedHashSet<String> scripts = new LinkedHashSet<String>();
        for (String script : this.settings.get("groovy.preReceiveScripts").getStrings()) {
            if (script.endsWith(".groovy")) {
                scripts.add(script.substring(0, script.lastIndexOf(46)));
                continue;
            }
            scripts.add(script);
        }
        if (repository != null) {
            for (String teamname : this.getPermittedTeamnames(repository)) {
                TeamModel team = this.getTeamModel(teamname);
                if (ArrayUtils.isEmpty(team.preReceiveScripts)) continue;
                scripts.addAll(team.preReceiveScripts);
            }
        }
        return new ArrayList<String>(scripts);
    }

    public List<String> getPreReceiveScriptsUnused(RepositoryModel repository) {
        TreeSet<String> inherited = new TreeSet<String>(this.getPreReceiveScriptsInherited(repository));
        ArrayList<String> scripts = new ArrayList<String>();
        if (!ArrayUtils.isEmpty(this.settings.pushScripts)) {
            for (String script : this.settings.pushScripts) {
                if (inherited.contains(script)) continue;
                scripts.add(script);
            }
        }
        return scripts;
    }

    public List<String> getPostReceiveScriptsInherited(RepositoryModel repository) {
        LinkedHashSet<String> scripts = new LinkedHashSet<String>();
        for (String script : this.settings.get("groovy.postReceiveScripts").getStrings()) {
            if (script.endsWith(".groovy")) {
                scripts.add(script.substring(0, script.lastIndexOf(46)));
                continue;
            }
            scripts.add(script);
        }
        if (repository != null) {
            for (String teamname : this.getPermittedTeamnames(repository)) {
                TeamModel team = this.getTeamModel(teamname);
                if (ArrayUtils.isEmpty(team.postReceiveScripts)) continue;
                scripts.addAll(team.postReceiveScripts);
            }
        }
        return new ArrayList<String>(scripts);
    }

    public List<String> getPostReceiveScriptsUnused(RepositoryModel repository) {
        TreeSet<String> inherited = new TreeSet<String>(this.getPostReceiveScriptsInherited(repository));
        ArrayList<String> scripts = new ArrayList<String>();
        if (!ArrayUtils.isEmpty(this.settings.pushScripts)) {
            for (String script : this.settings.pushScripts) {
                if (inherited.contains(script)) continue;
                scripts.add(script);
            }
        }
        return scripts;
    }

    public ServerSettings getSettings() {
        return this.settings;
    }

    public ServerStatus getStatus() {
        return this.status;
    }

    public String getSettingDescription(String key) {
        return this.settings.get((String)key).description;
    }

    public List<RepositoryModel> refreshRepositories() throws IOException {
        Map<String, RepositoryModel> repositories = RpcUtils.getRepositories(this.url, this.account, this.password);
        this.allRepositories.clear();
        this.allRepositories.addAll(repositories.values());
        Collections.sort(this.allRepositories);
        this.markSubscribedFeeds();
        return this.allRepositories;
    }

    public List<UserModel> refreshUsers() throws IOException {
        List<UserModel> users = RpcUtils.getUsers(this.url, this.account, this.password);
        this.allUsers.clear();
        this.allUsers.addAll(users);
        Collections.sort(users);
        return this.allUsers;
    }

    public List<TeamModel> refreshTeams() throws IOException {
        List<TeamModel> teams = RpcUtils.getTeams(this.url, this.account, this.password);
        this.allTeams.clear();
        this.allTeams.addAll(teams);
        Collections.sort(teams);
        return this.allTeams;
    }

    public ServerSettings refreshSettings() throws IOException {
        this.settings = RpcUtils.getSettings(this.url, this.account, this.password);
        return this.settings;
    }

    public ServerStatus refreshStatus() throws IOException {
        this.status = RpcUtils.getStatus(this.url, this.account, this.password);
        return this.status;
    }

    public List<String> getBranches(String repository) {
        List<FeedModel> feeds = this.getAvailableFeeds(repository);
        ArrayList<String> branches = new ArrayList<String>();
        for (FeedModel feed : feeds) {
            branches.add(feed.branch);
        }
        Collections.sort(branches);
        return branches;
    }

    public List<FeedModel> getAvailableFeeds() {
        return this.availableFeeds;
    }

    public List<FeedModel> getAvailableFeeds(RepositoryModel repository) {
        return this.getAvailableFeeds(repository.name);
    }

    public List<FeedModel> getAvailableFeeds(String repository) {
        ArrayList<FeedModel> repositoryFeeds = new ArrayList<FeedModel>();
        if (repository == null) {
            return repositoryFeeds;
        }
        for (FeedModel feed : this.availableFeeds) {
            if (!feed.repository.equalsIgnoreCase(repository)) continue;
            repositoryFeeds.add(feed);
        }
        return repositoryFeeds;
    }

    public List<FeedModel> refreshAvailableFeeds() throws IOException {
        List<FeedModel> feeds = RpcUtils.getBranchFeeds(this.url, this.account, this.password);
        this.availableFeeds.clear();
        this.availableFeeds.addAll(feeds);
        this.markSubscribedFeeds();
        return this.availableFeeds;
    }

    public List<FeedEntryModel> refreshSubscribedFeeds(int page) throws IOException {
        HashSet<FeedEntryModel> allEntries = new HashSet<FeedEntryModel>();
        if (this.reg.feeds.size() > 0) {
            for (FeedModel feed : this.reg.feeds) {
                feed.lastRefreshDate = feed.currentRefreshDate;
                feed.currentRefreshDate = new Date();
                List<FeedEntryModel> entries = SyndicationUtils.readFeed(this.url, feed.repository, feed.branch, -1, page, this.account, this.password);
                allEntries.addAll(entries);
            }
        }
        this.reg.cacheFeeds();
        this.syndicatedEntries.clear();
        this.syndicatedEntries.addAll(allEntries);
        Collections.sort(this.syndicatedEntries);
        return this.syndicatedEntries;
    }

    public void updateSubscribedFeeds(List<FeedModel> list) {
        this.reg.updateSubscribedFeeds(list);
        this.markSubscribedFeeds();
    }

    private void markSubscribedFeeds() {
        this.subscribedRepositories.clear();
        for (FeedModel feed : this.availableFeeds) {
            feed.subscribed = this.reg.feeds.contains(feed);
            if (!feed.subscribed) continue;
            this.subscribedRepositories.add(feed.repository.toLowerCase());
        }
    }

    public Date getLastFeedRefresh(String repository, String branch) {
        FeedModel feed = new FeedModel();
        feed.repository = repository;
        feed.branch = branch;
        if (this.reg.feeds.contains(feed)) {
            int idx = this.reg.feeds.indexOf(feed);
            feed = this.reg.feeds.get(idx);
            return feed.lastRefreshDate;
        }
        return NEVER;
    }

    public boolean isSubscribed(RepositoryModel repository) {
        return this.subscribedRepositories.contains(repository.name.toLowerCase());
    }

    public List<FeedEntryModel> getSyndicatedEntries() {
        return this.syndicatedEntries;
    }

    public List<FeedEntryModel> log(String repository, String branch, int numberOfEntries, int page) throws IOException {
        return SyndicationUtils.readFeed(this.url, repository, branch, numberOfEntries, page, this.account, this.password);
    }

    public List<FeedEntryModel> search(String repository, String branch, String fragment, Constants.SearchType type, int numberOfEntries, int page) throws IOException {
        return SyndicationUtils.readSearchFeed(this.url, repository, branch, fragment, type, numberOfEntries, page, this.account, this.password);
    }

    public List<FederationModel> refreshFederationRegistrations() throws IOException {
        List<FederationModel> list = RpcUtils.getFederationRegistrations(this.url, this.account, this.password);
        this.federationRegistrations.clear();
        this.federationRegistrations.addAll(list);
        return this.federationRegistrations;
    }

    public List<UserModel> getUsers() {
        return this.allUsers;
    }

    public UserModel getUser(String username) {
        for (UserModel user : this.getUsers()) {
            if (!user.username.equalsIgnoreCase(username)) continue;
            return user;
        }
        return null;
    }

    public List<String> getUsernames() {
        ArrayList<String> usernames = new ArrayList<String>();
        for (UserModel user : this.allUsers) {
            usernames.add(user.username);
        }
        Collections.sort(usernames);
        return usernames;
    }

    public List<String> getPermittedUsernames(RepositoryModel repository) {
        ArrayList<String> usernames = new ArrayList<String>();
        for (UserModel user : this.allUsers) {
            if (!user.hasRepositoryPermission(repository.name)) continue;
            usernames.add(user.username);
        }
        return usernames;
    }

    public List<RegistrantAccessPermission> getUserAccessPermissions(UserModel user) {
        LinkedHashSet<RegistrantAccessPermission> set = new LinkedHashSet<RegistrantAccessPermission>();
        set.addAll(user.getRepositoryPermissions());
        for (RegistrantAccessPermission permission : set) {
            RepositoryModel rm;
            if (!permission.mutable || !Constants.PermissionType.EXPLICIT.equals((Object)permission.permissionType) || (rm = this.getRepository(permission.registrant)) != null) continue;
            permission.permissionType = Constants.PermissionType.MISSING;
            permission.mutable = false;
        }
        for (RepositoryModel rm : this.allRepositories) {
            if (!rm.isUsersPersonalRepository(user.username) && !rm.isOwner(user.username)) continue;
            RegistrantAccessPermission rp = new RegistrantAccessPermission(rm.name, Constants.AccessPermission.REWIND, Constants.PermissionType.OWNER, Constants.RegistrantType.REPOSITORY, null, false);
            set.remove(rp);
            set.add(rp);
        }
        ArrayList<RegistrantAccessPermission> list = new ArrayList<RegistrantAccessPermission>(set);
        Collections.sort(list);
        return list;
    }

    public List<RegistrantAccessPermission> getUserAccessPermissions(RepositoryModel repository) {
        ArrayList<RegistrantAccessPermission> list = new ArrayList<RegistrantAccessPermission>();
        if (Constants.AccessRestrictionType.NONE.equals((Object)repository.accessRestriction)) {
            return list;
        }
        if (Constants.AuthorizationControl.AUTHENTICATED.equals((Object)repository.authorizationControl)) {
            return list;
        }
        for (UserModel user : this.allUsers) {
            RegistrantAccessPermission ap = user.getRepositoryPermission(repository);
            if (!ap.permission.exceeds(Constants.AccessPermission.NONE)) continue;
            list.add(ap);
        }
        return list;
    }

    public boolean setUserAccessPermissions(RepositoryModel repository, List<RegistrantAccessPermission> permissions) throws IOException {
        return RpcUtils.setRepositoryMemberPermissions(repository, permissions, this.url, this.account, this.password);
    }

    public List<TeamModel> getTeams() {
        return this.allTeams;
    }

    public List<String> getTeamnames() {
        ArrayList<String> teamnames = new ArrayList<String>();
        for (TeamModel team : this.allTeams) {
            teamnames.add(team.name);
        }
        Collections.sort(teamnames);
        return teamnames;
    }

    public List<String> getPermittedTeamnames(RepositoryModel repository) {
        ArrayList<String> teamnames = new ArrayList<String>();
        for (TeamModel team : this.allTeams) {
            if (!team.hasRepositoryPermission(repository.name)) continue;
            teamnames.add(team.name);
        }
        return teamnames;
    }

    public List<RegistrantAccessPermission> getTeamAccessPermissions(RepositoryModel repository) {
        ArrayList<RegistrantAccessPermission> list = new ArrayList<RegistrantAccessPermission>();
        for (TeamModel team : this.allTeams) {
            RegistrantAccessPermission ap = team.getRepositoryPermission(repository);
            if (!ap.permission.exceeds(Constants.AccessPermission.NONE)) continue;
            list.add(ap);
        }
        Collections.sort(list);
        return list;
    }

    public boolean setTeamAccessPermissions(RepositoryModel repository, List<RegistrantAccessPermission> permissions) throws IOException {
        return RpcUtils.setRepositoryTeamPermissions(repository, permissions, this.url, this.account, this.password);
    }

    public TeamModel getTeamModel(String name) {
        for (TeamModel team : this.allTeams) {
            if (!team.name.equalsIgnoreCase(name)) continue;
            return team;
        }
        return null;
    }

    public List<String> getFederationSets() {
        return this.settings.get("federation.sets").getStrings();
    }

    public List<RepositoryModel> getRepositories() {
        return this.allRepositories;
    }

    public RepositoryModel getRepository(String name) {
        for (RepositoryModel repository : this.allRepositories) {
            if (!repository.name.equalsIgnoreCase(name)) continue;
            return repository;
        }
        return null;
    }

    public boolean createRepository(RepositoryModel repository, List<RegistrantAccessPermission> userPermissions) throws IOException {
        return this.createRepository(repository, userPermissions, null);
    }

    public boolean createRepository(RepositoryModel repository, List<RegistrantAccessPermission> userPermissions, List<RegistrantAccessPermission> teamPermissions) throws IOException {
        boolean success = true;
        success &= RpcUtils.createRepository(repository, this.url, this.account, this.password);
        if (userPermissions != null && userPermissions.size() > 0) {
            success &= RpcUtils.setRepositoryMemberPermissions(repository, userPermissions, this.url, this.account, this.password);
        }
        if (teamPermissions != null && teamPermissions.size() > 0) {
            success &= RpcUtils.setRepositoryTeamPermissions(repository, teamPermissions, this.url, this.account, this.password);
        }
        return success;
    }

    public boolean updateRepository(String name, RepositoryModel repository, List<RegistrantAccessPermission> userPermissions) throws IOException {
        return this.updateRepository(name, repository, userPermissions, null);
    }

    public boolean updateRepository(String name, RepositoryModel repository, List<RegistrantAccessPermission> userPermissions, List<RegistrantAccessPermission> teamPermissions) throws IOException {
        boolean success = true;
        success &= RpcUtils.updateRepository(name, repository, this.url, this.account, this.password);
        if (userPermissions != null) {
            success &= RpcUtils.setRepositoryMemberPermissions(repository, userPermissions, this.url, this.account, this.password);
        }
        if (teamPermissions != null) {
            success &= RpcUtils.setRepositoryTeamPermissions(repository, teamPermissions, this.url, this.account, this.password);
        }
        return success;
    }

    public boolean deleteRepository(RepositoryModel repository) throws IOException {
        return RpcUtils.deleteRepository(repository, this.url, this.account, this.password);
    }

    public boolean clearRepositoryCache() throws IOException {
        return RpcUtils.clearRepositoryCache(this.url, this.account, this.password);
    }

    public boolean createUser(UserModel user) throws IOException {
        return RpcUtils.createUser(user, this.url, this.account, this.password);
    }

    public boolean updateUser(String name, UserModel user) throws IOException {
        return RpcUtils.updateUser(name, user, this.url, this.account, this.password);
    }

    public boolean deleteUser(UserModel user) throws IOException {
        return RpcUtils.deleteUser(user, this.url, this.account, this.password);
    }

    public boolean createTeam(TeamModel team) throws IOException {
        return RpcUtils.createTeam(team, this.url, this.account, this.password);
    }

    public boolean updateTeam(String name, TeamModel team) throws IOException {
        return RpcUtils.updateTeam(name, team, this.url, this.account, this.password);
    }

    public boolean deleteTeam(TeamModel team) throws IOException {
        return RpcUtils.deleteTeam(team, this.url, this.account, this.password);
    }

    public boolean updateSettings(Map<String, String> newSettings) throws IOException {
        return RpcUtils.updateSettings(newSettings, this.url, this.account, this.password);
    }
}

