/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.client;

import com.gitblit.client.ClosableTabComponent;
import com.gitblit.client.FeedsPanel;
import com.gitblit.client.GitblitClient;
import com.gitblit.client.GitblitRegistration;
import com.gitblit.client.RegistrationsDialog;
import com.gitblit.client.RepositoriesPanel;
import com.gitblit.client.SettingsPanel;
import com.gitblit.client.StatusPanel;
import com.gitblit.client.SubscriptionsDialog;
import com.gitblit.client.TeamsPanel;
import com.gitblit.client.Translation;
import com.gitblit.client.UsersPanel;
import com.gitblit.client.Utils;
import com.gitblit.models.FeedModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.io.IOException;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class GitblitPanel
extends JPanel
implements ClosableTabComponent.CloseTabListener {
    private static final long serialVersionUID = 1L;
    private final RegistrationsDialog.RegistrationListener listener;
    private GitblitClient gitblit;
    private JTabbedPane tabs;
    private RepositoriesPanel repositoriesPanel;
    private FeedsPanel feedsPanel;
    private UsersPanel usersPanel;
    private TeamsPanel teamsPanel;
    private SettingsPanel settingsPanel;
    private StatusPanel statusPanel;

    public GitblitPanel(GitblitRegistration reg, RegistrationsDialog.RegistrationListener listener) {
        this.gitblit = new GitblitClient(reg);
        this.listener = listener;
        this.tabs = new JTabbedPane(3);
        this.tabs.addTab(Translation.get("gb.repositories"), this.createRepositoriesPanel());
        this.tabs.addTab(Translation.get("gb.activity"), this.createFeedsPanel());
        this.tabs.addTab(Translation.get("gb.teams"), this.createTeamsPanel());
        this.tabs.addTab(Translation.get("gb.users"), this.createUsersPanel());
        this.tabs.addTab(Translation.get("gb.settings"), this.createSettingsPanel());
        this.tabs.addTab(Translation.get("gb.status"), this.createStatusPanel());
        this.tabs.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                GitblitPanel.this.tabs.getSelectedComponent().requestFocus();
            }
        });
        this.setLayout(new BorderLayout());
        this.add((Component)this.tabs, "Center");
    }

    private JPanel createRepositoriesPanel() {
        this.repositoriesPanel = new RepositoriesPanel(this.gitblit){
            private static final long serialVersionUID = 1L;

            @Override
            protected void subscribeFeeds(List<FeedModel> feeds) {
                GitblitPanel.this.subscribeFeeds(feeds);
            }

            @Override
            protected void updateUsersTable() {
                GitblitPanel.this.usersPanel.updateTable(false);
            }

            @Override
            protected void updateTeamsTable() {
                GitblitPanel.this.teamsPanel.updateTable(false);
            }
        };
        return this.repositoriesPanel;
    }

    private JPanel createFeedsPanel() {
        this.feedsPanel = new FeedsPanel(this.gitblit){
            private static final long serialVersionUID = 1L;

            @Override
            protected void subscribeFeeds(List<FeedModel> feeds) {
                GitblitPanel.this.subscribeFeeds(feeds);
            }
        };
        return this.feedsPanel;
    }

    private JPanel createUsersPanel() {
        this.usersPanel = new UsersPanel(this.gitblit){
            private static final long serialVersionUID = 1L;

            @Override
            protected void updateTeamsTable() {
                GitblitPanel.this.teamsPanel.updateTable(false);
            }
        };
        return this.usersPanel;
    }

    private JPanel createTeamsPanel() {
        this.teamsPanel = new TeamsPanel(this.gitblit){
            private static final long serialVersionUID = 1L;

            @Override
            protected void updateUsersTable() {
                GitblitPanel.this.usersPanel.updateTable(false);
            }
        };
        return this.teamsPanel;
    }

    private JPanel createSettingsPanel() {
        this.settingsPanel = new SettingsPanel(this.gitblit);
        return this.settingsPanel;
    }

    private JPanel createStatusPanel() {
        this.statusPanel = new StatusPanel(this.gitblit);
        return this.statusPanel;
    }

    public void login() throws IOException {
        this.gitblit.login();
        this.repositoriesPanel.updateTable(true);
        this.feedsPanel.updateTable(true);
        if (this.gitblit.allowManagement()) {
            if (this.gitblit.getProtocolVersion() >= 2) {
                this.teamsPanel.updateTable(false);
            } else {
                String teams = Translation.get("gb.teams");
                for (int i = 0; i < this.tabs.getTabCount(); ++i) {
                    if (!teams.equals(this.tabs.getTitleAt(i))) continue;
                    this.tabs.removeTabAt(i);
                    break;
                }
            }
            this.usersPanel.updateTable(false);
        } else {
            this.repositoriesPanel.disableManagement();
            while (this.tabs.getTabCount() > 2) {
                this.tabs.removeTabAt(2);
            }
        }
        if (this.gitblit.allowAdministration()) {
            this.settingsPanel.updateTable(true);
            this.statusPanel.updateTable(false);
        } else {
            String[] titles;
            block2: for (String title : titles = new String[]{Translation.get("gb.settings"), Translation.get("gb.status")}) {
                for (int i = 0; i < this.tabs.getTabCount(); ++i) {
                    if (!this.tabs.getTitleAt(i).equals(title)) continue;
                    this.tabs.removeTabAt(i);
                    continue block2;
                }
            }
        }
    }

    @Override
    public Insets getInsets() {
        return Utils.INSETS;
    }

    @Override
    public void closeTab(Component c) {
        this.gitblit = null;
    }

    protected void subscribeFeeds(final List<FeedModel> feeds) {
        SubscriptionsDialog dialog = new SubscriptionsDialog(feeds){
            private static final long serialVersionUID = 1L;

            @Override
            public void save() {
                GitblitPanel.this.gitblit.updateSubscribedFeeds(feeds);
                GitblitPanel.this.listener.saveRegistration(((GitblitPanel)GitblitPanel.this).gitblit.reg.name, ((GitblitPanel)GitblitPanel.this).gitblit.reg);
                this.setVisible(false);
                GitblitPanel.this.repositoriesPanel.updateTable(false);
            }
        };
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
    }
}

