/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.client;

import com.gitblit.models.FeedModel;
import com.gitblit.utils.StringUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class GitblitRegistration
implements Serializable,
Comparable<GitblitRegistration> {
    private static final long serialVersionUID = 1L;
    String name;
    String url;
    String account;
    char[] password;
    boolean savePassword;
    Date lastLogin;
    final List<FeedModel> feeds;

    public GitblitRegistration(String name, String url, String account, char[] password) {
        this.url = url;
        this.account = account;
        this.password = password;
        this.savePassword = password != null && password.length > 0;
        this.name = StringUtils.isEmpty(name) ? url.substring(url.indexOf("//") + 2) : name;
        this.feeds = new ArrayList<FeedModel>();
    }

    public void updateSubscribedFeeds(List<FeedModel> list) {
        for (FeedModel feed : list) {
            if (this.feeds.contains(feed)) {
                int index = this.feeds.indexOf(feed);
                FeedModel existingFeed = this.feeds.get(index);
                existingFeed.subscribed = feed.subscribed;
                if (existingFeed.subscribed) continue;
                this.feeds.remove(index);
                continue;
            }
            if (!feed.subscribed) continue;
            this.feeds.add(feed);
        }
    }

    protected void cacheFeeds() {
    }

    @Override
    public int compareTo(GitblitRegistration o) {
        return this.name.toLowerCase().compareTo(o.name.toLowerCase());
    }

    public String toString() {
        return this.name + " (" + this.url + ")";
    }
}

