/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.client;

import com.gitblit.client.NameRenderer;
import com.gitblit.client.Translation;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;

public class JPalette<T>
extends JPanel {
    private static final long serialVersionUID = 1L;
    private PaletteModel<T> availableModel = new PaletteModel();
    private PaletteModel<T> selectedModel = new PaletteModel();
    private JButton add;
    private JButton subtract;
    private JButton up;
    private JButton down;

    public JPalette() {
        this(false);
    }

    public JPalette(boolean controlOrder) {
        super(new BorderLayout(5, 5));
        final JTable available = new JTable(this.availableModel);
        final JTable selected = new JTable(this.selectedModel);
        this.add = new JButton("->");
        this.add.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                ArrayList move = new ArrayList();
                if (available.getSelectedRowCount() <= 0) {
                    return;
                }
                for (int row : available.getSelectedRows()) {
                    int modelIndex = available.convertRowIndexToModel(row);
                    Object item = ((JPalette)JPalette.this).availableModel.list.get(modelIndex);
                    move.add(item);
                }
                ((JPalette)JPalette.this).availableModel.list.removeAll(move);
                ((JPalette)JPalette.this).selectedModel.list.addAll(move);
                JPalette.this.availableModel.fireTableDataChanged();
                JPalette.this.selectedModel.fireTableDataChanged();
            }
        });
        this.subtract = new JButton("<-");
        this.subtract.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                ArrayList move = new ArrayList();
                if (selected.getSelectedRowCount() <= 0) {
                    return;
                }
                for (int row : selected.getSelectedRows()) {
                    int modelIndex = selected.convertRowIndexToModel(row);
                    Object item = ((JPalette)JPalette.this).selectedModel.list.get(modelIndex);
                    move.add(item);
                }
                ((JPalette)JPalette.this).selectedModel.list.removeAll(move);
                ((JPalette)JPalette.this).availableModel.list.addAll(move);
                JPalette.this.selectedModel.fireTableDataChanged();
                JPalette.this.availableModel.fireTableDataChanged();
            }
        });
        this.up = new JButton("\u2191");
        this.up.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                int row = selected.getSelectedRow();
                if (row > 0) {
                    Object o = ((JPalette)JPalette.this).selectedModel.list.remove(row);
                    ((JPalette)JPalette.this).selectedModel.list.add(row - 1, o);
                    JPalette.this.selectedModel.fireTableDataChanged();
                }
            }
        });
        this.down = new JButton("\u2193");
        this.down.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                int row = selected.getSelectedRow();
                if (row < selected.getRowCount() - 1) {
                    Object o = ((JPalette)JPalette.this).selectedModel.list.remove(row);
                    ((JPalette)JPalette.this).selectedModel.list.add(row + 1, o);
                    JPalette.this.selectedModel.fireTableDataChanged();
                }
            }
        });
        JPanel controls = new JPanel(new GridLayout(0, 1, 0, 5));
        controls.add(this.add);
        controls.add(this.subtract);
        if (controlOrder) {
            controls.add(this.up);
            controls.add(this.down);
        }
        JPanel center = new JPanel(new GridBagLayout());
        center.add(controls);
        this.add((Component)this.newListPanel(Translation.get("gb.available"), available), "West");
        this.add((Component)center, "Center");
        this.add((Component)this.newListPanel(Translation.get("gb.selected"), selected), "East");
    }

    private JPanel newListPanel(String label, JTable table) {
        NameRenderer nameRenderer = new NameRenderer();
        table.setCellSelectionEnabled(false);
        table.setRowSelectionAllowed(true);
        table.getTableHeader().setReorderingAllowed(false);
        table.setGridColor(new Color(0xD9D9D9));
        table.setBackground(Color.white);
        table.getColumn(table.getColumnName(0)).setCellRenderer(nameRenderer);
        JScrollPane jsp = new JScrollPane(table);
        jsp.setPreferredSize(new Dimension(225, 160));
        JPanel panel = new JPanel(new BorderLayout());
        JLabel jlabel = new JLabel(label);
        jlabel.setFont(jlabel.getFont().deriveFont(1));
        panel.add((Component)jlabel, "North");
        panel.add((Component)jsp, "Center");
        return panel;
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.add.setEnabled(enabled);
        this.subtract.setEnabled(enabled);
        this.up.setEnabled(enabled);
        this.down.setEnabled(enabled);
    }

    public void setObjects(List<T> all, List<T> selected) {
        ArrayList<T> available = new ArrayList<T>(all);
        if (selected != null) {
            available.removeAll(selected);
        }
        this.availableModel.list.clear();
        this.availableModel.list.addAll(available);
        this.availableModel.fireTableDataChanged();
        if (selected != null) {
            this.selectedModel.list.clear();
            this.selectedModel.list.addAll(selected);
            this.selectedModel.fireTableDataChanged();
        }
    }

    public List<T> getSelections() {
        return new ArrayList(this.selectedModel.list);
    }

    public class PaletteModel<K>
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;
        List<K> list;

        public PaletteModel() {
            this(new ArrayList());
        }

        public PaletteModel(List<K> list) {
            this.list = new ArrayList<K>(list);
        }

        @Override
        public int getRowCount() {
            return this.list.size();
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public String getColumnName(int column) {
            return Translation.get("gb.name");
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return String.class;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            K o = this.list.get(rowIndex);
            return o.toString();
        }
    }
}

