/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.client;

import java.awt.Color;
import java.awt.Component;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.table.DefaultTableCellRenderer;

public class NameRenderer
extends DefaultTableCellRenderer
implements ListCellRenderer {
    private static final long serialVersionUID = 1L;
    private static final Color CORNFLOWER = new Color(0, 105, 214);
    private final String groupSpan;

    public NameRenderer() {
        this(Color.gray, CORNFLOWER);
    }

    private NameRenderer(Color group, Color repo) {
        this.groupSpan = "<span style='color:" + this.getHexColor(group) + "'>";
        this.setForeground(repo);
    }

    String getHexColor(Color c) {
        StringBuilder sb = new StringBuilder();
        sb.append(Integer.toHexString(c.getRGB() & 0xFFFFFF));
        while (sb.length() < 6) {
            sb.insert(0, '0');
        }
        sb.insert(0, '#');
        return sb.toString();
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        this.setValue(value == null ? "" : value, isSelected);
        return this;
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        this.setValue(value == null ? "" : value, isSelected);
        if (isSelected) {
            this.setBackground(list.getSelectionBackground());
            this.setForeground(list.getSelectionForeground());
        } else {
            this.setBackground(list.getBackground());
            this.setForeground(CORNFLOWER);
        }
        return this;
    }

    private void setValue(Object value, boolean isSelected) {
        String name = value.toString();
        int lastSlash = name.lastIndexOf(47);
        if (!isSelected && lastSlash > -1) {
            String group = name.substring(0, lastSlash + 1);
            String repo = name.substring(lastSlash + 1);
            this.setText("<html><body>" + this.groupSpan + group + "</span>" + repo);
        } else {
            this.setText(name);
        }
    }
}

