/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.client;

import com.gitblit.Constants;
import com.gitblit.client.NameRenderer;
import com.gitblit.client.RegistrantPermissionsTableModel;
import com.gitblit.client.Translation;
import com.gitblit.client.Utils;
import com.gitblit.models.RegistrantAccessPermission;
import com.gitblit.utils.StringUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

public class RegistrantPermissionsPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JTable permissionsTable;
    private RegistrantPermissionsTableModel tableModel = new RegistrantPermissionsTableModel();
    private DefaultComboBoxModel registrantModel;
    private JComboBox registrantSelector;
    private JComboBox permissionSelector;
    private JButton addButton;
    private JPanel addPanel;

    public RegistrantPermissionsPanel(final Constants.RegistrantType registrantType) {
        super(new BorderLayout(5, 5));
        this.permissionsTable = Utils.newTable(this.tableModel, "yyyy-MM-dd", new Utils.RowRenderer(){
            Color clear = new Color(0, 0, 0, 0);
            Color iceGray = new Color(240, 240, 240);

            @Override
            public void prepareRow(Component c, boolean isSelected, int row, int column) {
                if (isSelected) {
                    c.setBackground(RegistrantPermissionsPanel.this.permissionsTable.getSelectionBackground());
                } else if (((RegistrantPermissionsPanel)RegistrantPermissionsPanel.this).tableModel.permissions.get((int)row).mutable) {
                    c.setBackground(this.clear);
                } else {
                    c.setBackground(this.iceGray);
                }
            }
        });
        this.permissionsTable.setModel(this.tableModel);
        this.permissionsTable.setPreferredScrollableViewportSize(new Dimension(400, 150));
        JScrollPane jsp = new JScrollPane(this.permissionsTable);
        this.add((Component)jsp, "Center");
        this.permissionsTable.getColumnModel().getColumn(RegistrantPermissionsTableModel.Columns.Registrant.ordinal()).setCellRenderer(new NameRenderer());
        this.permissionsTable.getColumnModel().getColumn(RegistrantPermissionsTableModel.Columns.Type.ordinal()).setCellRenderer(new PermissionTypeRenderer());
        this.permissionsTable.getColumnModel().getColumn(RegistrantPermissionsTableModel.Columns.Permission.ordinal()).setCellEditor(new AccessPermissionEditor());
        this.registrantModel = new DefaultComboBoxModel();
        this.registrantSelector = new JComboBox(this.registrantModel);
        this.permissionSelector = new JComboBox<Constants.AccessPermission>(Constants.AccessPermission.NEWPERMISSIONS);
        this.addButton = new JButton(Translation.get("gb.add"));
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (RegistrantPermissionsPanel.this.registrantSelector.getSelectedIndex() < 0) {
                    return;
                }
                if (RegistrantPermissionsPanel.this.permissionSelector.getSelectedIndex() < 0) {
                    return;
                }
                RegistrantAccessPermission rp = new RegistrantAccessPermission(registrantType);
                rp.registrant = RegistrantPermissionsPanel.this.registrantSelector.getSelectedItem().toString();
                rp.permission = (Constants.AccessPermission)((Object)RegistrantPermissionsPanel.this.permissionSelector.getSelectedItem());
                if (StringUtils.findInvalidCharacter(rp.registrant) != null) {
                    rp.permissionType = Constants.PermissionType.REGEX;
                    rp.source = rp.registrant;
                } else {
                    rp.permissionType = Constants.PermissionType.EXPLICIT;
                }
                ((RegistrantPermissionsPanel)RegistrantPermissionsPanel.this).tableModel.permissions.add(rp);
                Collections.sort(((RegistrantPermissionsPanel)RegistrantPermissionsPanel.this).tableModel.permissions);
                RegistrantPermissionsPanel.this.registrantModel.removeElement(rp.registrant);
                RegistrantPermissionsPanel.this.registrantSelector.setSelectedIndex(-1);
                RegistrantPermissionsPanel.this.registrantSelector.invalidate();
                RegistrantPermissionsPanel.this.addPanel.setVisible(RegistrantPermissionsPanel.this.registrantModel.getSize() > 0);
                RegistrantPermissionsPanel.this.tableModel.fireTableDataChanged();
            }
        });
        this.addPanel = new JPanel();
        this.addPanel.add(this.registrantSelector);
        this.addPanel.add(this.permissionSelector);
        this.addPanel.add(this.addButton);
        this.add((Component)this.addPanel, "South");
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.permissionsTable.setEnabled(enabled);
        this.registrantSelector.setEnabled(enabled);
        this.permissionSelector.setEnabled(enabled);
        this.addButton.setEnabled(enabled);
    }

    public void setObjects(List<String> registrants, List<RegistrantAccessPermission> permissions) {
        ArrayList<Object> filtered = registrants == null ? new ArrayList() : new ArrayList<String>(registrants);
        if (permissions == null) {
            permissions = new ArrayList<RegistrantAccessPermission>();
        }
        for (RegistrantAccessPermission registrantAccessPermission : permissions) {
            if (registrantAccessPermission.mutable) {
                filtered.remove(registrantAccessPermission.registrant);
                continue;
            }
            if (registrantAccessPermission.isAdmin()) {
                filtered.remove(registrantAccessPermission.registrant);
                continue;
            }
            if (!registrantAccessPermission.isOwner()) continue;
            filtered.remove(registrantAccessPermission.registrant);
        }
        for (String string : filtered) {
            this.registrantModel.addElement(string);
        }
        this.tableModel.setPermissions(permissions);
        this.registrantSelector.setSelectedIndex(-1);
        this.permissionSelector.setSelectedIndex(-1);
        this.addPanel.setVisible(filtered.size() > 0);
    }

    public List<RegistrantAccessPermission> getPermissions() {
        return this.tableModel.permissions;
    }

    private class PermissionTypeRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;

        public PermissionTypeRenderer() {
            this.setHorizontalAlignment(0);
        }

        @Override
        protected void setValue(Object value) {
            RegistrantAccessPermission ap = (RegistrantAccessPermission)value;
            switch (ap.permissionType) {
                case ADMINISTRATOR: {
                    this.setText(ap.source == null ? Translation.get("gb.administrator") : ap.source);
                    this.setToolTipText(Translation.get("gb.administratorPermission"));
                    break;
                }
                case OWNER: {
                    this.setText(Translation.get("gb.owner"));
                    this.setToolTipText(Translation.get("gb.ownerPermission"));
                    break;
                }
                case TEAM: {
                    this.setText(ap.source == null ? Translation.get("gb.team") : ap.source);
                    this.setToolTipText(MessageFormat.format(Translation.get("gb.teamPermission"), ap.source));
                    break;
                }
                case REGEX: {
                    this.setText("regex");
                    this.setToolTipText(MessageFormat.format(Translation.get("gb.regexPermission"), ap.source));
                    break;
                }
                default: {
                    if (ap.isMissing()) {
                        this.setText(Translation.get("gb.missing"));
                        this.setToolTipText(Translation.get("gb.missingPermission"));
                        break;
                    }
                    this.setText("");
                    this.setToolTipText(null);
                }
            }
        }
    }

    private class AccessPermissionEditor
    extends DefaultCellEditor {
        private static final long serialVersionUID = 1L;

        public AccessPermissionEditor() {
            super(new JComboBox<Constants.AccessPermission>(Constants.AccessPermission.values()));
        }
    }
}

