/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.client;

import com.gitblit.client.EditRegistrationDialog;
import com.gitblit.client.GitblitRegistration;
import com.gitblit.client.HeaderPanel;
import com.gitblit.client.NameRenderer;
import com.gitblit.client.RegistrationsTableModel;
import com.gitblit.client.Translation;
import com.gitblit.client.Utils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class RegistrationsDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private final List<GitblitRegistration> registrations;
    private final RegistrationListener listener;
    private JTable registrationsTable;
    private RegistrationsTableModel model;

    public RegistrationsDialog(List<GitblitRegistration> registrations, RegistrationListener listener) {
        this.registrations = registrations;
        this.listener = listener;
        this.setTitle(Translation.get("gb.manage"));
        this.setIconImage(new ImageIcon(this.getClass().getResource("/gitblt-favicon.png")).getImage());
        this.initialize();
        this.setSize(600, 400);
    }

    @Override
    protected JRootPane createRootPane() {
        KeyStroke stroke = KeyStroke.getKeyStroke(27, 0);
        JRootPane rootPane = new JRootPane();
        rootPane.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RegistrationsDialog.this.setVisible(false);
            }
        }, stroke, 2);
        return rootPane;
    }

    private void initialize() {
        NameRenderer nameRenderer = new NameRenderer();
        this.model = new RegistrationsTableModel(this.registrations);
        this.registrationsTable = Utils.newTable(this.model, "yyyy-MM-dd");
        String id = this.registrationsTable.getColumnName(RegistrationsTableModel.Columns.Name.ordinal());
        this.registrationsTable.getColumn(id).setCellRenderer(nameRenderer);
        this.registrationsTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    RegistrationsDialog.this.login();
                }
            }
        });
        JButton create = new JButton(Translation.get("gb.create"));
        create.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                RegistrationsDialog.this.create();
            }
        });
        final JButton login = new JButton(Translation.get("gb.login"));
        login.setEnabled(false);
        login.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                RegistrationsDialog.this.login();
            }
        });
        final JButton edit = new JButton(Translation.get("gb.edit"));
        edit.setEnabled(false);
        edit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                RegistrationsDialog.this.edit();
            }
        });
        final JButton delete = new JButton(Translation.get("gb.delete"));
        delete.setEnabled(false);
        delete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                RegistrationsDialog.this.delete();
            }
        });
        this.registrationsTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                boolean singleSelection = RegistrationsDialog.this.registrationsTable.getSelectedRowCount() == 1;
                boolean selected = RegistrationsDialog.this.registrationsTable.getSelectedRow() > -1;
                login.setEnabled(singleSelection);
                edit.setEnabled(singleSelection);
                delete.setEnabled(selected);
            }
        });
        JPanel controls = new JPanel(new FlowLayout(1, 5, 0));
        controls.add(create);
        controls.add(login);
        controls.add(edit);
        controls.add(delete);
        final Insets insets = new Insets(5, 5, 5, 5);
        JPanel centerPanel = new JPanel(new BorderLayout(5, 5)){
            private static final long serialVersionUID = 1L;

            @Override
            public Insets getInsets() {
                return insets;
            }
        };
        centerPanel.add((Component)new HeaderPanel(Translation.get("gb.servers"), null), "North");
        centerPanel.add((Component)new JScrollPane(this.registrationsTable), "Center");
        centerPanel.add((Component)controls, "South");
        this.getContentPane().setLayout(new BorderLayout(5, 5));
        this.getContentPane().add((Component)centerPanel, "Center");
    }

    private void login() {
        int viewRow = this.registrationsTable.getSelectedRow();
        int modelRow = this.registrationsTable.convertRowIndexToModel(viewRow);
        GitblitRegistration reg = this.registrations.get(modelRow);
        this.setVisible(false);
        this.listener.login(reg);
    }

    private void create() {
        EditRegistrationDialog dialog = new EditRegistrationDialog(this.getOwner());
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
        GitblitRegistration reg = dialog.getRegistration();
        if (reg == null) {
            return;
        }
        if (this.listener.saveRegistration(reg.name, reg)) {
            this.model.list.add(reg);
            this.model.fireTableDataChanged();
        }
    }

    private void edit() {
        int viewRow = this.registrationsTable.getSelectedRow();
        int modelRow = this.registrationsTable.convertRowIndexToModel(viewRow);
        GitblitRegistration reg = this.registrations.get(modelRow);
        String originalName = reg.name;
        EditRegistrationDialog dialog = new EditRegistrationDialog(this.getOwner(), reg, false);
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
        reg = dialog.getRegistration();
        if (reg == null) {
            return;
        }
        if (this.listener.saveRegistration(originalName, reg)) {
            this.model.fireTableDataChanged();
        }
    }

    private void delete() {
        ArrayList<GitblitRegistration> list = new ArrayList<GitblitRegistration>();
        for (int i : this.registrationsTable.getSelectedRows()) {
            int model = this.registrationsTable.convertRowIndexToModel(i);
            GitblitRegistration reg = this.registrations.get(model);
            list.add(reg);
        }
        if (this.listener.deleteRegistrations(list)) {
            this.registrations.removeAll(list);
            this.model.fireTableDataChanged();
        }
    }

    static interface RegistrationListener {
        public void login(GitblitRegistration var1);

        public boolean saveRegistration(String var1, GitblitRegistration var2);

        public boolean deleteRegistrations(List<GitblitRegistration> var1);
    }
}

