/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.client;

import com.gitblit.Constants;
import com.gitblit.client.EditRepositoryDialog;
import com.gitblit.client.GitblitClient;
import com.gitblit.client.GitblitWorker;
import com.gitblit.client.HeaderPanel;
import com.gitblit.client.IndicatorsRenderer;
import com.gitblit.client.RepositoriesTableModel;
import com.gitblit.client.SearchDialog;
import com.gitblit.client.SubscribedRepositoryRenderer;
import com.gitblit.client.Translation;
import com.gitblit.client.Utils;
import com.gitblit.models.FeedModel;
import com.gitblit.models.RegistrantAccessPermission;
import com.gitblit.models.RepositoryModel;
import com.gitblit.utils.StringUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.RowFilter;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableRowSorter;

public abstract class RepositoriesPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private final GitblitClient gitblit;
    private HeaderPanel header;
    private JTable table;
    private RepositoriesTableModel tableModel;
    private TableRowSorter<RepositoriesTableModel> defaultSorter;
    private JButton createRepository;
    private JButton editRepository;
    private JButton delRepository;
    private JTextField filterTextfield;
    private JButton clearCache;

    public RepositoriesPanel(GitblitClient gitblit) {
        this.gitblit = gitblit;
        this.initialize();
    }

    private void initialize() {
        final JButton browseRepository = new JButton(Translation.get("gb.browse"));
        browseRepository.setEnabled(false);
        browseRepository.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RepositoryModel model = (RepositoryModel)RepositoriesPanel.this.getSelectedRepositories().get(0);
                String url = RepositoriesPanel.this.gitblit.getURL("summary", model.name, null);
                Utils.browse(url);
            }
        });
        JButton refreshRepositories = new JButton(Translation.get("gb.refresh"));
        refreshRepositories.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RepositoriesPanel.this.refreshRepositories();
            }
        });
        this.clearCache = new JButton(Translation.get("gb.clearCache"));
        this.clearCache.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RepositoriesPanel.this.clearCache();
            }
        });
        this.createRepository = new JButton(Translation.get("gb.create"));
        this.createRepository.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RepositoriesPanel.this.createRepository();
            }
        });
        this.editRepository = new JButton(Translation.get("gb.edit"));
        this.editRepository.setEnabled(false);
        this.editRepository.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RepositoriesPanel.this.editRepository((RepositoryModel)RepositoriesPanel.this.getSelectedRepositories().get(0));
            }
        });
        this.delRepository = new JButton(Translation.get("gb.delete"));
        this.delRepository.setEnabled(false);
        this.delRepository.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RepositoriesPanel.this.deleteRepositories(RepositoriesPanel.this.getSelectedRepositories());
            }
        });
        final JButton subscribeRepository = new JButton(Translation.get("gb.subscribe") + "...");
        subscribeRepository.setEnabled(false);
        subscribeRepository.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List<FeedModel> feeds = RepositoriesPanel.this.gitblit.getAvailableFeeds((RepositoryModel)RepositoriesPanel.this.getSelectedRepositories().get(0));
                RepositoriesPanel.this.subscribeFeeds(feeds);
            }
        });
        final JButton logRepository = new JButton(Translation.get("gb.log") + "...");
        logRepository.setEnabled(false);
        logRepository.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RepositoryModel model = (RepositoryModel)RepositoriesPanel.this.getSelectedRepositories().get(0);
                RepositoriesPanel.this.showSearchDialog(false, model);
            }
        });
        final JButton searchRepository = new JButton(Translation.get("gb.search") + "...");
        searchRepository.setEnabled(false);
        searchRepository.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RepositoryModel model = (RepositoryModel)RepositoriesPanel.this.getSelectedRepositories().get(0);
                RepositoriesPanel.this.showSearchDialog(true, model);
            }
        });
        SubscribedRepositoryRenderer nameRenderer = new SubscribedRepositoryRenderer(this.gitblit);
        IndicatorsRenderer typeRenderer = new IndicatorsRenderer();
        DefaultTableCellRenderer sizeRenderer = new DefaultTableCellRenderer();
        sizeRenderer.setHorizontalAlignment(4);
        sizeRenderer.setForeground(new Color(0, 128, 0));
        DefaultTableCellRenderer ownerRenderer = new DefaultTableCellRenderer();
        ownerRenderer.setForeground(Color.gray);
        ownerRenderer.setHorizontalAlignment(0);
        this.tableModel = new RepositoriesTableModel();
        this.defaultSorter = new TableRowSorter<RepositoriesTableModel>(this.tableModel);
        this.table = Utils.newTable(this.tableModel, "yyyy-MM-dd");
        this.table.setRowSorter(this.defaultSorter);
        this.table.getRowSorter().toggleSortOrder(RepositoriesTableModel.Columns.Name.ordinal());
        this.setRepositoryRenderer(RepositoriesTableModel.Columns.Name, nameRenderer, -1);
        this.setRepositoryRenderer(RepositoriesTableModel.Columns.Indicators, typeRenderer, 100);
        this.setRepositoryRenderer(RepositoriesTableModel.Columns.Owner, ownerRenderer, -1);
        this.setRepositoryRenderer(RepositoriesTableModel.Columns.Size, sizeRenderer, 60);
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                boolean selected;
                if (e.getValueIsAdjusting()) {
                    return;
                }
                boolean singleSelection = RepositoriesPanel.this.table.getSelectedRowCount() == 1;
                boolean bl = selected = RepositoriesPanel.this.table.getSelectedRow() > -1;
                if (singleSelection) {
                    RepositoryModel repository = (RepositoryModel)RepositoriesPanel.this.getSelectedRepositories().get(0);
                    browseRepository.setEnabled(repository.hasCommits);
                    logRepository.setEnabled(repository.hasCommits);
                    searchRepository.setEnabled(repository.hasCommits);
                    subscribeRepository.setEnabled(repository.hasCommits);
                } else {
                    browseRepository.setEnabled(false);
                    logRepository.setEnabled(false);
                    searchRepository.setEnabled(false);
                    subscribeRepository.setEnabled(false);
                }
                RepositoriesPanel.this.delRepository.setEnabled(selected);
                if (selected) {
                    int viewRow = RepositoriesPanel.this.table.getSelectedRow();
                    int modelRow = RepositoriesPanel.this.table.convertRowIndexToModel(viewRow);
                    RepositoryModel model = ((RepositoriesTableModel)((RepositoriesPanel)RepositoriesPanel.this).table.getModel()).list.get(modelRow);
                    RepositoriesPanel.this.editRepository.setEnabled(singleSelection && (RepositoriesPanel.this.gitblit.allowManagement() || RepositoriesPanel.this.gitblit.isOwner(model)));
                } else {
                    RepositoriesPanel.this.editRepository.setEnabled(false);
                }
            }
        });
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && RepositoriesPanel.this.gitblit.allowManagement()) {
                    RepositoriesPanel.this.editRepository((RepositoryModel)RepositoriesPanel.this.getSelectedRepositories().get(0));
                }
            }
        });
        this.filterTextfield = new JTextField();
        this.filterTextfield.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RepositoriesPanel.this.filterRepositories(RepositoriesPanel.this.filterTextfield.getText());
            }
        });
        this.filterTextfield.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                RepositoriesPanel.this.filterRepositories(RepositoriesPanel.this.filterTextfield.getText());
            }
        });
        JPanel repositoryFilterPanel = new JPanel(new BorderLayout(5, 5));
        repositoryFilterPanel.add((Component)new JLabel(Translation.get("gb.filter")), "West");
        repositoryFilterPanel.add((Component)this.filterTextfield, "Center");
        JPanel repositoryTablePanel = new JPanel(new BorderLayout(5, 5));
        repositoryTablePanel.add((Component)repositoryFilterPanel, "North");
        repositoryTablePanel.add((Component)new JScrollPane(this.table), "Center");
        JPanel repositoryControls = new JPanel(new FlowLayout(1, 5, 0));
        repositoryControls.add(this.clearCache);
        repositoryControls.add(refreshRepositories);
        repositoryControls.add(browseRepository);
        repositoryControls.add(this.createRepository);
        repositoryControls.add(this.editRepository);
        repositoryControls.add(this.delRepository);
        repositoryControls.add(subscribeRepository);
        repositoryControls.add(logRepository);
        repositoryControls.add(searchRepository);
        this.setLayout(new BorderLayout(5, 5));
        this.header = new HeaderPanel(Translation.get("gb.repositories"), "git-orange-16x16.png");
        this.add((Component)this.header, "North");
        this.add((Component)repositoryTablePanel, "Center");
        this.add((Component)repositoryControls, "South");
    }

    @Override
    public void requestFocus() {
        this.filterTextfield.requestFocus();
    }

    @Override
    public Insets getInsets() {
        return Utils.INSETS;
    }

    private void setRepositoryRenderer(RepositoriesTableModel.Columns col, TableCellRenderer renderer, int maxWidth) {
        String name = this.table.getColumnName(col.ordinal());
        this.table.getColumn(name).setCellRenderer(renderer);
        if (maxWidth > 0) {
            this.table.getColumn(name).setMinWidth(maxWidth);
            this.table.getColumn(name).setMaxWidth(maxWidth);
        }
    }

    protected abstract void subscribeFeeds(List<FeedModel> var1);

    protected abstract void updateUsersTable();

    protected abstract void updateTeamsTable();

    protected void disableManagement() {
        this.clearCache.setVisible(false);
        this.createRepository.setVisible(false);
        this.editRepository.setVisible(false);
        this.delRepository.setVisible(false);
    }

    protected void updateTable(boolean pack) {
        this.tableModel.list.clear();
        this.tableModel.list.addAll(this.gitblit.getRepositories());
        this.tableModel.fireTableDataChanged();
        this.header.setText(Translation.get("gb.repositories") + " (" + this.gitblit.getRepositories().size() + ")");
        if (pack) {
            Utils.packColumns(this.table, 5);
        }
    }

    private void filterRepositories(final String fragment) {
        if (StringUtils.isEmpty(fragment)) {
            this.table.setRowSorter(this.defaultSorter);
            return;
        }
        RowFilter<RepositoriesTableModel, Object> containsFilter = new RowFilter<RepositoriesTableModel, Object>(){

            @Override
            public boolean include(RowFilter.Entry<? extends RepositoriesTableModel, ? extends Object> entry) {
                for (int i = entry.getValueCount() - 1; i >= 0; --i) {
                    if (!entry.getStringValue(i).toLowerCase().contains(fragment.toLowerCase())) continue;
                    return true;
                }
                return false;
            }
        };
        TableRowSorter<RepositoriesTableModel> sorter = new TableRowSorter<RepositoriesTableModel>(this.tableModel);
        sorter.setRowFilter(containsFilter);
        this.table.setRowSorter(sorter);
    }

    private List<RepositoryModel> getSelectedRepositories() {
        ArrayList<RepositoryModel> repositories = new ArrayList<RepositoryModel>();
        for (int viewRow : this.table.getSelectedRows()) {
            int modelRow = this.table.convertRowIndexToModel(viewRow);
            RepositoryModel model = this.tableModel.list.get(modelRow);
            repositories.add(model);
        }
        return repositories;
    }

    protected void refreshRepositories() {
        GitblitWorker worker = new GitblitWorker(this, Constants.RpcRequest.LIST_REPOSITORIES){

            @Override
            protected Boolean doRequest() throws IOException {
                RepositoriesPanel.this.gitblit.refreshRepositories();
                return true;
            }

            @Override
            protected void onSuccess() {
                RepositoriesPanel.this.updateTable(false);
            }
        };
        worker.execute();
    }

    protected void clearCache() {
        GitblitWorker worker = new GitblitWorker(this, Constants.RpcRequest.CLEAR_REPOSITORY_CACHE){

            @Override
            protected Boolean doRequest() throws IOException {
                if (RepositoriesPanel.this.gitblit.clearRepositoryCache()) {
                    RepositoriesPanel.this.gitblit.refreshRepositories();
                    return true;
                }
                return false;
            }

            @Override
            protected void onSuccess() {
                RepositoriesPanel.this.updateTable(false);
            }
        };
        worker.execute();
    }

    protected void createRepository() {
        EditRepositoryDialog dialog = new EditRepositoryDialog(this.gitblit.getProtocolVersion());
        dialog.setLocationRelativeTo(this);
        dialog.setAccessRestriction(this.gitblit.getDefaultAccessRestriction());
        dialog.setAuthorizationControl(this.gitblit.getDefaultAuthorizationControl());
        dialog.setUsers(null, this.gitblit.getUsernames(), null);
        dialog.setTeams(this.gitblit.getTeamnames(), null);
        dialog.setRepositories(this.gitblit.getRepositories());
        dialog.setFederationSets(this.gitblit.getFederationSets(), null);
        dialog.setIndexedBranches(new ArrayList<String>(Arrays.asList("default")), null);
        dialog.setPreReceiveScripts(this.gitblit.getPreReceiveScriptsUnused(null), this.gitblit.getPreReceiveScriptsInherited(null), null);
        dialog.setPostReceiveScripts(this.gitblit.getPostReceiveScriptsUnused(null), this.gitblit.getPostReceiveScriptsInherited(null), null);
        dialog.setVisible(true);
        final RepositoryModel newRepository = dialog.getRepository();
        final List<RegistrantAccessPermission> permittedUsers = dialog.getUserAccessPermissions();
        final List<RegistrantAccessPermission> permittedTeams = dialog.getTeamAccessPermissions();
        if (newRepository == null) {
            return;
        }
        GitblitWorker worker = new GitblitWorker(this, Constants.RpcRequest.CREATE_REPOSITORY){

            @Override
            protected Boolean doRequest() throws IOException {
                boolean success = RepositoriesPanel.this.gitblit.createRepository(newRepository, permittedUsers, permittedTeams);
                if (success) {
                    RepositoriesPanel.this.gitblit.refreshRepositories();
                    if (permittedUsers.size() > 0) {
                        RepositoriesPanel.this.gitblit.refreshUsers();
                    }
                    if (permittedTeams.size() > 0) {
                        RepositoriesPanel.this.gitblit.refreshTeams();
                    }
                }
                return success;
            }

            @Override
            protected void onSuccess() {
                RepositoriesPanel.this.updateTable(false);
                RepositoriesPanel.this.updateUsersTable();
                RepositoriesPanel.this.updateTeamsTable();
            }

            @Override
            protected void onFailure() {
                this.showFailure("Failed to execute request \"{0}\" for repository \"{1}\".", new Object[]{this.getRequestType(), newRepository.name});
            }
        };
        worker.execute();
    }

    protected void editRepository(final RepositoryModel repository) {
        EditRepositoryDialog dialog = new EditRepositoryDialog(this.gitblit.getProtocolVersion(), repository);
        dialog.setLocationRelativeTo(this);
        List<String> usernames = this.gitblit.getUsernames();
        List<RegistrantAccessPermission> members = this.gitblit.getUserAccessPermissions(repository);
        dialog.setUsers(new ArrayList<String>(repository.owners), usernames, members);
        dialog.setTeams(this.gitblit.getTeamnames(), this.gitblit.getTeamAccessPermissions(repository));
        dialog.setRepositories(this.gitblit.getRepositories());
        dialog.setFederationSets(this.gitblit.getFederationSets(), repository.federationSets);
        ArrayList<String> allLocalBranches = new ArrayList<String>();
        allLocalBranches.add("default");
        allLocalBranches.addAll(repository.getLocalBranches());
        dialog.setIndexedBranches(allLocalBranches, repository.indexedBranches);
        dialog.setPreReceiveScripts(this.gitblit.getPreReceiveScriptsUnused(repository), this.gitblit.getPreReceiveScriptsInherited(repository), repository.preReceiveScripts);
        dialog.setPostReceiveScripts(this.gitblit.getPostReceiveScriptsUnused(repository), this.gitblit.getPostReceiveScriptsInherited(repository), repository.postReceiveScripts);
        if (this.gitblit.getSettings().hasKey("groovy.customFields")) {
            Map<String, String> map = this.gitblit.getSettings().get("groovy.customFields").getMap();
            dialog.setCustomFields(repository, map);
        }
        dialog.setVisible(true);
        final RepositoryModel revisedRepository = dialog.getRepository();
        final List<RegistrantAccessPermission> permittedUsers = dialog.getUserAccessPermissions();
        final List<RegistrantAccessPermission> permittedTeams = dialog.getTeamAccessPermissions();
        if (revisedRepository == null) {
            return;
        }
        GitblitWorker worker = new GitblitWorker(this, Constants.RpcRequest.EDIT_REPOSITORY){

            @Override
            protected Boolean doRequest() throws IOException {
                boolean success = RepositoriesPanel.this.gitblit.updateRepository(repository.name, revisedRepository, permittedUsers, permittedTeams);
                if (success) {
                    RepositoriesPanel.this.gitblit.refreshRepositories();
                    RepositoriesPanel.this.gitblit.refreshUsers();
                    RepositoriesPanel.this.gitblit.refreshTeams();
                }
                return success;
            }

            @Override
            protected void onSuccess() {
                RepositoriesPanel.this.updateTable(false);
                RepositoriesPanel.this.updateUsersTable();
                RepositoriesPanel.this.updateTeamsTable();
            }

            @Override
            protected void onFailure() {
                this.showFailure("Failed to execute request \"{0}\" for repository \"{1}\".", new Object[]{this.getRequestType(), repository.name});
            }
        };
        worker.execute();
    }

    protected void deleteRepositories(final List<RepositoryModel> repositories) {
        if (repositories == null || repositories.size() == 0) {
            return;
        }
        StringBuilder message = new StringBuilder("Delete the following repositories?\n\n");
        for (RepositoryModel repository : repositories) {
            message.append(repository.name).append("\n");
        }
        int result = JOptionPane.showConfirmDialog(this, message.toString(), "Delete Repositories?", 0);
        if (result == 0) {
            GitblitWorker worker = new GitblitWorker(this, Constants.RpcRequest.DELETE_REPOSITORY){

                @Override
                protected Boolean doRequest() throws IOException {
                    boolean success = true;
                    for (RepositoryModel repository : repositories) {
                        success &= RepositoriesPanel.this.gitblit.deleteRepository(repository);
                    }
                    if (success) {
                        RepositoriesPanel.this.gitblit.refreshRepositories();
                        RepositoriesPanel.this.gitblit.refreshUsers();
                        RepositoriesPanel.this.gitblit.refreshTeams();
                    }
                    return success;
                }

                @Override
                protected void onSuccess() {
                    RepositoriesPanel.this.updateTable(false);
                    RepositoriesPanel.this.updateUsersTable();
                    RepositoriesPanel.this.updateTeamsTable();
                }

                @Override
                protected void onFailure() {
                    this.showFailure("Failed to delete specified repositories!", new Object[0]);
                }
            };
            worker.execute();
        }
    }

    private void showSearchDialog(boolean isSearch, RepositoryModel repository) {
        SearchDialog dialog = new SearchDialog(this.gitblit, isSearch);
        if (repository != null) {
            dialog.selectRepository(repository);
        }
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
    }
}

