/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.client;

import com.gitblit.client.Translation;
import com.gitblit.models.RepositoryModel;
import com.gitblit.utils.ArrayUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public class RepositoriesTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    List<RepositoryModel> list;

    public RepositoriesTableModel() {
        this(new ArrayList<RepositoryModel>());
    }

    public RepositoriesTableModel(List<RepositoryModel> repositories) {
        this.list = repositories;
        Collections.sort(this.list);
    }

    @Override
    public int getRowCount() {
        return this.list.size();
    }

    @Override
    public int getColumnCount() {
        return Columns.values().length;
    }

    @Override
    public String getColumnName(int column) {
        Columns col = Columns.values()[column];
        switch (col) {
            case Name: {
                return Translation.get("gb.name");
            }
            case Description: {
                return Translation.get("gb.description");
            }
            case Owner: {
                return Translation.get("gb.owner");
            }
            case Last_Change: {
                return Translation.get("gb.lastChange");
            }
            case Size: {
                return Translation.get("gb.size");
            }
        }
        return "";
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        Columns col = Columns.values()[columnIndex];
        switch (col) {
            case Name: 
            case Indicators: {
                return RepositoryModel.class;
            }
            case Last_Change: {
                return Date.class;
            }
        }
        return String.class;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        RepositoryModel model = this.list.get(rowIndex);
        Columns col = Columns.values()[columnIndex];
        switch (col) {
            case Name: {
                return model;
            }
            case Description: {
                return model.description;
            }
            case Owner: {
                return ArrayUtils.toString(model.owners);
            }
            case Indicators: {
                return model;
            }
            case Last_Change: {
                return model.lastChange;
            }
            case Size: {
                if (model.hasCommits) {
                    return model.size;
                }
                return "(empty)";
            }
        }
        return null;
    }

    static enum Columns {
        Name,
        Description,
        Owner,
        Indicators,
        Last_Change,
        Size;


        public String toString() {
            return this.name().replace('_', ' ');
        }
    }
}

