/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.client;

import com.gitblit.client.Translation;
import com.gitblit.models.SettingModel;
import com.gitblit.utils.StringUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import java.util.ArrayList;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class SettingPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JTextArea descriptionArea;
    private JLabel settingName;
    private JLabel settingDefault;
    private JLabel sinceVersion;
    private JLabel directives;

    public SettingPanel() {
        this.initialize();
    }

    public SettingPanel(SettingModel setting) {
        this();
        this.setSetting(setting);
    }

    private void initialize() {
        this.descriptionArea = new JTextArea();
        this.descriptionArea.setRows(6);
        this.descriptionArea.setFont(new Font("monospaced", 0, 11));
        this.descriptionArea.setEditable(false);
        this.settingName = new JLabel(" ");
        this.settingName.setFont(this.settingName.getFont().deriveFont(1));
        this.settingDefault = new JLabel(" ");
        this.sinceVersion = new JLabel(" ", 4);
        this.sinceVersion.setForeground(new Color(0, 128, 0));
        this.directives = new JLabel(" ", 4);
        this.directives.setFont(this.directives.getFont().deriveFont(2));
        JPanel settingParameters = new JPanel(new GridLayout(2, 2, 0, 0));
        settingParameters.add(this.settingName);
        settingParameters.add(this.sinceVersion);
        settingParameters.add((Component)this.settingDefault, "Center");
        settingParameters.add(this.directives);
        JPanel settingPanel = new JPanel(new BorderLayout(5, 5));
        settingPanel.add((Component)settingParameters, "North");
        settingPanel.add((Component)new JScrollPane(this.descriptionArea), "Center");
        this.setLayout(new BorderLayout(0, 0));
        this.add((Component)settingPanel, "Center");
    }

    public void setSetting(SettingModel setting) {
        this.settingName.setText(setting.name);
        if (setting.since == null) {
            this.sinceVersion.setText("custom");
        } else {
            this.sinceVersion.setText("since " + setting.since);
        }
        this.settingDefault.setText(Translation.get("gb.default") + ": " + setting.defaultValue);
        ArrayList<String> values = new ArrayList<String>();
        if (setting.caseSensitive) {
            values.add("CASE-SENSITIVE");
        }
        if (setting.spaceDelimited) {
            values.add("SPACE-DELIMITED");
        }
        if (setting.restartRequired) {
            values.add("RESTART REQUIRED");
        }
        this.directives.setText(StringUtils.flattenStrings(values, ", "));
        this.descriptionArea.setText(setting.description);
        this.descriptionArea.setCaretPosition(0);
    }

    public void clear() {
        this.settingName.setText(" ");
        this.settingDefault.setText(" ");
        this.sinceVersion.setText(" ");
        this.directives.setText(" ");
        this.descriptionArea.setText("");
    }
}

