/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.client;

import com.gitblit.client.BooleanCellRenderer;
import com.gitblit.client.BranchRenderer;
import com.gitblit.client.FeedsTableModel;
import com.gitblit.client.HeaderPanel;
import com.gitblit.client.NameRenderer;
import com.gitblit.client.Translation;
import com.gitblit.client.Utils;
import com.gitblit.models.FeedModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public abstract class SubscriptionsDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private final List<FeedModel> feeds;
    private JTable feedsTable;
    private FeedsTableModel model;

    public SubscriptionsDialog(List<FeedModel> registrations) {
        this.feeds = registrations;
        this.setTitle(Translation.get("gb.subscribe"));
        this.setIconImage(new ImageIcon(this.getClass().getResource("/gitblt-favicon.png")).getImage());
        this.initialize();
        this.setSize(600, 400);
    }

    @Override
    protected JRootPane createRootPane() {
        KeyStroke stroke = KeyStroke.getKeyStroke(27, 0);
        JRootPane rootPane = new JRootPane();
        rootPane.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SubscriptionsDialog.this.setVisible(false);
            }
        }, stroke, 2);
        return rootPane;
    }

    private void initialize() {
        NameRenderer nameRenderer = new NameRenderer();
        this.model = new FeedsTableModel(this.feeds);
        this.feedsTable = Utils.newTable(this.model, "yyyy-MM-dd");
        this.feedsTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                int viewRow = SubscriptionsDialog.this.feedsTable.getSelectedRow();
                if (viewRow == -1) {
                    return;
                }
                int modelRow = SubscriptionsDialog.this.feedsTable.convertRowIndexToModel(viewRow);
                FeedModel feed = SubscriptionsDialog.this.model.get(modelRow);
                feed.subscribed = !feed.subscribed;
                SubscriptionsDialog.this.model.fireTableDataChanged();
            }
        });
        String repository = this.feedsTable.getColumnName(FeedsTableModel.Columns.Repository.ordinal());
        this.feedsTable.getColumn(repository).setCellRenderer(nameRenderer);
        String branch = this.feedsTable.getColumnName(FeedsTableModel.Columns.Branch.ordinal());
        this.feedsTable.getColumn(branch).setCellRenderer(new BranchRenderer());
        String subscribed = this.feedsTable.getColumnName(FeedsTableModel.Columns.Subscribed.ordinal());
        this.feedsTable.getColumn(subscribed).setCellRenderer(new BooleanCellRenderer());
        this.feedsTable.getColumn(subscribed).setMinWidth(30);
        this.feedsTable.getColumn(subscribed).setMaxWidth(30);
        Utils.packColumns(this.feedsTable, 5);
        JButton cancel = new JButton(Translation.get("gb.cancel"));
        cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                SubscriptionsDialog.this.setVisible(false);
            }
        });
        JButton save = new JButton(Translation.get("gb.save"));
        save.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                SubscriptionsDialog.this.save();
            }
        });
        this.feedsTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
            }
        });
        JPanel controls = new JPanel(new FlowLayout(1, 5, 0));
        controls.add(cancel);
        controls.add(save);
        final Insets insets = new Insets(5, 5, 5, 5);
        JPanel centerPanel = new JPanel(new BorderLayout(5, 5)){
            private static final long serialVersionUID = 1L;

            @Override
            public Insets getInsets() {
                return insets;
            }
        };
        centerPanel.add((Component)new HeaderPanel(Translation.get("gb.subscribe") + "...", "feed_16x16.png"), "North");
        centerPanel.add((Component)new JScrollPane(this.feedsTable), "Center");
        centerPanel.add((Component)controls, "South");
        this.getContentPane().setLayout(new BorderLayout(5, 5));
        this.getContentPane().add((Component)centerPanel, "Center");
    }

    public abstract void save();
}

