/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.client;

import com.gitblit.Constants;
import com.gitblit.client.EditTeamDialog;
import com.gitblit.client.GitblitClient;
import com.gitblit.client.GitblitWorker;
import com.gitblit.client.HeaderPanel;
import com.gitblit.client.NameRenderer;
import com.gitblit.client.TeamsTableModel;
import com.gitblit.client.Translation;
import com.gitblit.client.Utils;
import com.gitblit.models.TeamModel;
import com.gitblit.utils.StringUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.RowFilter;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableRowSorter;

public abstract class TeamsPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private final GitblitClient gitblit;
    private HeaderPanel header;
    private JTable table;
    private TeamsTableModel tableModel;
    private TableRowSorter<TeamsTableModel> defaultSorter;
    private JTextField filterTextfield;

    public TeamsPanel(GitblitClient gitblit) {
        this.gitblit = gitblit;
        this.initialize();
    }

    private void initialize() {
        JButton refreshTeams = new JButton(Translation.get("gb.refresh"));
        refreshTeams.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TeamsPanel.this.refreshTeams();
            }
        });
        JButton createTeam = new JButton(Translation.get("gb.create"));
        createTeam.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TeamsPanel.this.createTeam();
            }
        });
        final JButton editTeam = new JButton(Translation.get("gb.edit"));
        editTeam.setEnabled(false);
        editTeam.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TeamsPanel.this.editTeam((TeamModel)TeamsPanel.this.getSelectedTeams().get(0));
            }
        });
        final JButton delTeam = new JButton(Translation.get("gb.delete"));
        delTeam.setEnabled(false);
        delTeam.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TeamsPanel.this.deleteTeams(TeamsPanel.this.getSelectedTeams());
            }
        });
        NameRenderer nameRenderer = new NameRenderer();
        this.tableModel = new TeamsTableModel();
        this.defaultSorter = new TableRowSorter<TeamsTableModel>(this.tableModel);
        this.table = Utils.newTable(this.tableModel, "yyyy-MM-dd");
        String name = this.table.getColumnName(TeamsTableModel.Columns.Name.ordinal());
        this.table.getColumn(name).setCellRenderer(nameRenderer);
        int w = 125;
        name = this.table.getColumnName(TeamsTableModel.Columns.Members.ordinal());
        this.table.getColumn(name).setMinWidth(w);
        this.table.getColumn(name).setMaxWidth(w);
        name = this.table.getColumnName(TeamsTableModel.Columns.Repositories.ordinal());
        this.table.getColumn(name).setMinWidth(w);
        this.table.getColumn(name).setMaxWidth(w);
        this.table.setRowSorter(this.defaultSorter);
        this.table.getRowSorter().toggleSortOrder(TeamsTableModel.Columns.Name.ordinal());
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                boolean selected = TeamsPanel.this.table.getSelectedRow() > -1;
                boolean singleSelection = TeamsPanel.this.table.getSelectedRows().length == 1;
                editTeam.setEnabled(singleSelection && selected);
                delTeam.setEnabled(selected);
            }
        });
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    TeamsPanel.this.editTeam((TeamModel)TeamsPanel.this.getSelectedTeams().get(0));
                }
            }
        });
        this.filterTextfield = new JTextField();
        this.filterTextfield.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TeamsPanel.this.filterTeams(TeamsPanel.this.filterTextfield.getText());
            }
        });
        this.filterTextfield.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                TeamsPanel.this.filterTeams(TeamsPanel.this.filterTextfield.getText());
            }
        });
        JPanel teamFilterPanel = new JPanel(new BorderLayout(5, 5));
        teamFilterPanel.add((Component)new JLabel(Translation.get("gb.filter")), "West");
        teamFilterPanel.add((Component)this.filterTextfield, "Center");
        JPanel teamTablePanel = new JPanel(new BorderLayout(5, 5));
        teamTablePanel.add((Component)teamFilterPanel, "North");
        teamTablePanel.add((Component)new JScrollPane(this.table), "Center");
        JPanel teamControls = new JPanel(new FlowLayout(1, 5, 0));
        teamControls.add(refreshTeams);
        teamControls.add(createTeam);
        teamControls.add(editTeam);
        teamControls.add(delTeam);
        this.setLayout(new BorderLayout(5, 5));
        this.header = new HeaderPanel(Translation.get("gb.teams"), "users_16x16.png");
        this.add((Component)this.header, "North");
        this.add((Component)teamTablePanel, "Center");
        this.add((Component)teamControls, "South");
    }

    @Override
    public void requestFocus() {
        this.filterTextfield.requestFocus();
    }

    @Override
    public Insets getInsets() {
        return Utils.INSETS;
    }

    protected abstract void updateUsersTable();

    protected void updateTable(boolean pack) {
        this.tableModel.list.clear();
        this.tableModel.list.addAll(this.gitblit.getTeams());
        this.tableModel.fireTableDataChanged();
        this.header.setText(Translation.get("gb.teams") + " (" + this.gitblit.getTeams().size() + ")");
        if (pack) {
            Utils.packColumns(this.table, 5);
        }
    }

    private void filterTeams(final String fragment) {
        if (StringUtils.isEmpty(fragment)) {
            this.table.setRowSorter(this.defaultSorter);
            return;
        }
        RowFilter<TeamsTableModel, Object> containsFilter = new RowFilter<TeamsTableModel, Object>(){

            @Override
            public boolean include(RowFilter.Entry<? extends TeamsTableModel, ? extends Object> entry) {
                for (int i = entry.getValueCount() - 1; i >= 0; --i) {
                    if (!entry.getStringValue(i).toLowerCase().contains(fragment.toLowerCase())) continue;
                    return true;
                }
                return false;
            }
        };
        TableRowSorter<TeamsTableModel> sorter = new TableRowSorter<TeamsTableModel>(this.tableModel);
        sorter.setRowFilter(containsFilter);
        this.table.setRowSorter(sorter);
    }

    private List<TeamModel> getSelectedTeams() {
        ArrayList<TeamModel> teams = new ArrayList<TeamModel>();
        for (int viewRow : this.table.getSelectedRows()) {
            int modelRow = this.table.convertRowIndexToModel(viewRow);
            TeamModel model = this.tableModel.list.get(modelRow);
            teams.add(model);
        }
        return teams;
    }

    protected void refreshTeams() {
        GitblitWorker worker = new GitblitWorker(this, Constants.RpcRequest.LIST_TEAMS){

            @Override
            protected Boolean doRequest() throws IOException {
                TeamsPanel.this.gitblit.refreshTeams();
                return true;
            }

            @Override
            protected void onSuccess() {
                TeamsPanel.this.updateTable(false);
            }
        };
        worker.execute();
    }

    protected void createTeam() {
        EditTeamDialog dialog = new EditTeamDialog(this.gitblit.getProtocolVersion(), this.gitblit.getSettings());
        dialog.setLocationRelativeTo(this);
        dialog.setTeams(this.gitblit.getTeams());
        dialog.setRepositories(this.gitblit.getRepositories(), null);
        dialog.setUsers(this.gitblit.getUsernames(), null);
        dialog.setPreReceiveScripts(this.gitblit.getPreReceiveScriptsUnused(null), this.gitblit.getPreReceiveScriptsInherited(null), null);
        dialog.setPostReceiveScripts(this.gitblit.getPostReceiveScriptsUnused(null), this.gitblit.getPostReceiveScriptsInherited(null), null);
        dialog.setVisible(true);
        final TeamModel newTeam = dialog.getTeam();
        if (newTeam == null) {
            return;
        }
        GitblitWorker worker = new GitblitWorker(this, Constants.RpcRequest.CREATE_TEAM){

            @Override
            protected Boolean doRequest() throws IOException {
                boolean success = TeamsPanel.this.gitblit.createTeam(newTeam);
                if (success) {
                    TeamsPanel.this.gitblit.refreshTeams();
                    TeamsPanel.this.gitblit.refreshUsers();
                }
                return success;
            }

            @Override
            protected void onSuccess() {
                TeamsPanel.this.updateTable(false);
                TeamsPanel.this.updateUsersTable();
            }

            @Override
            protected void onFailure() {
                this.showFailure("Failed to execute request \"{0}\" for team \"{1}\".", new Object[]{this.getRequestType(), newTeam.name});
            }
        };
        worker.execute();
    }

    protected void editTeam(final TeamModel team) {
        EditTeamDialog dialog = new EditTeamDialog(this.gitblit.getProtocolVersion(), team, this.gitblit.getSettings());
        dialog.setLocationRelativeTo(this);
        dialog.setTeams(this.gitblit.getTeams());
        dialog.setRepositories(this.gitblit.getRepositories(), team.getRepositoryPermissions());
        dialog.setUsers(this.gitblit.getUsernames(), (List<String>)(team.users == null ? null : new ArrayList<String>(team.users)));
        dialog.setPreReceiveScripts(this.gitblit.getPreReceiveScriptsUnused(null), this.gitblit.getPreReceiveScriptsInherited(null), team.preReceiveScripts);
        dialog.setPostReceiveScripts(this.gitblit.getPostReceiveScriptsUnused(null), this.gitblit.getPostReceiveScriptsInherited(null), team.postReceiveScripts);
        dialog.setVisible(true);
        final TeamModel revisedTeam = dialog.getTeam();
        if (revisedTeam == null) {
            return;
        }
        GitblitWorker worker = new GitblitWorker(this, Constants.RpcRequest.EDIT_TEAM){

            @Override
            protected Boolean doRequest() throws IOException {
                boolean success = TeamsPanel.this.gitblit.updateTeam(team.name, revisedTeam);
                if (success) {
                    TeamsPanel.this.gitblit.refreshTeams();
                    TeamsPanel.this.gitblit.refreshUsers();
                }
                return success;
            }

            @Override
            protected void onSuccess() {
                TeamsPanel.this.updateTable(false);
                TeamsPanel.this.updateUsersTable();
            }

            @Override
            protected void onFailure() {
                this.showFailure("Failed to execute request \"{0}\" for team \"{1}\".", new Object[]{this.getRequestType(), team.name});
            }
        };
        worker.execute();
    }

    protected void deleteTeams(final List<TeamModel> teams) {
        if (teams == null || teams.size() == 0) {
            return;
        }
        StringBuilder message = new StringBuilder("Delete the following teams?\n\n");
        for (TeamModel team : teams) {
            message.append(team.name).append("\n");
        }
        int result = JOptionPane.showConfirmDialog(this, message.toString(), "Delete Teams?", 0);
        if (result == 0) {
            GitblitWorker worker = new GitblitWorker(this, Constants.RpcRequest.DELETE_TEAM){

                @Override
                protected Boolean doRequest() throws IOException {
                    boolean success = true;
                    for (TeamModel team : teams) {
                        success &= TeamsPanel.this.gitblit.deleteTeam(team);
                    }
                    if (success) {
                        TeamsPanel.this.gitblit.refreshTeams();
                        TeamsPanel.this.gitblit.refreshUsers();
                    }
                    return success;
                }

                @Override
                protected void onSuccess() {
                    TeamsPanel.this.updateTable(false);
                    TeamsPanel.this.updateUsersTable();
                }

                @Override
                protected void onFailure() {
                    this.showFailure("Failed to delete specified teams!", new Object[0]);
                }
            };
            worker.execute();
        }
    }
}

