/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.client;

import com.gitblit.client.Translation;
import com.gitblit.models.TeamModel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public class TeamsTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    List<TeamModel> list;

    public TeamsTableModel() {
        this(new ArrayList<TeamModel>());
    }

    public TeamsTableModel(List<TeamModel> teams) {
        this.list = teams;
        Collections.sort(this.list);
    }

    @Override
    public int getRowCount() {
        return this.list.size();
    }

    @Override
    public int getColumnCount() {
        return Columns.values().length;
    }

    @Override
    public String getColumnName(int column) {
        Columns col = Columns.values()[column];
        switch (col) {
            case Name: {
                return Translation.get("gb.name");
            }
            case Members: {
                return Translation.get("gb.teamMembers");
            }
            case Repositories: {
                return Translation.get("gb.repositories");
            }
        }
        return "";
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return String.class;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        TeamModel model = this.list.get(rowIndex);
        Columns col = Columns.values()[columnIndex];
        switch (col) {
            case Name: {
                return model.name;
            }
            case Members: {
                return model.users.size() == 0 ? "" : String.valueOf(model.users.size());
            }
            case Repositories: {
                return model.repositories.size() == 0 ? "" : String.valueOf(model.repositories.size());
            }
        }
        return null;
    }

    static enum Columns {
        Name,
        Members,
        Repositories;


        public String toString() {
            return this.name().replace('_', ' ');
        }
    }
}

