/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.client;

import com.gitblit.client.Translation;
import com.gitblit.models.UserModel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public class UsersTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    List<UserModel> list;

    public UsersTableModel() {
        this(new ArrayList<UserModel>());
    }

    public UsersTableModel(List<UserModel> users) {
        this.list = users;
        Collections.sort(this.list);
    }

    @Override
    public int getRowCount() {
        return this.list.size();
    }

    @Override
    public int getColumnCount() {
        return Columns.values().length;
    }

    @Override
    public String getColumnName(int column) {
        Columns col = Columns.values()[column];
        switch (col) {
            case Name: {
                return Translation.get("gb.name");
            }
            case Display_Name: {
                return Translation.get("gb.displayName");
            }
            case Type: {
                return Translation.get("gb.type");
            }
            case Teams: {
                return Translation.get("gb.teamMemberships");
            }
            case Repositories: {
                return Translation.get("gb.repositories");
            }
        }
        return "";
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return String.class;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        UserModel model = this.list.get(rowIndex);
        Columns col = Columns.values()[columnIndex];
        switch (col) {
            case Name: {
                return model.username;
            }
            case Display_Name: {
                return model.displayName;
            }
            case Type: {
                StringBuilder sb = new StringBuilder();
                if (model.accountType != null) {
                    sb.append(model.accountType.name());
                }
                if (model.canAdmin()) {
                    if (sb.length() > 0) {
                        sb.append(", ");
                    }
                    sb.append("admin");
                }
                return sb.toString();
            }
            case Teams: {
                return model.teams == null || model.teams.size() == 0 ? "" : String.valueOf(model.teams.size());
            }
            case Repositories: {
                return model.permissions == null || model.permissions.size() == 0 ? "" : String.valueOf(model.permissions.size());
            }
        }
        return null;
    }

    static enum Columns {
        Name,
        Display_Name,
        Type,
        Teams,
        Repositories;


        public String toString() {
            return this.name().replace('_', ' ');
        }
    }
}

