/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.fanout;

import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Date;

public class FanoutStats
implements Serializable {
    private static final long serialVersionUID = 1L;
    public long concurrentConnectionLimit;
    public boolean allowAllChannelAnnouncements;
    public boolean strictRequestTermination;
    public Date bootDate;
    public long rejectedConnectionCount;
    public int peakConnectionCount;
    public long currentChannels;
    public long currentSubscriptions;
    public long currentConnections;
    public long totalConnections;
    public long totalAnnouncements;
    public long totalMessages;
    public long totalSubscribes;
    public long totalUnsubscribes;
    public long totalPings;

    public String info() {
        int i = 0;
        StringBuilder sb = new StringBuilder();
        sb.append(this.infoStr(i++, "boot date"));
        sb.append(this.infoStr(i++, "strict request termination"));
        sb.append(this.infoStr(i++, "allow connection \"all\" announcements"));
        sb.append(this.infoInt(i++, "concurrent connection limit"));
        sb.append(this.infoInt(i++, "concurrent limit rejected connections"));
        sb.append(this.infoInt(i++, "peak connections"));
        sb.append(this.infoInt(i++, "current connections"));
        sb.append(this.infoInt(i++, "current channels"));
        sb.append(this.infoInt(i++, "current subscriptions"));
        sb.append(this.infoInt(i++, "user-requested subscriptions"));
        sb.append(this.infoInt(i++, "total connections"));
        sb.append(this.infoInt(i++, "total announcements"));
        sb.append(this.infoInt(i++, "total messages"));
        sb.append(this.infoInt(i++, "total subscribes"));
        sb.append(this.infoInt(i++, "total unsubscribes"));
        sb.append(this.infoInt(i++, "total pings"));
        String template = sb.toString();
        String info = MessageFormat.format(template, this.bootDate.toString(), Boolean.toString(this.strictRequestTermination), Boolean.toString(this.allowAllChannelAnnouncements), this.concurrentConnectionLimit, this.rejectedConnectionCount, this.peakConnectionCount, this.currentConnections, this.currentChannels, this.currentSubscriptions, this.currentSubscriptions == 0L ? 0L : this.currentSubscriptions - this.currentConnections, this.totalConnections, this.totalAnnouncements, this.totalMessages, this.totalSubscribes, this.totalUnsubscribes, this.totalPings);
        return info;
    }

    private String infoStr(int index, String label) {
        return label + ": {" + index + "}\n";
    }

    private String infoInt(int index, String label) {
        return label + ": {" + index + ",number,0}\n";
    }
}

