/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.git;

import com.gitblit.Constants;
import com.gitblit.IStoredSettings;
import com.gitblit.client.Translation;
import com.gitblit.extensions.ReceiveHook;
import com.gitblit.git.ReceiveCommandEvent;
import com.gitblit.git.SideBandProgressMonitor;
import com.gitblit.manager.IGitblit;
import com.gitblit.models.RepositoryModel;
import com.gitblit.models.TicketModel;
import com.gitblit.models.UserModel;
import com.gitblit.tickets.ITicketService;
import com.gitblit.tickets.TicketNotifier;
import com.gitblit.utils.ArrayUtils;
import com.gitblit.utils.ClientLogger;
import com.gitblit.utils.CommitCache;
import com.gitblit.utils.JGitUtils;
import com.gitblit.utils.RefLogUtils;
import com.gitblit.utils.StringUtils;
import groovy.lang.Binding;
import groovy.util.GroovyScriptEngine;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import org.eclipse.jgit.events.RepositoryEvent;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.BatchRefUpdate;
import org.eclipse.jgit.lib.NullProgressMonitor;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.transport.PostReceiveHook;
import org.eclipse.jgit.transport.PreReceiveHook;
import org.eclipse.jgit.transport.ReceiveCommand;
import org.eclipse.jgit.transport.ReceivePack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GitblitReceivePack
extends ReceivePack
implements PreReceiveHook,
PostReceiveHook {
    private static final Logger LOGGER = LoggerFactory.getLogger(GitblitReceivePack.class);
    protected final RepositoryModel repository;
    protected final UserModel user;
    protected final File groovyDir;
    protected String gitblitUrl;
    protected GroovyScriptEngine gse;
    protected final IStoredSettings settings;
    protected final IGitblit gitblit;
    protected final ITicketService ticketService;
    protected final TicketNotifier ticketNotifier;

    public GitblitReceivePack(IGitblit gitblit, Repository db, RepositoryModel repository, UserModel user) {
        super(db);
        int maxPackSz;
        this.settings = gitblit.getSettings();
        this.gitblit = gitblit;
        this.repository = repository;
        this.user = user;
        this.groovyDir = gitblit.getHooksFolder();
        try {
            File grapeRoot = gitblit.getGrapesFolder();
            grapeRoot.mkdirs();
            System.setProperty("grape.root", grapeRoot.getAbsolutePath());
            this.gse = new GroovyScriptEngine(this.groovyDir.getAbsolutePath());
        }
        catch (IOException grapeRoot) {
            // empty catch block
        }
        if (gitblit.getTicketService().isAcceptingTicketUpdates(repository)) {
            this.ticketService = gitblit.getTicketService();
            this.ticketNotifier = this.ticketService.createNotifier();
        } else {
            this.ticketService = null;
            this.ticketNotifier = null;
        }
        this.setAllowCreates(user.canCreateRef(repository));
        this.setAllowDeletes(user.canDeleteRef(repository));
        this.setAllowNonFastForwards(user.canRewindRef(repository));
        int maxObjectSz = this.settings.getInteger("git.maxObjectSizeLimit", -1);
        if (maxObjectSz >= 0) {
            this.setMaxObjectSizeLimit(maxObjectSz);
        }
        if ((maxPackSz = this.settings.getInteger("git.maxPackSizeLimit", -1)) >= 0) {
            this.setMaxPackSizeLimit(maxPackSz);
        }
        this.setCheckReceivedObjects(this.settings.getBoolean("git.checkReceivedObjects", true));
        this.setCheckReferencedObjectsAreReachable(this.settings.getBoolean("git.checkReferencedObjectsAreReachable", true));
        this.setPreReceiveHook(this);
        this.setPostReceiveHook(this);
    }

    protected boolean canPush(Collection<ReceiveCommand> commands) {
        return commands.isEmpty() ? true : this.user.canPush(this.repository);
    }

    public void onPreReceive(ReceivePack rp, Collection<ReceiveCommand> commands) {
        if (commands.size() == 0) {
            LOGGER.debug("skipping pre-receive processing, no refs created, updated, or removed");
            return;
        }
        if (this.repository.isMirror) {
            for (ReceiveCommand receiveCommand : commands) {
                this.sendRejection(receiveCommand, "Gitblit does not allow pushes to \"{0}\" because it is a mirror!", this.repository.name);
            }
            return;
        }
        if (this.repository.isFrozen) {
            for (ReceiveCommand receiveCommand : commands) {
                this.sendRejection(receiveCommand, "Gitblit does not allow pushes to \"{0}\" because it is frozen!", this.repository.name);
            }
            return;
        }
        if (!this.repository.isBare) {
            for (ReceiveCommand receiveCommand : commands) {
                this.sendRejection(receiveCommand, "Gitblit does not allow pushes to \"{0}\" because it has a working copy!", this.repository.name);
            }
            return;
        }
        if (!this.canPush(commands)) {
            for (ReceiveCommand receiveCommand : commands) {
                this.sendRejection(receiveCommand, "User \"{0}\" does not have push permissions for \"{1}\"!", this.user.username, this.repository.name);
            }
            return;
        }
        if (this.repository.accessRestriction.atLeast(Constants.AccessRestrictionType.PUSH) && this.repository.verifyCommitter) {
            if (StringUtils.isEmpty(this.user.emailAddress)) {
                for (ReceiveCommand receiveCommand : commands) {
                    this.sendRejection(receiveCommand, "Sorry, the account \"{0}\" does not have an email address set for committer verification!", this.user.username);
                }
                return;
            }
            boolean allRejected = false;
            block12: for (ReceiveCommand cmd : commands) {
                String firstParent = null;
                try {
                    List<RevCommit> commits = JGitUtils.getRevLog(rp.getRepository(), cmd.getOldId().name(), cmd.getNewId().name());
                    for (RevCommit commit : commits) {
                        if (firstParent != null && !commit.getName().equals(firstParent)) continue;
                        firstParent = commit.getParentCount() == 0 ? null : commit.getParents()[0].getId().getName();
                        PersonIdent committer = commit.getCommitterIdent();
                        if (!this.user.is(committer.getName(), committer.getEmailAddress())) {
                            String reason = MessageFormat.format("{0} by {1} <{2}> was not committed by {3} ({4}) <{5}>", commit.getId().name(), committer.getName(), StringUtils.isEmpty(committer.getEmailAddress()) ? "?" : committer.getEmailAddress(), this.user.getDisplayName(), this.user.username, this.user.emailAddress);
                            LOGGER.warn(reason);
                            cmd.setResult(ReceiveCommand.Result.REJECTED_OTHER_REASON, reason);
                            allRejected &= true;
                            continue block12;
                        }
                        allRejected = false;
                    }
                }
                catch (Exception e) {
                    LOGGER.error("Failed to verify commits were made by pushing user", (Throwable)e);
                }
            }
            if (allRejected) {
                return;
            }
        }
        block14: for (ReceiveCommand receiveCommand : commands) {
            String ref = receiveCommand.getRefName();
            if (ref.startsWith("refs/heads/")) {
                switch (receiveCommand.getType()) {
                    case UPDATE_NONFASTFORWARD: 
                    case DELETE: {
                        CommitCache.instance().clear(this.repository.name, ref);
                        continue block14;
                    }
                }
                continue;
            }
            if (ref.equals("refs/meta/gitblit/tickets")) {
                boolean permitted = this.user.canAdmin() || this.repository.isOwner(this.user.username);
                if (permitted) continue;
                this.sendRejection(receiveCommand, "{0} is not permitted to push to {1}", this.user.username, ref);
                continue;
            }
            if (!ref.startsWith("refs/for/")) continue;
            this.sendRejection(receiveCommand, "{0} is not configured to receive patchsets", this.repository.name);
        }
        for (ReceiveHook receiveHook : this.gitblit.getExtensions(ReceiveHook.class)) {
            try {
                receiveHook.onPreReceive(this, commands);
            }
            catch (Exception e) {
                LOGGER.error("Failed to execute extension", (Throwable)e);
            }
        }
        LinkedHashSet<String> scripts = new LinkedHashSet<String>();
        scripts.addAll(this.gitblit.getPreReceiveScriptsInherited(this.repository));
        if (!ArrayUtils.isEmpty(this.repository.preReceiveScripts)) {
            scripts.addAll(this.repository.preReceiveScripts);
        }
        this.runGroovy(commands, scripts);
        for (ReceiveCommand cmd : commands) {
            if (ReceiveCommand.Result.NOT_ATTEMPTED.equals((Object)cmd.getResult())) continue;
            LOGGER.warn(MessageFormat.format("{0} {1} because \"{2}\"", cmd.getNewId().getName(), cmd.getResult(), cmd.getMessage()));
        }
    }

    public void onPostReceive(ReceivePack rp, Collection<ReceiveCommand> commands) {
        if (commands.size() == 0) {
            LOGGER.debug("skipping post-receive processing, no refs created, updated, or removed");
            return;
        }
        this.logRefChange(commands);
        this.updateIncrementalPushTags(commands);
        this.updateGitblitRefLog(commands);
        for (ReceiveCommand cmd : commands) {
            if (!ReceiveCommand.Result.OK.equals((Object)cmd.getResult()) || !"refs/meta/gitblit/tickets".equals(cmd.getRefName())) continue;
            rp.getRepository().fireEvent((RepositoryEvent)new ReceiveCommandEvent(this.repository, cmd));
        }
        for (ReceiveHook hook : this.gitblit.getExtensions(ReceiveHook.class)) {
            try {
                hook.onPostReceive(this, commands);
            }
            catch (Exception e) {
                LOGGER.error("Failed to execute extension", (Throwable)e);
            }
        }
        LinkedHashSet<String> scripts = new LinkedHashSet<String>();
        scripts.addAll(this.gitblit.getPostReceiveScriptsInherited(this.repository));
        if (!ArrayUtils.isEmpty(this.repository.postReceiveScripts)) {
            scripts.addAll(this.repository.postReceiveScripts);
        }
        this.runGroovy(commands, scripts);
    }

    protected void logRefChange(Collection<ReceiveCommand> commands) {
        boolean isRefCreationOrDeletion = false;
        for (ReceiveCommand cmd : commands) {
            if (!ReceiveCommand.Result.OK.equals((Object)cmd.getResult())) continue;
            switch (cmd.getType()) {
                case DELETE: {
                    LOGGER.info(MessageFormat.format("{0} DELETED {1} in {2} ({3})", this.user.username, cmd.getRefName(), this.repository.name, cmd.getOldId().name()));
                    isRefCreationOrDeletion = true;
                    break;
                }
                case CREATE: {
                    LOGGER.info(MessageFormat.format("{0} CREATED {1} in {2}", this.user.username, cmd.getRefName(), this.repository.name));
                    isRefCreationOrDeletion = true;
                    break;
                }
                case UPDATE: {
                    LOGGER.info(MessageFormat.format("{0} UPDATED {1} in {2} (from {3} to {4})", this.user.username, cmd.getRefName(), this.repository.name, cmd.getOldId().name(), cmd.getNewId().name()));
                    break;
                }
                case UPDATE_NONFASTFORWARD: {
                    LOGGER.info(MessageFormat.format("{0} UPDATED NON-FAST-FORWARD {1} in {2} (from {3} to {4})", this.user.username, cmd.getRefName(), this.repository.name, cmd.getOldId().name(), cmd.getNewId().name()));
                    break;
                }
            }
        }
        if (isRefCreationOrDeletion) {
            this.gitblit.resetRepositoryCache(this.repository.name);
        }
    }

    protected void updateIncrementalPushTags(Collection<ReceiveCommand> commands) {
        if (!this.repository.useIncrementalPushTags) {
            return;
        }
        String emailAddress = this.user.emailAddress == null ? this.getRefLogIdent().getEmailAddress() : this.user.emailAddress;
        PersonIdent userIdent = new PersonIdent(this.user.getDisplayName(), emailAddress);
        for (ReceiveCommand cmd : commands) {
            if (!cmd.getRefName().startsWith("refs/heads/") || ReceiveCommand.Type.DELETE.equals((Object)cmd.getType()) || !ReceiveCommand.Result.OK.equals((Object)cmd.getResult())) continue;
            String objectId = cmd.getNewId().getName();
            String branch = cmd.getRefName().substring("refs/heads/".length());
            String template = Translation.get("gb.incrementalPushTagMessage");
            String msg = MessageFormat.format(template, branch);
            String prefix = StringUtils.isEmpty(this.repository.incrementalPushTagPrefix) ? this.settings.getString("git.defaultIncrementalPushTagPrefix", "r") : this.repository.incrementalPushTagPrefix;
            JGitUtils.createIncrementalRevisionTag(this.getRepository(), objectId, userIdent, prefix, "0", msg);
        }
    }

    protected void updateGitblitRefLog(Collection<ReceiveCommand> commands) {
        try {
            RefLogUtils.updateRefLog(this.user, this.getRepository(), commands);
            LOGGER.debug(MessageFormat.format("{0} reflog updated", this.repository.name));
        }
        catch (Exception e) {
            LOGGER.error(MessageFormat.format("Failed to update {0} reflog", this.repository.name), (Throwable)e);
        }
    }

    protected void executeCommands() {
        List toApply = this.filterCommands(ReceiveCommand.Result.NOT_ATTEMPTED);
        if (toApply.isEmpty()) {
            return;
        }
        Object updating = NullProgressMonitor.INSTANCE;
        boolean sideBand = this.isCapabilityEnabled("side-band-64k");
        if (sideBand) {
            SideBandProgressMonitor pm = new SideBandProgressMonitor(this.msgOut);
            pm.setDelayStart(250L, TimeUnit.MILLISECONDS);
            updating = pm;
        }
        BatchRefUpdate batch = this.getRepository().getRefDatabase().newBatchUpdate();
        batch.setAllowNonFastForwards(this.isAllowNonFastForwards());
        batch.setRefLogIdent(this.getRefLogIdent());
        batch.setRefLogMessage("push", true);
        for (Object cmd : toApply) {
            if (ReceiveCommand.Result.NOT_ATTEMPTED != cmd.getResult()) continue;
            batch.addCommand((ReceiveCommand)cmd);
        }
        if (!batch.getCommands().isEmpty()) {
            try {
                batch.execute(this.getRevWalk(), (ProgressMonitor)updating);
            }
            catch (IOException err) {
                for (ReceiveCommand cmd : toApply) {
                    if (cmd.getResult() != ReceiveCommand.Result.NOT_ATTEMPTED) continue;
                    this.sendRejection(cmd, "lock error: {0}", err.getMessage());
                }
            }
        }
        if (this.ticketService != null) {
            List allUpdates = ReceiveCommand.filter((List)batch.getCommands(), (ReceiveCommand.Result)ReceiveCommand.Result.OK);
            if (!allUpdates.isEmpty()) {
                int ticketsProcessed = 0;
                block11: for (ReceiveCommand cmd : allUpdates) {
                    switch (cmd.getType()) {
                        case CREATE: 
                        case UPDATE: {
                            if (!cmd.getRefName().startsWith("refs/heads/")) break;
                            Collection<TicketModel> tickets2 = this.processReferencedTickets(cmd);
                            ticketsProcessed += tickets2.size();
                            for (TicketModel ticketModel : tickets2) {
                                this.ticketNotifier.queueMailing(ticketModel);
                            }
                            continue block11;
                        }
                        case UPDATE_NONFASTFORWARD: {
                            if (!cmd.getRefName().startsWith("refs/heads/")) break;
                            String base = JGitUtils.getMergeBase(this.getRepository(), cmd.getOldId(), cmd.getNewId());
                            List<TicketModel.TicketLink> deletedRefs = JGitUtils.identifyTicketsBetweenCommits(this.getRepository(), this.settings, base, cmd.getOldId().name());
                            for (TicketModel.TicketLink link : deletedRefs) {
                                link.isDelete = true;
                            }
                            TicketModel.Change change = new TicketModel.Change(this.user.username);
                            change.pendingLinks = deletedRefs;
                            this.ticketService.updateTicket(this.repository, 0L, change);
                            Collection<TicketModel> tickets3 = this.processReferencedTickets(cmd);
                            ticketsProcessed += tickets3.size();
                            Iterator iterator = tickets3.iterator();
                            while (iterator.hasNext()) {
                                TicketModel ticket2 = (TicketModel)iterator.next();
                                this.ticketNotifier.queueMailing(ticket2);
                            }
                            continue block11;
                        }
                        case DELETE: {
                            TreeMap<Integer, String> bases = new TreeMap<Integer, String>();
                            try {
                                ObjectId dObj = cmd.getOldId();
                                Collection collection = this.getRepository().getRefDatabase().getRefs("refs/heads/").values();
                                for (Ref ref : collection) {
                                    ObjectId iObj = ref.getObjectId();
                                    String mergeBase = JGitUtils.getMergeBase(this.getRepository(), dObj, iObj);
                                    if (mergeBase == null) continue;
                                    int d = JGitUtils.countCommits(this.getRepository(), this.getRevWalk(), mergeBase, dObj.name());
                                    bases.put(d, mergeBase);
                                    if (d != 0) continue;
                                    break;
                                }
                                if (bases.isEmpty()) break;
                                if ((Integer)bases.firstKey() <= 0) continue block11;
                                String mergeBase = (String)bases.get(bases.firstKey());
                                List<TicketModel.TicketLink> deletedRefs = JGitUtils.identifyTicketsBetweenCommits(this.getRepository(), this.settings, mergeBase, dObj.name());
                                for (TicketModel.TicketLink link : deletedRefs) {
                                    link.isDelete = true;
                                }
                                TicketModel.Change deletion = new TicketModel.Change(this.user.username);
                                deletion.pendingLinks = deletedRefs;
                                this.ticketService.updateTicket(this.repository, 0L, deletion);
                            }
                            catch (IOException e) {
                                LOGGER.error(null, (Throwable)e);
                            }
                            break;
                        }
                    }
                }
                if (ticketsProcessed == 1) {
                    this.sendInfo("1 ticket updated", new Object[0]);
                } else if (ticketsProcessed > 1) {
                    this.sendInfo("{0} tickets updated", ticketsProcessed);
                }
            }
            this.ticketService.resetCaches(this.repository);
        }
    }

    protected void setGitblitUrl(String url) {
        this.gitblitUrl = url;
    }

    public void sendRejection(ReceiveCommand cmd, String why, Object ... objects) {
        String text = ArrayUtils.isEmpty(objects) ? why : MessageFormat.format(why, objects);
        cmd.setResult(ReceiveCommand.Result.REJECTED_OTHER_REASON, text);
        LOGGER.error(text + " (" + this.user.username + ")");
    }

    public void sendHeader(String msg, Object ... objects) {
        this.sendInfo("--> ", msg, objects);
    }

    public void sendInfo(String msg, Object ... objects) {
        this.sendInfo("    ", msg, objects);
    }

    private void sendInfo(String prefix, String msg, Object ... objects) {
        String text;
        if (ArrayUtils.isEmpty(objects)) {
            text = msg;
            super.sendMessage(prefix + msg);
        } else {
            text = MessageFormat.format(msg, objects);
            super.sendMessage(prefix + text);
        }
        if (!StringUtils.isEmpty(msg)) {
            LOGGER.info(text + " (" + this.user.username + ")");
        }
    }

    public void sendError(String msg, Object ... objects) {
        String text;
        if (ArrayUtils.isEmpty(objects)) {
            text = msg;
            super.sendError(msg);
        } else {
            text = MessageFormat.format(msg, objects);
            super.sendError(text);
        }
        if (!StringUtils.isEmpty(msg)) {
            LOGGER.error(text + " (" + this.user.username + ")");
        }
    }

    private void runGroovy(Collection<ReceiveCommand> commands, Set<String> scripts) {
        if (scripts == null || scripts.size() == 0) {
            return;
        }
        Binding binding = new Binding();
        binding.setVariable("gitblit", (Object)this.gitblit);
        binding.setVariable("repository", (Object)this.repository);
        binding.setVariable("receivePack", (Object)this);
        binding.setVariable("user", (Object)this.user);
        binding.setVariable("commands", commands);
        binding.setVariable("url", (Object)this.gitblitUrl);
        binding.setVariable("logger", (Object)LOGGER);
        binding.setVariable("clientLogger", (Object)new ClientLogger(this));
        for (String script : scripts) {
            if (StringUtils.isEmpty(script)) continue;
            File file = new File(this.groovyDir, script);
            if (!file.exists() && !script.toLowerCase().endsWith(".groovy") && (file = new File(this.groovyDir, script + ".groovy")).exists()) {
                script = file.getName();
            }
            try {
                Object result = this.gse.run(script, binding);
                if (!(result instanceof Boolean) || ((Boolean)result).booleanValue()) continue;
                LOGGER.error(MessageFormat.format("Groovy script {0} has failed!  Hook scripts aborted.", script));
                break;
            }
            catch (Exception e) {
                LOGGER.error(MessageFormat.format("Failed to execute Groovy script {0}", script), (Throwable)e);
            }
        }
    }

    public IGitblit getGitblit() {
        return this.gitblit;
    }

    public RepositoryModel getRepositoryModel() {
        return this.repository;
    }

    public UserModel getUserModel() {
        return this.user;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<TicketModel> processReferencedTickets(ReceiveCommand cmd) {
        LinkedHashMap<Long, TicketModel> changedTickets = new LinkedHashMap<Long, TicketModel>();
        RevWalk rw = this.getRevWalk();
        try {
            RevCommit c;
            rw.reset();
            rw.markStart(rw.parseCommit((AnyObjectId)cmd.getNewId()));
            if (!ObjectId.zeroId().equals((AnyObjectId)cmd.getOldId())) {
                rw.markUninteresting(rw.parseCommit((AnyObjectId)cmd.getOldId()));
            }
            while ((c = rw.next()) != null) {
                rw.parseBody((RevObject)c);
                List<TicketModel.TicketLink> ticketLinks = JGitUtils.identifyTicketsFromCommitMessage(this.getRepository(), this.settings, c);
                if (ticketLinks == null) continue;
                block18: for (TicketModel.TicketLink link : ticketLinks) {
                    TicketModel ticket = this.ticketService.getTicket(this.repository, link.targetTicketId);
                    if (ticket == null) continue;
                    TicketModel.Change change = null;
                    String commitSha = c.getName();
                    String branchName = Repository.shortenRefName((String)cmd.getRefName());
                    switch (link.action) {
                        case Commit: {
                            change = new TicketModel.Change(this.user.username);
                            change.referenceCommit(commitSha);
                            break;
                        }
                        case Close: {
                            if (ticket.isClosed()) continue block18;
                            change = new TicketModel.Change(this.user.username);
                            change.setField(TicketModel.Field.status, (Object)TicketModel.Status.Fixed);
                            if (!StringUtils.isEmpty(ticket.responsible)) break;
                            change.setField(TicketModel.Field.responsible, this.user.username);
                        }
                    }
                    if (change != null) {
                        ticket = this.ticketService.updateTicket(this.repository, ticket.number, change);
                    }
                    if (ticket != null) {
                        this.sendInfo("", new Object[0]);
                        this.sendHeader("#{0,number,0}: {1}", ticket.number, StringUtils.trimString(ticket.title, 78));
                        switch (link.action) {
                            case Commit: {
                                this.sendInfo("referenced by push of {0} to {1}", commitSha, branchName);
                                changedTickets.put(ticket.number, ticket);
                                break;
                            }
                            case Close: {
                                this.sendInfo("closed by push of {0} to {1}", commitSha, branchName);
                                changedTickets.put(ticket.number, ticket);
                                break;
                            }
                        }
                        this.sendInfo(this.ticketService.getTicketUrl(ticket), new Object[0]);
                        this.sendInfo("", new Object[0]);
                        continue;
                    }
                    switch (link.action) {
                        case Commit: {
                            this.sendError("FAILED to reference ticket {0} by push of {1}", link.targetTicketId, commitSha);
                            break;
                        }
                        case Close: {
                            this.sendError("FAILED to close ticket {0} by push of {1}", link.targetTicketId, commitSha);
                            break;
                        }
                    }
                }
            }
        }
        catch (IOException e) {
            LOGGER.error("Can't scan for changes to reference or close", (Throwable)e);
        }
        finally {
            rw.reset();
        }
        return changedTickets.values();
    }
}

