/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.guice;

import com.gitblit.IStoredSettings;
import com.gitblit.manager.IRuntimeManager;
import com.gitblit.transport.ssh.FileKeyManager;
import com.gitblit.transport.ssh.IPublicKeyManager;
import com.gitblit.transport.ssh.NullKeyManager;
import com.gitblit.utils.StringUtils;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class IPublicKeyManagerProvider
implements Provider<IPublicKeyManager> {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final IRuntimeManager runtimeManager;
    private volatile IPublicKeyManager manager;

    @Inject
    public IPublicKeyManagerProvider(IRuntimeManager runtimeManager) {
        this.runtimeManager = runtimeManager;
    }

    public synchronized IPublicKeyManager get() {
        if (this.manager != null) {
            return this.manager;
        }
        IStoredSettings settings = this.runtimeManager.getSettings();
        String clazz = settings.getString("git.sshKeysManager", FileKeyManager.class.getName());
        if (StringUtils.isEmpty(clazz)) {
            clazz = FileKeyManager.class.getName();
        }
        try {
            Class<?> mgrClass = Class.forName(clazz);
            this.manager = (IPublicKeyManager)this.runtimeManager.getInjector().getInstance(mgrClass);
        }
        catch (Exception e) {
            this.logger.error("failed to create public key manager", (Throwable)e);
            this.manager = new NullKeyManager();
        }
        return this.manager;
    }
}

