/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.guice;

import com.gitblit.IStoredSettings;
import com.gitblit.manager.IRuntimeManager;
import com.gitblit.utils.IdGenerator;
import com.gitblit.utils.WorkQueue;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;

@Singleton
public class WorkQueueProvider
implements Provider<WorkQueue> {
    private final IRuntimeManager runtimeManager;
    private volatile WorkQueue workQueue;

    @Inject
    public WorkQueueProvider(IRuntimeManager runtimeManager) {
        this.runtimeManager = runtimeManager;
    }

    public synchronized WorkQueue get() {
        if (this.workQueue != null) {
            return this.workQueue;
        }
        IStoredSettings settings = this.runtimeManager.getSettings();
        int defaultThreadPoolSize = settings.getInteger("execution.defaultThreadPoolSize", 1);
        IdGenerator idGenerator = new IdGenerator();
        this.workQueue = new WorkQueue(idGenerator, defaultThreadPoolSize);
        return this.workQueue;
    }
}

