/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.instance;

import com.gitblit.IStoredSettings;
import com.gitblit.instance.GitblitInstanceId;
import com.gitblit.instance.GitblitInstanceReport;
import com.gitblit.instance.GitblitInstanceStat;
import com.gitblit.manager.IRuntimeManager;
import com.gitblit.utils.JsonUtils;
import java.io.IOException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GitblitInstance {
    private static final String STATS_URL = "https://instats.gitblit.dev/hiitsme/";
    private static final Logger LOG = LoggerFactory.getLogger(GitblitInstance.class);
    private IRuntimeManager runtimeManager;
    private String instanceId;
    private GitblitInstanceReport report;
    private ScheduledExecutorService executor;

    public void init(IRuntimeManager runtimeManager) {
        this.runtimeManager = runtimeManager;
        GitblitInstanceId instanceId = new GitblitInstanceId(runtimeManager.getBaseFolder());
        this.instanceId = instanceId.getId().toString();
        LOG.info(this.instanceId);
        GitblitInstanceStat instanceStat = runtimeManager.getSettings().hasSettings("container.dockerfileVersion") ? new GitblitInstanceStat(GitblitInstanceStat.GitblitInstanceType.DOCKER) : (runtimeManager.getStatus().isGO ? new GitblitInstanceStat(GitblitInstanceStat.GitblitInstanceType.GO) : new GitblitInstanceStat(GitblitInstanceStat.GitblitInstanceType.WAR));
        instanceStat.init(runtimeManager.getStatus());
        this.report = new GitblitInstanceReport(this.instanceId, instanceStat);
    }

    public void start() {
        if (this.shouldRunReports()) {
            this.startReports();
        }
    }

    public void stop() {
        if (this.executor != null && !this.executor.isShutdown() && !this.executor.isTerminated()) {
            this.executor.shutdownNow();
            System.out.println("Gitblit instance reporting task stopped.");
        }
    }

    boolean shouldRunReports() {
        if (this.report == null || this.runtimeManager == null) {
            return false;
        }
        IStoredSettings settings = this.runtimeManager.getSettings();
        if (!settings.getString("gitblit.testReportingUrl", "").isEmpty()) {
            LOG.debug("Enabled reporting to test server URL: {}", (Object)settings.getString("gitblit.testReportingUrl", ""));
            return true;
        }
        if (settings.getBoolean("gitblit.testRun", false)) {
            return false;
        }
        if (this.runtimeManager.getStatus().version.endsWith("SNAPSHOT")) {
            return false;
        }
        if (this.report.instanceStat.instanceType == GitblitInstanceStat.GitblitInstanceType.DOCKER) {
            if (!settings.getString("container.imageType", "").equals("release")) {
                return false;
            }
            if (System.getenv("GITBLIT_GOSS_TEST") != null) {
                return false;
            }
        }
        return true;
    }

    private void startReports() {
        this.executor = Executors.newSingleThreadScheduledExecutor();
        String statsUrl = STATS_URL;
        int delay = 24;
        int period = 1440;
        TimeUnit unit = TimeUnit.MINUTES;
        long retryInterval = 3600000L;
        long retryTimeout = 72000000L;
        String testUrl = this.runtimeManager.getSettings().getString("gitblit.testReportingUrl", "");
        if (!testUrl.isEmpty()) {
            statsUrl = testUrl;
            delay = 10;
            period = 24;
            unit = TimeUnit.SECONDS;
            retryInterval = 10000L;
        }
        final String baseUrl = statsUrl;
        final long retryIntervalFinal = retryInterval;
        this.executor.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                GitblitInstance.this.sendMyStats(baseUrl + GitblitInstance.this.instanceId, retryIntervalFinal, 72000000L);
            }
        }, delay, period, unit);
    }

    private void sendMyStats(String reportUrl, long retryInterval, long retryTimeout) {
        String report = JsonUtils.toJsonString(this.report.fromNow());
        int status = 0;
        long timeToGiveup = System.currentTimeMillis() + retryTimeout;
        while (status != 200 && System.currentTimeMillis() < timeToGiveup) {
            try {
                status = JsonUtils.sendJsonString(reportUrl, report, "gitblitta", "countmein".toCharArray());
                if (status != 200) {
                    LOG.debug("Error sending stats to " + reportUrl + ": " + status);
                }
            }
            catch (IOException e) {
                LOG.debug("Exception sending stats to " + reportUrl + ": " + e.getMessage());
            }
            if (status == 200) continue;
            try {
                Thread.sleep(retryInterval);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return;
            }
        }
    }
}

