/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.instance;

import com.gitblit.utils.FileUtils;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GitblitInstanceId {
    static final String STORAGE_FILE = "gbins";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final File idFileBase;
    private UUID id;

    public GitblitInstanceId() {
        this.idFileBase = null;
    }

    public GitblitInstanceId(File idFileBase) {
        this.idFileBase = idFileBase;
    }

    public UUID getId() {
        if (this.id == null) {
            this.load();
        }
        return this.id;
    }

    private void load() {
        if (this.idFileBase == null) {
            this.log.debug("No id file base directory specified. Generated id is not persisted.");
            this.generate();
            return;
        }
        File idFile = new File(this.idFileBase, STORAGE_FILE);
        if (idFile.exists()) {
            String uuidString = this.readFromFile(idFile);
            try {
                this.id = UUID.fromString(uuidString);
                return;
            }
            catch (IllegalArgumentException e) {
                this.log.debug("Unable to parse instance id. Will generate a new one: {}", (Object)e.getMessage(), (Object)e);
            }
        }
        this.generate();
        this.storeToFile(idFile);
    }

    private String readFromFile(File idfile) {
        String string = FileUtils.readContent(idfile, null).trim();
        String uuidString = string.replaceAll("\\s+", "");
        return uuidString.trim();
    }

    private void storeToFile(File idfile) {
        if (!idfile.getParentFile().exists() && !idfile.getParentFile().mkdirs()) {
            this.log.debug("Unable to create directory for instance id file: {}", (Object)idfile.getParentFile().getAbsolutePath());
            return;
        }
        String uuidString = this.id.toString();
        FileUtils.writeContent(idfile, uuidString);
    }

    private void generate() {
        UUID id = UUID.randomUUID();
        long upper = id.getMostSignificantBits();
        long lower = id.getLeastSignificantBits();
        lower &= 0xFFFFFFFFFFFFFFFL;
        lower |= Long.MIN_VALUE;
        upper &= 0xFFFFFFFFFFFF0FFFL;
        upper |= 0x8000L;
        long date = System.currentTimeMillis();
        date &= 0xFFFFFFFFFFFF0000L;
        upper &= 0xFFFFFFFFL;
        upper |= (date <<= 16);
        Long oui = this.getNodeOUI();
        if (oui != null) {
            lower &= 0xFFFFFFFFFF000000L;
            lower |= 0x1000000L | oui;
        } else {
            lower &= 0xFFFFFFFFFEFFFFFFL;
        }
        this.id = new UUID(upper, lower);
    }

    private Long getNodeOUI() {
        byte[] node = null;
        String logPrefix = "Unable to detect host. Use random value.";
        try {
            InetAddress ipa = InetAddress.getLocalHost();
            NetworkInterface iface = NetworkInterface.getByInetAddress(ipa);
            if (iface != null) {
                node = iface.getHardwareAddress();
                logPrefix = "From getLocalHost:";
            }
            if (node == null) {
                ArrayList<byte[]> macs = new ArrayList<byte[]>();
                ArrayList<byte[]> offmacs = new ArrayList<byte[]>();
                Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
                while (interfaces.hasMoreElements()) {
                    iface = interfaces.nextElement();
                    byte[] mac = iface.getHardwareAddress();
                    if (mac == null || iface.isLoopback() || iface.isVirtual() || iface.isPointToPoint()) continue;
                    if (iface.isUp()) {
                        macs.add(mac);
                        continue;
                    }
                    offmacs.add(mac);
                }
                if (macs.size() == 1) {
                    node = (byte[])macs.get(0);
                    logPrefix = "From up iface:";
                } else if (offmacs.size() == 1) {
                    node = (byte[])offmacs.get(0);
                    logPrefix = "From down iface:";
                }
            }
            if (node == null) {
                Socket socket = new Socket("www.gitblit.dev", 80);
                ipa = socket.getLocalAddress();
                socket.close();
                iface = NetworkInterface.getByInetAddress(ipa);
                if (iface != null) {
                    node = iface.getHardwareAddress();
                    logPrefix = "From socket:";
                }
            }
            if (node == null) {
                this.log.debug(logPrefix);
                return null;
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("{} {}", (Object)logPrefix, (Object)String.format("%02X:%02X:%02X", node[0], node[1], node[2]));
            }
            long l = (long)node[0] << 16 & 0xFF0000L;
            l |= (long)node[1] << 8 & 0xFF00L;
            return l |= (long)node[2] & 0xFFL;
        }
        catch (IOException e) {
            this.log.debug("Exception while getting OUI: {}", (Object)e.getMessage(), (Object)e);
            return null;
        }
    }
}

