/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.instance;

import com.gitblit.instance.GitblitInstanceStat;
import com.google.gson.annotations.SerializedName;
import java.text.SimpleDateFormat;
import java.util.TimeZone;

class GitblitInstanceReport {
    private final int reportVersion = 1;
    @SerializedName(value="instance")
    private final String instanceId;
    private final String startTs;
    private String lpingTs;
    final GitblitInstanceStat instanceStat;

    GitblitInstanceReport(String instanceId, GitblitInstanceStat instanceStat) {
        this.instanceId = instanceId;
        this.instanceStat = instanceStat;
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd'T'HHmmss'Z'");
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        this.startTs = dateFormat.format(instanceStat.startTs);
    }

    GitblitInstanceReport fromNow() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd'T'HHmmss'Z'");
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        this.lpingTs = dateFormat.format(System.currentTimeMillis());
        return this;
    }
}

