/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.instance;

import com.gitblit.models.ServerStatus;
import java.util.Date;

class GitblitInstanceStat {
    final GitblitInstanceType instanceType;
    String version;
    Date startTs;
    String os;
    String osName;
    String osVersion;
    String osArch;
    String javaVersion;
    String javaVendor;
    String javaRuntimeVersion;
    String javaRuntimeName;
    String javaVmVersion;
    String javaVmName;
    long maxMem;

    GitblitInstanceStat() {
        this.instanceType = GitblitInstanceType.WAR;
        this.initOS();
        this.initJava();
    }

    GitblitInstanceStat(GitblitInstanceType instanceType) {
        this.instanceType = instanceType;
        this.initOS();
        this.initJava();
    }

    GitblitInstanceStat init(ServerStatus serverStatus) {
        this.version = serverStatus.version;
        this.startTs = serverStatus.bootDate;
        this.maxMem = serverStatus.heapMaximum;
        return this;
    }

    void initOS() {
        String oslc;
        String os = System.getProperty("os.name");
        this.os = os == null ? "Unknown" : ((oslc = os.toLowerCase()).contains("windows") ? "Windows" : (oslc.contains("linux") ? "Linux" : (oslc.contains("mac") || oslc.contains("darwin") ? "macOS" : (oslc.contains("bsd") ? "BSD" : (oslc.contains("solaris") || oslc.contains("sun") || oslc.contains("aix") || oslc.contains("hpux") || oslc.contains("unix") ? "Unix" : os)))));
        this.osName = System.getProperty("os.name");
        this.osVersion = System.getProperty("os.version");
        this.osArch = System.getProperty("os.arch");
    }

    void initJava() {
        this.javaVersion = System.getProperty("java.version");
        this.javaVendor = System.getProperty("java.vendor");
        this.javaRuntimeVersion = System.getProperty("java.runtime.version", "");
        this.javaRuntimeName = System.getProperty("java.runtime.name", "");
        this.javaVmVersion = System.getProperty("java.vm.version", "");
        this.javaVmName = System.getProperty("java.vm.name", "");
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("GitblitInstanceStat {").append("\n  instanceType: ").append((Object)this.instanceType).append(",\n  version: ").append(this.version).append(",\n  startTs: ").append(this.startTs).append(",\n  os: ").append(this.os).append(",\n  osName: ").append(this.osName).append(",\n  osVersion: ").append(this.osVersion).append(",\n  osArch: ").append(this.osArch).append(",\n  javaVersion: ").append(this.javaVersion).append(",\n  javaVendor: ").append(this.javaVendor).append(",\n  javaRuntimeVersion: ").append(this.javaRuntimeVersion).append(",\n  javaRuntimeName: ").append(this.javaRuntimeName).append(",\n  javaVmVersion: ").append(this.javaVmVersion).append(",\n  javaVmName: ").append(this.javaVmName).append(",\n  maxMem: ").append(this.maxMem).append("\n}");
        return sb.toString();
    }

    static enum GitblitInstanceType {
        GO,
        WAR,
        EXPRESS,
        DOCKER;

    }
}

