/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.ldap;

import com.gitblit.IStoredSettings;
import com.gitblit.utils.StringUtils;
import com.unboundid.ldap.sdk.BindRequest;
import com.unboundid.ldap.sdk.BindResult;
import com.unboundid.ldap.sdk.DereferencePolicy;
import com.unboundid.ldap.sdk.ExtendedRequest;
import com.unboundid.ldap.sdk.ExtendedResult;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPSearchException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.SearchRequest;
import com.unboundid.ldap.sdk.SearchResult;
import com.unboundid.ldap.sdk.SearchScope;
import com.unboundid.ldap.sdk.SimpleBindRequest;
import com.unboundid.ldap.sdk.extensions.StartTLSExtendedRequest;
import com.unboundid.util.ssl.SSLUtil;
import com.unboundid.util.ssl.TrustAllTrustManager;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.GeneralSecurityException;
import java.util.List;
import javax.net.SocketFactory;
import javax.net.ssl.TrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LdapConnection
implements AutoCloseable {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private IStoredSettings settings;
    private LDAPConnection conn;
    private SimpleBindRequest currentBindRequest;
    private SimpleBindRequest managerBindRequest;
    private SimpleBindRequest userBindRequest;

    public static final String escapeLDAPSearchFilter(String filter) {
        StringBuilder sb = new StringBuilder();
        block7: for (int i = 0; i < filter.length(); ++i) {
            char curChar = filter.charAt(i);
            switch (curChar) {
                case '\\': {
                    sb.append("\\5c");
                    continue block7;
                }
                case '*': {
                    sb.append("\\2a");
                    continue block7;
                }
                case '(': {
                    sb.append("\\28");
                    continue block7;
                }
                case ')': {
                    sb.append("\\29");
                    continue block7;
                }
                case '\u0000': {
                    sb.append("\\00");
                    continue block7;
                }
                default: {
                    sb.append(curChar);
                }
            }
        }
        return sb.toString();
    }

    public static String getAccountBase(IStoredSettings settings) {
        return settings.getString("realm.ldap.accountBase", "");
    }

    public static String getAccountPattern(IStoredSettings settings) {
        return settings.getString("realm.ldap.accountPattern", "(&(objectClass=person)(sAMAccountName=${username}))");
    }

    public LdapConnection(IStoredSettings settings) {
        this.settings = settings;
        String bindUserName = settings.getString("realm.ldap.username", "");
        String bindPassword = settings.getString("realm.ldap.password", "");
        if (StringUtils.isEmpty(bindUserName) && StringUtils.isEmpty(bindPassword)) {
            this.managerBindRequest = new SimpleBindRequest();
        }
        this.managerBindRequest = new SimpleBindRequest(bindUserName, bindPassword);
    }

    public String getAccountBase() {
        return LdapConnection.getAccountBase(this.settings);
    }

    public String getAccountPattern() {
        return LdapConnection.getAccountPattern(this.settings);
    }

    public boolean connect() {
        try {
            ExtendedResult extendedResult;
            SSLUtil sslUtil;
            URI ldapUrl = new URI(this.settings.getRequiredString("realm.ldap.server"));
            String ldapHost = ldapUrl.getHost();
            int ldapPort = ldapUrl.getPort();
            if (ldapUrl.getScheme().equalsIgnoreCase("ldaps")) {
                sslUtil = new SSLUtil((TrustManager)new TrustAllTrustManager());
                this.conn = new LDAPConnection((SocketFactory)sslUtil.createSSLSocketFactory());
                if (ldapPort == -1) {
                    ldapPort = 636;
                }
            } else if (ldapUrl.getScheme().equalsIgnoreCase("ldap") || ldapUrl.getScheme().equalsIgnoreCase("ldap+tls")) {
                this.conn = new LDAPConnection();
                if (ldapPort == -1) {
                    ldapPort = 389;
                }
            } else {
                this.logger.error("Unsupported LDAP URL scheme: " + ldapUrl.getScheme());
                return false;
            }
            this.conn.connect(ldapHost, ldapPort);
            if (ldapUrl.getScheme().equalsIgnoreCase("ldap+tls") && (extendedResult = this.conn.processExtendedOperation((ExtendedRequest)new StartTLSExtendedRequest((sslUtil = new SSLUtil((TrustManager)new TrustAllTrustManager())).createSSLContext()))).getResultCode() != ResultCode.SUCCESS) {
                throw new LDAPException(extendedResult.getResultCode());
            }
            return true;
        }
        catch (URISyntaxException e) {
            this.logger.error("Bad LDAP URL, should be in the form: ldap(s|+tls)://<server>:<port>", (Throwable)e);
        }
        catch (GeneralSecurityException e) {
            this.logger.error("Unable to create SSL Connection", (Throwable)e);
        }
        catch (LDAPException e) {
            this.logger.error("Error Connecting to LDAP", (Throwable)e);
        }
        return false;
    }

    @Override
    public void close() {
        if (this.conn != null) {
            this.conn.close();
        }
    }

    public BindResult bind() {
        BindResult result = null;
        try {
            result = this.conn.bind((BindRequest)this.managerBindRequest);
            this.currentBindRequest = this.managerBindRequest;
        }
        catch (LDAPException e) {
            this.logger.error("Error authenticating to LDAP with manager account to search the directory.");
            this.logger.error("  Please check your settings for realm.ldap.username and realm.ldap.password.");
            this.logger.debug("  Received exception when binding to LDAP", (Throwable)e);
            return null;
        }
        return result;
    }

    public BindResult bind(String bindPattern, String simpleUsername, String password) {
        BindResult result = null;
        try {
            String bindUser = StringUtils.replace(bindPattern, "${username}", LdapConnection.escapeLDAPSearchFilter(simpleUsername));
            SimpleBindRequest request = new SimpleBindRequest(bindUser, password);
            result = this.conn.bind((BindRequest)request);
            this.currentBindRequest = this.userBindRequest = request;
        }
        catch (LDAPException e) {
            this.logger.error("Error authenticating to LDAP with user account to search the directory.");
            this.logger.error("  Please check your settings for realm.ldap.bindpattern.");
            this.logger.debug("  Received exception when binding to LDAP", (Throwable)e);
            return null;
        }
        return result;
    }

    public boolean rebindAsUser() {
        if (this.userBindRequest == null || this.currentBindRequest == this.userBindRequest) {
            return false;
        }
        try {
            this.conn.bind((BindRequest)this.userBindRequest);
            this.currentBindRequest = this.userBindRequest;
        }
        catch (LDAPException e) {
            this.conn.close();
            this.logger.error("Error rebinding to LDAP with user account.", (Throwable)e);
            return false;
        }
        return true;
    }

    public boolean isAuthenticated(String userDn, String password) {
        this.verifyCurrentBinding();
        String boundDN = this.currentBindRequest.getBindDN();
        if (boundDN != null && boundDN.equals(userDn)) {
            return true;
        }
        boolean isAuthenticated = false;
        try {
            SimpleBindRequest ubr = new SimpleBindRequest(userDn, password);
            this.conn.bind((BindRequest)ubr);
            isAuthenticated = true;
            this.userBindRequest = ubr;
        }
        catch (LDAPException e) {
            this.logger.error("Error authenticating user ({})", (Object)userDn, (Object)e);
        }
        try {
            this.conn.bind((BindRequest)this.currentBindRequest);
        }
        catch (LDAPException e) {
            this.logger.error("Error reinstating original LDAP authorization (code {}). Team information may be inaccurate for this log in.", (Object)e.getResultCode(), (Object)e);
        }
        return isAuthenticated;
    }

    public SearchResult search(SearchRequest request) {
        try {
            return this.conn.search(request);
        }
        catch (LDAPSearchException e) {
            this.logger.error("Problem Searching LDAP [{}]", (Object)e.getResultCode());
            return e.getSearchResult();
        }
    }

    public SearchResult search(String base, boolean dereferenceAliases, String filter, List<String> attributes) {
        try {
            SearchRequest searchRequest = new SearchRequest(base, SearchScope.SUB, filter, new String[0]);
            if (dereferenceAliases) {
                searchRequest.setDerefPolicy(DereferencePolicy.SEARCHING);
            }
            if (attributes != null) {
                searchRequest.setAttributes(attributes);
            }
            SearchResult result = this.search(searchRequest);
            return result;
        }
        catch (LDAPException e) {
            this.logger.error("Problem creating LDAP search", (Throwable)e);
            return null;
        }
    }

    public SearchResult searchUser(String username, List<String> attributes) {
        String accountPattern = this.getAccountPattern();
        accountPattern = StringUtils.replace(accountPattern, "${username}", LdapConnection.escapeLDAPSearchFilter(username));
        return this.search(this.getAccountBase(), false, accountPattern, attributes);
    }

    public SearchResult searchUser(String username) {
        return this.searchUser(username, null);
    }

    private boolean verifyCurrentBinding() {
        BindRequest lastBind = this.conn.getLastBindRequest();
        if (lastBind == this.currentBindRequest) {
            return true;
        }
        this.logger.debug("Unexpected binding in LdapConnection. {} != {}", (Object)lastBind, (Object)this.currentBindRequest);
        String lastBoundDN = ((SimpleBindRequest)lastBind).getBindDN();
        String boundDN = this.currentBindRequest.getBindDN();
        this.logger.debug("Currently bound as '{}', check authentication for '{}'", (Object)lastBoundDN, (Object)boundDN);
        if (boundDN != null && !boundDN.equals(lastBoundDN)) {
            this.logger.warn("Unexpected binding DN in LdapConnection. '{}' != '{}'.", (Object)lastBoundDN, (Object)boundDN);
            this.logger.warn("Updated binding information in LDAP connection.");
            this.currentBindRequest = (SimpleBindRequest)lastBind;
            return false;
        }
        return true;
    }
}

