/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.manager;

import com.gitblit.Constants;
import com.gitblit.IStoredSettings;
import com.gitblit.manager.IFederationManager;
import com.gitblit.manager.INotificationManager;
import com.gitblit.manager.IRepositoryManager;
import com.gitblit.manager.IRuntimeManager;
import com.gitblit.models.FederationModel;
import com.gitblit.models.FederationProposal;
import com.gitblit.models.FederationSet;
import com.gitblit.models.RepositoryModel;
import com.gitblit.models.UserModel;
import com.gitblit.utils.Base64;
import com.gitblit.utils.FederationUtils;
import com.gitblit.utils.FileUtils;
import com.gitblit.utils.JsonUtils;
import com.gitblit.utils.StringUtils;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.File;
import java.io.FileFilter;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class FederationManager
implements IFederationManager {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final List<FederationModel> federationRegistrations = Collections.synchronizedList(new ArrayList());
    private final Map<String, FederationModel> federationPullResults = new ConcurrentHashMap<String, FederationModel>();
    private final IStoredSettings settings;
    private final IRuntimeManager runtimeManager;
    private final INotificationManager notificationManager;
    private final IRepositoryManager repositoryManager;

    @Inject
    public FederationManager(IRuntimeManager runtimeManager, INotificationManager notificationManager, IRepositoryManager repositoryManager) {
        this.settings = runtimeManager.getSettings();
        this.runtimeManager = runtimeManager;
        this.notificationManager = notificationManager;
        this.repositoryManager = repositoryManager;
    }

    @Override
    public FederationManager start() {
        return this;
    }

    @Override
    public FederationManager stop() {
        return this;
    }

    @Override
    public File getProposalsFolder() {
        return this.runtimeManager.getFileOrFolder("federation.proposalsFolder", "${baseFolder}/proposals");
    }

    @Override
    public boolean canFederate() {
        String passphrase = this.settings.getString("federation.passphrase", "");
        return !StringUtils.isEmpty(passphrase);
    }

    @Override
    public UserModel getFederationUser() {
        UserModel federationUser = new UserModel("$gitblit");
        federationUser.canAdmin = true;
        return federationUser;
    }

    @Override
    public UserModel authenticate(HttpServletRequest httpRequest) {
        String base64Credentials;
        String credentials;
        String[] values;
        String authorization;
        if (this.canFederate() && (authorization = httpRequest.getHeader("Authorization")) != null && authorization.startsWith("Basic") && (values = (credentials = new String(Base64.decode(base64Credentials = authorization.substring("Basic".length()).trim()), Charset.forName("UTF-8"))).split(":", 2)).length == 2) {
            List<String> tokens;
            String username = StringUtils.decodeUsername(values[0]);
            String password = values[1];
            if (username.equalsIgnoreCase("$gitblit") && (tokens = this.getFederationTokens()).contains(password)) {
                return this.getFederationUser();
            }
        }
        return null;
    }

    @Override
    public List<FederationModel> getFederationRegistrations() {
        if (this.federationRegistrations.isEmpty()) {
            this.federationRegistrations.addAll(FederationUtils.getFederationRegistrations(this.settings));
        }
        return this.federationRegistrations;
    }

    @Override
    public FederationModel getFederationRegistration(String url, String name) {
        for (FederationModel r : this.getFederationRegistrations()) {
            if (!r.name.equals(name) || !r.url.equals(url)) continue;
            return r;
        }
        for (FederationModel r : this.getFederationResultRegistrations()) {
            if (!r.name.equals(name) || !r.url.equals(url)) continue;
            return r;
        }
        return null;
    }

    @Override
    public List<FederationSet> getFederationSets(String gitblitUrl) {
        ArrayList<FederationSet> list = new ArrayList<FederationSet>();
        for (Constants.FederationToken type : Constants.FederationToken.values()) {
            FederationSet fset = new FederationSet(type.toString(), type, this.getFederationToken(type));
            fset.repositories = this.getRepositories(gitblitUrl, fset.token);
            list.add(fset);
        }
        for (String set : this.settings.getStrings("federation.sets")) {
            FederationSet fset = new FederationSet(set, Constants.FederationToken.REPOSITORIES, this.getFederationToken(set));
            fset.repositories = this.getRepositories(gitblitUrl, fset.token);
            list.add(fset);
        }
        return list;
    }

    @Override
    public List<String> getFederationTokens() {
        ArrayList<String> tokens = new ArrayList<String>();
        for (Constants.FederationToken type : Constants.FederationToken.values()) {
            tokens.add(this.getFederationToken(type));
        }
        for (String set : this.settings.getStrings("federation.sets")) {
            tokens.add(this.getFederationToken(set));
        }
        return tokens;
    }

    @Override
    public String getFederationToken(Constants.FederationToken type) {
        return this.getFederationToken(type.name());
    }

    @Override
    public String getFederationToken(String value) {
        String passphrase = this.settings.getString("federation.passphrase", "");
        return StringUtils.getSHA1(passphrase + "-" + value);
    }

    @Override
    public boolean validateFederationRequest(Constants.FederationRequest req, String token) {
        String all = this.getFederationToken(Constants.FederationToken.ALL);
        String unr = this.getFederationToken(Constants.FederationToken.USERS_AND_REPOSITORIES);
        String jur = this.getFederationToken(Constants.FederationToken.REPOSITORIES);
        switch (req) {
            case PULL_REPOSITORIES: {
                return token.equals(all) || token.equals(unr) || token.equals(jur);
            }
            case PULL_USERS: 
            case PULL_TEAMS: {
                return token.equals(all) || token.equals(unr);
            }
            case PULL_SETTINGS: 
            case PULL_SCRIPTS: {
                return token.equals(all);
            }
        }
        return false;
    }

    @Override
    public boolean acknowledgeFederationStatus(String identification, FederationModel registration) {
        registration.url = identification;
        String id = identification;
        if (!StringUtils.isEmpty(registration.folder)) {
            id = id + "-" + registration.folder;
        }
        this.federationPullResults.put(id, registration);
        return true;
    }

    @Override
    public List<FederationModel> getFederationResultRegistrations() {
        return new ArrayList<FederationModel>(this.federationPullResults.values());
    }

    @Override
    public boolean submitFederationProposal(FederationProposal proposal, String gitblitUrl) {
        String json = JsonUtils.toJsonString(proposal);
        try {
            File proposalsFolder = this.getProposalsFolder();
            proposalsFolder.mkdirs();
            File file = new File(proposalsFolder, proposal.token + ".json");
            FileUtils.writeContent(file, json);
        }
        catch (Exception e) {
            this.logger.error(MessageFormat.format("Failed to cache proposal from {0}", proposal.url), (Throwable)e);
        }
        this.notificationManager.sendMailToAdministrators("Federation proposal from " + proposal.url, "Please review the proposal @ " + gitblitUrl + "/proposal/" + proposal.token);
        return true;
    }

    @Override
    public List<FederationProposal> getPendingFederationProposals() {
        ArrayList<FederationProposal> list = new ArrayList<FederationProposal>();
        File folder = this.getProposalsFolder();
        if (folder.exists()) {
            File[] files = folder.listFiles(new FileFilter(){

                @Override
                public boolean accept(File file) {
                    return file.isFile() && file.getName().toLowerCase().endsWith(".json");
                }
            });
            if (files == null) {
                return list;
            }
            for (File file : files) {
                String json = FileUtils.readContent(file, null);
                FederationProposal proposal = JsonUtils.fromJsonString(json, FederationProposal.class);
                list.add(proposal);
            }
        }
        return list;
    }

    @Override
    public Map<String, RepositoryModel> getRepositories(String gitblitUrl, String token) {
        HashMap<String, String> federationSets = new HashMap<String, String>();
        for (String set : this.settings.getStrings("federation.sets")) {
            federationSets.put(this.getFederationToken(set), set);
        }
        StringBuilder sb = new StringBuilder();
        sb.append(gitblitUrl);
        sb.append("/r/");
        sb.append("{0}");
        String cloneUrl = sb.toString();
        UserModel user = this.getFederationUser();
        List<RepositoryModel> list = this.repositoryManager.getRepositoryModels(user);
        HashMap<String, RepositoryModel> repositories = new HashMap<String, RepositoryModel>();
        block5: for (RepositoryModel model : list) {
            String url = MessageFormat.format(cloneUrl, model.name);
            switch (model.federationStrategy) {
                case EXCLUDE: {
                    continue block5;
                }
                case FEDERATE_ORIGIN: {
                    if (StringUtils.isEmpty(model.origin)) break;
                    url = model.origin;
                    break;
                }
            }
            if (federationSets.containsKey(token)) {
                String set = (String)federationSets.get(token);
                if (!model.federationSets.contains(set)) continue;
                repositories.put(url, model);
                continue;
            }
            repositories.put(url, model);
        }
        return repositories;
    }

    @Override
    public FederationProposal createFederationProposal(String gitblitUrl, String token) {
        Constants.FederationToken tokenType = Constants.FederationToken.REPOSITORIES;
        for (Constants.FederationToken type : Constants.FederationToken.values()) {
            if (!token.equals(this.getFederationToken(type))) continue;
            tokenType = type;
            break;
        }
        Map<String, RepositoryModel> repositories = this.getRepositories(gitblitUrl, token);
        FederationProposal proposal = new FederationProposal(gitblitUrl, tokenType, token, repositories);
        return proposal;
    }

    @Override
    public FederationProposal getPendingFederationProposal(String token) {
        List<FederationProposal> list = this.getPendingFederationProposals();
        for (FederationProposal proposal : list) {
            if (!proposal.token.equals(token)) continue;
            return proposal;
        }
        return null;
    }

    @Override
    public boolean deletePendingFederationProposal(FederationProposal proposal) {
        File folder = this.getProposalsFolder();
        File file = new File(folder, proposal.token + ".json");
        return file.delete();
    }
}

