/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.manager;

import com.gitblit.IStoredSettings;
import com.gitblit.manager.INotificationManager;
import com.gitblit.models.Mailing;
import com.gitblit.service.MailService;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Collection;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.mail.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class NotificationManager
implements INotificationManager {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ScheduledExecutorService scheduledExecutor = Executors.newScheduledThreadPool(1);
    private final IStoredSettings settings;
    private final MailService mailService;

    @Inject
    public NotificationManager(IStoredSettings settings) {
        this.settings = settings;
        this.mailService = new MailService(settings);
    }

    @Override
    public NotificationManager start() {
        if (this.mailService.isReady()) {
            int period = 2;
            this.logger.info("Mail service will process the queue every {} minutes.", (Object)period);
            this.scheduledExecutor.scheduleAtFixedRate(this.mailService, 1L, period, TimeUnit.MINUTES);
        } else {
            this.logger.warn("Mail service disabled.");
        }
        return this;
    }

    @Override
    public NotificationManager stop() {
        this.scheduledExecutor.shutdownNow();
        return this;
    }

    @Override
    public boolean isSendingMail() {
        return this.mailService.isReady();
    }

    @Override
    public void sendMailToAdministrators(String subject, String message) {
        Mailing mail2 = Mailing.newPlain();
        mail2.subject = subject;
        mail2.content = message;
        mail2.setRecipients(this.settings.getStrings("mail.adminAddresses"));
        this.send(mail2);
    }

    @Override
    public void sendMail(String subject, String message, Collection<String> toAddresses) {
        Mailing mail2 = Mailing.newPlain();
        mail2.subject = subject;
        mail2.content = message;
        mail2.setRecipients(toAddresses);
        this.send(mail2);
    }

    @Override
    public void sendHtmlMail(String subject, String message, Collection<String> toAddresses) {
        Mailing mail2 = Mailing.newHtml();
        mail2.subject = subject;
        mail2.content = message;
        mail2.setRecipients(toAddresses);
        this.send(mail2);
    }

    @Override
    public void send(Mailing mailing) {
        if (!mailing.hasRecipients()) {
            this.logger.debug("Dropping message {} because there are no recipients", (Object)mailing.subject);
            return;
        }
        Message msg = this.mailService.createMessage(mailing);
        if (msg != null) {
            this.mailService.queue(msg);
        }
    }
}

