/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.manager;

import com.gitblit.Constants;
import com.gitblit.extensions.GitblitPlugin;
import com.gitblit.manager.IPluginManager;
import com.gitblit.manager.IRuntimeManager;
import com.gitblit.models.PluginRegistry;
import com.gitblit.utils.Base64;
import com.gitblit.utils.FileUtils;
import com.gitblit.utils.JsonUtils;
import com.gitblit.utils.StringUtils;
import com.google.common.io.ByteStreams;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.fortsoft.pf4j.DefaultPluginFactory;
import ro.fortsoft.pf4j.DefaultPluginManager;
import ro.fortsoft.pf4j.ExtensionFactory;
import ro.fortsoft.pf4j.Plugin;
import ro.fortsoft.pf4j.PluginClassLoader;
import ro.fortsoft.pf4j.PluginFactory;
import ro.fortsoft.pf4j.PluginState;
import ro.fortsoft.pf4j.PluginStateEvent;
import ro.fortsoft.pf4j.PluginStateListener;
import ro.fortsoft.pf4j.PluginWrapper;
import ro.fortsoft.pf4j.Version;

@Singleton
public class PluginManager
implements IPluginManager,
PluginStateListener {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final IRuntimeManager runtimeManager;
    private DefaultPluginManager pf4j;
    private int connectTimeout = 20;
    private int readTimeout = 12800;

    @Inject
    public PluginManager(IRuntimeManager runtimeManager) {
        this.runtimeManager = runtimeManager;
    }

    @Override
    public Version getSystemVersion() {
        return this.pf4j.getSystemVersion();
    }

    public void pluginStateChanged(PluginStateEvent event) {
        this.logger.debug(event.toString());
    }

    @Override
    public PluginManager start() {
        File dir = this.runtimeManager.getFileOrFolder("plugins.folder", "${baseFolder}/plugins");
        dir.mkdirs();
        this.pf4j = new DefaultPluginManager(dir){

            protected PluginFactory createPluginFactory() {
                return new GuicePluginFactory();
            }

            protected ExtensionFactory createExtensionFactory() {
                return new GuiceExtensionFactory();
            }
        };
        try {
            Version systemVersion = Version.createVersion((String)Constants.getVersion());
            this.pf4j.setSystemVersion(systemVersion);
        }
        catch (Exception e) {
            this.logger.error(null, (Throwable)e);
        }
        this.pf4j.loadPlugins();
        this.logger.debug("Starting plugins");
        this.pf4j.startPlugins();
        return this;
    }

    @Override
    public PluginManager stop() {
        this.logger.debug("Stopping plugins");
        this.pf4j.stopPlugins();
        return null;
    }

    @Override
    public synchronized boolean installPlugin(String url, boolean verifyChecksum) throws IOException {
        File file = this.download(url, verifyChecksum);
        if (file == null || !file.exists()) {
            this.logger.error("Failed to download plugin {}", (Object)url);
            return false;
        }
        String pluginId = this.pf4j.loadPlugin(file);
        if (StringUtils.isEmpty(pluginId)) {
            this.logger.error("Failed to load plugin {}", (Object)file);
            return false;
        }
        PluginWrapper pluginWrapper = this.pf4j.getPlugin(pluginId);
        if (pluginWrapper.getPlugin() instanceof GitblitPlugin) {
            ((GitblitPlugin)pluginWrapper.getPlugin()).onInstall();
        }
        PluginState state = this.pf4j.startPlugin(pluginId);
        return PluginState.STARTED.equals((Object)state);
    }

    @Override
    public synchronized boolean upgradePlugin(String pluginId, String url, boolean verifyChecksum) throws IOException {
        File file = this.download(url, verifyChecksum);
        if (file == null || !file.exists()) {
            this.logger.error("Failed to download plugin {}", (Object)url);
            return false;
        }
        Version oldVersion = this.pf4j.getPlugin(pluginId).getDescriptor().getVersion();
        if (this.removePlugin(pluginId, false)) {
            String newPluginId = this.pf4j.loadPlugin(file);
            if (StringUtils.isEmpty(newPluginId)) {
                this.logger.error("Failed to load plugin {}", (Object)file);
                return false;
            }
            PluginWrapper pluginWrapper = this.pf4j.getPlugin(newPluginId);
            if (pluginWrapper.getPlugin() instanceof GitblitPlugin) {
                ((GitblitPlugin)pluginWrapper.getPlugin()).onUpgrade(oldVersion);
            }
            PluginState state = this.pf4j.startPlugin(newPluginId);
            return PluginState.STARTED.equals((Object)state);
        }
        this.logger.error("Failed to delete plugin {}", (Object)pluginId);
        return false;
    }

    @Override
    public synchronized boolean disablePlugin(String pluginId) {
        return this.pf4j.disablePlugin(pluginId);
    }

    @Override
    public synchronized boolean enablePlugin(String pluginId) {
        if (this.pf4j.enablePlugin(pluginId)) {
            return PluginState.STARTED == this.pf4j.startPlugin(pluginId);
        }
        return false;
    }

    @Override
    public synchronized boolean uninstallPlugin(String pluginId) {
        return this.removePlugin(pluginId, true);
    }

    protected boolean removePlugin(String pluginId, boolean isUninstall) {
        PluginWrapper pluginWrapper = this.getPlugin(pluginId);
        final String name = pluginWrapper.getPluginPath().substring(1);
        if (isUninstall && pluginWrapper.getPlugin() instanceof GitblitPlugin) {
            ((GitblitPlugin)pluginWrapper.getPlugin()).onUninstall();
        }
        if (this.pf4j.deletePlugin(pluginId)) {
            File pFolder = this.runtimeManager.getFileOrFolder("plugins.folder", "${baseFolder}/plugins");
            File[] checksums = pFolder.listFiles(new FileFilter(){

                @Override
                public boolean accept(File file) {
                    if (!file.isFile()) {
                        return false;
                    }
                    return file.getName().startsWith(name) && (file.getName().toLowerCase().endsWith(".sha1") || file.getName().toLowerCase().endsWith(".md5"));
                }
            });
            if (checksums != null) {
                for (File checksum : checksums) {
                    checksum.delete();
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public synchronized PluginState startPlugin(String pluginId) {
        return this.pf4j.startPlugin(pluginId);
    }

    @Override
    public synchronized PluginState stopPlugin(String pluginId) {
        return this.pf4j.stopPlugin(pluginId);
    }

    @Override
    public synchronized void startPlugins() {
        this.pf4j.startPlugins();
    }

    @Override
    public synchronized void stopPlugins() {
        this.pf4j.stopPlugins();
    }

    @Override
    public synchronized List<PluginWrapper> getPlugins() {
        return this.pf4j.getPlugins();
    }

    @Override
    public synchronized PluginWrapper getPlugin(String pluginId) {
        return this.pf4j.getPlugin(pluginId);
    }

    @Override
    public synchronized List<Class<?>> getExtensionClasses(String pluginId) {
        ArrayList list = new ArrayList();
        PluginClassLoader loader = this.pf4j.getPluginClassLoader(pluginId);
        for (String className : this.pf4j.getExtensionClassNames(pluginId)) {
            try {
                list.add(loader.loadClass(className));
            }
            catch (ClassNotFoundException e) {
                this.logger.error(String.format("Failed to find %s in %s", className, pluginId), (Throwable)e);
            }
        }
        return list;
    }

    @Override
    public synchronized <T> List<T> getExtensions(Class<T> type) {
        return this.pf4j.getExtensions(type);
    }

    @Override
    public synchronized PluginWrapper whichPlugin(Class<?> clazz) {
        return this.pf4j.whichPlugin(clazz);
    }

    @Override
    public synchronized boolean refreshRegistry(boolean verifyChecksum) {
        String dr = "http://gitblit-org.github.io/gitblit-registry/plugins.json";
        String url = this.runtimeManager.getSettings().getString("plugins.registry", dr);
        try {
            File file = this.download(url, verifyChecksum);
            if (file != null && file.exists()) {
                URL selfUrl = new URL(url.substring(0, url.lastIndexOf(47)));
                String content = FileUtils.readContent(file, "\n");
                content = content.replace("${self}", selfUrl.toString());
                FileUtils.writeContent(file, content);
            }
        }
        catch (Exception e) {
            this.logger.error(String.format("Failed to retrieve plugins.json from %s", url), (Throwable)e);
        }
        return false;
    }

    protected List<PluginRegistry> getRegistries() {
        FileFilter jsonFilter;
        ArrayList<PluginRegistry> list = new ArrayList<PluginRegistry>();
        File folder = this.runtimeManager.getFileOrFolder("plugins.folder", "${baseFolder}/plugins");
        File[] files = folder.listFiles(jsonFilter = new FileFilter(){

            @Override
            public boolean accept(File file) {
                return !file.isDirectory() && file.getName().toLowerCase().endsWith(".json");
            }
        });
        if (files == null || files.length == 0) {
            this.refreshRegistry(true);
            files = folder.listFiles(jsonFilter);
        }
        if (files == null || files.length == 0) {
            return list;
        }
        for (File file : files) {
            PluginRegistry registry = null;
            try {
                String json = FileUtils.readContent(file, "\n");
                registry = JsonUtils.fromJsonString(json, PluginRegistry.class);
                registry.setup();
            }
            catch (Exception e) {
                this.logger.error("Failed to deserialize " + file, (Throwable)e);
            }
            if (registry == null) continue;
            list.add(registry);
        }
        return list;
    }

    @Override
    public synchronized List<PluginRegistry.PluginRegistration> getRegisteredPlugins() {
        ArrayList<PluginRegistry.PluginRegistration> list = new ArrayList<PluginRegistry.PluginRegistration>();
        TreeMap<String, PluginRegistry.PluginRegistration> map = new TreeMap<String, PluginRegistry.PluginRegistration>();
        for (PluginRegistry registry : this.getRegistries()) {
            list.addAll(registry.registrations);
            for (PluginRegistry.PluginRegistration reg : list) {
                reg.installedRelease = null;
                map.put(reg.id, reg);
            }
        }
        for (PluginWrapper pw : this.pf4j.getPlugins()) {
            String id = pw.getDescriptor().getPluginId();
            Version pv = pw.getDescriptor().getVersion();
            PluginRegistry.PluginRegistration reg = (PluginRegistry.PluginRegistration)map.get(id);
            if (reg == null) continue;
            reg.installedRelease = pv.toString();
        }
        return list;
    }

    @Override
    public synchronized List<PluginRegistry.PluginRegistration> getRegisteredPlugins(PluginRegistry.InstallState state) {
        List<PluginRegistry.PluginRegistration> list = this.getRegisteredPlugins();
        Iterator<PluginRegistry.PluginRegistration> itr = list.iterator();
        while (itr.hasNext()) {
            if (state == itr.next().getInstallState(this.getSystemVersion())) continue;
            itr.remove();
        }
        return list;
    }

    @Override
    public synchronized PluginRegistry.PluginRegistration lookupPlugin(String pluginId) {
        for (PluginRegistry.PluginRegistration reg : this.getRegisteredPlugins()) {
            if (!reg.id.equalsIgnoreCase(pluginId)) continue;
            return reg;
        }
        return null;
    }

    @Override
    public synchronized PluginRegistry.PluginRelease lookupRelease(String pluginId, String version) {
        PluginRegistry.PluginRegistration reg = this.lookupPlugin(pluginId);
        if (reg == null) {
            return null;
        }
        PluginRegistry.PluginRelease pv = StringUtils.isEmpty(version) ? reg.getCurrentRelease(this.getSystemVersion()) : reg.getRelease(version);
        return pv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected File download(String url, boolean verifyChecksum) throws IOException {
        String expected;
        File file = this.downloadFile(url);
        if (!verifyChecksum) {
            return file;
        }
        File sha1File = null;
        try {
            sha1File = this.downloadFile(url + ".sha1");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        File md5File = null;
        try {
            md5File = this.downloadFile(url + ".md5");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (sha1File == null && md5File == null) {
            throw new IOException("Missing SHA1 and MD5 checksums for " + url);
        }
        MessageDigest md = null;
        if (sha1File != null && sha1File.exists()) {
            expected = FileUtils.readContent(sha1File, "\n").split(" ")[0].trim();
            try {
                md = MessageDigest.getInstance("SHA-1");
            }
            catch (NoSuchAlgorithmException e) {
                this.logger.error(null, (Throwable)e);
            }
        } else {
            expected = FileUtils.readContent(md5File, "\n").split(" ")[0].trim();
            try {
                md = MessageDigest.getInstance("MD5");
            }
            catch (Exception e) {
                this.logger.error(null, (Throwable)e);
            }
        }
        try (FileInputStream is = null;){
            is = new FileInputStream(file);
            DigestInputStream dis = new DigestInputStream(is, md);
            byte[] buffer = new byte[1024];
            while (dis.read(buffer) > -1) {
            }
            dis.close();
            byte[] digest = md.digest();
            String calculated = StringUtils.toHex(digest).trim();
            if (!expected.equals(calculated)) {
                String msg = String.format("Invalid checksum for %s\nAlgorithm:  %s\nExpected:   %s\nCalculated: %s", file.getAbsolutePath(), md.getAlgorithm(), expected, calculated);
                file.delete();
                throw new IOException(msg);
            }
        }
        return file;
    }

    protected File downloadFile(String url) throws IOException {
        File pFolder = this.runtimeManager.getFileOrFolder("plugins.folder", "${baseFolder}/plugins");
        pFolder.mkdirs();
        File tmpFile = new File(pFolder, StringUtils.getSHA1(url) + ".tmp");
        if (tmpFile.exists()) {
            tmpFile.delete();
        }
        URL u = new URL(url);
        URLConnection conn = this.getConnection(u);
        long lastModified = conn.getHeaderFieldDate("Last-Modified", System.currentTimeMillis());
        try (InputStream is = conn.getInputStream();
             FileOutputStream os = new FileOutputStream(tmpFile);){
            ByteStreams.copy((InputStream)is, (OutputStream)os);
        }
        File destFile = new File(pFolder, StringUtils.getLastPathElement(u.getPath()));
        if (destFile.exists()) {
            destFile.delete();
        }
        tmpFile.renameTo(destFile);
        destFile.setLastModified(lastModified);
        return destFile;
    }

    protected URLConnection getConnection(URL url) throws IOException {
        Proxy proxy = this.getProxy(url);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection(proxy);
        if (Proxy.Type.DIRECT != proxy.type()) {
            String auth = this.getProxyAuthorization(url);
            conn.setRequestProperty("Proxy-Authorization", auth);
        }
        String username = null;
        String password = null;
        if (!StringUtils.isEmpty(username) && !StringUtils.isEmpty(password)) {
            String auth = Base64.encodeBytes((username + ":" + password).getBytes());
            conn.setRequestProperty("Authorization", "Basic " + auth);
        }
        conn.setConnectTimeout(this.connectTimeout * 1000);
        conn.setReadTimeout(this.readTimeout * 1000);
        switch (conn.getResponseCode()) {
            case 301: 
            case 302: {
                String newLocation = conn.getHeaderField("Location");
                if (StringUtils.isEmpty(newLocation)) break;
                this.logger.info("following redirect to {0}", (Object)newLocation);
                conn.disconnect();
                return this.getConnection(new URL(newLocation));
            }
        }
        return conn;
    }

    protected Proxy getProxy(URL url) {
        String proxyHost = this.runtimeManager.getSettings().getString("plugins.httpProxyHost", "");
        String proxyPort = this.runtimeManager.getSettings().getString("plugins.httpProxyPort", "");
        if (!StringUtils.isEmpty(proxyHost) && !StringUtils.isEmpty(proxyPort)) {
            return new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyHost, Integer.parseInt(proxyPort)));
        }
        return Proxy.NO_PROXY;
    }

    protected String getProxyAuthorization(URL url) {
        String proxyAuth = this.runtimeManager.getSettings().getString("plugins.httpProxyAuthorization", "");
        return proxyAuth;
    }

    private class GuiceExtensionFactory
    implements ExtensionFactory {
        private GuiceExtensionFactory() {
        }

        public Object create(Class<?> extensionClass) {
            PluginManager.this.logger.debug("Create instance for extension '{}'", (Object)extensionClass.getName());
            try {
                return PluginManager.this.runtimeManager.getInjector().getInstance(extensionClass);
            }
            catch (Exception e) {
                PluginManager.this.logger.error(e.getMessage(), (Throwable)e);
                return null;
            }
        }
    }

    private class GuicePluginFactory
    extends DefaultPluginFactory {
        private GuicePluginFactory() {
        }

        public Plugin create(PluginWrapper pluginWrapper) {
            Plugin plugin = super.create(pluginWrapper);
            if (plugin != null) {
                PluginManager.this.runtimeManager.getInjector().injectMembers((Object)plugin);
            }
            return plugin;
        }
    }
}

