/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.manager;

import com.gitblit.IStoredSettings;
import com.gitblit.manager.IProjectManager;
import com.gitblit.manager.IRepositoryManager;
import com.gitblit.manager.IRuntimeManager;
import com.gitblit.manager.IUserManager;
import com.gitblit.models.ProjectModel;
import com.gitblit.models.RepositoryModel;
import com.gitblit.models.UserModel;
import com.gitblit.utils.DeepCopier;
import com.gitblit.utils.FileUtils;
import com.gitblit.utils.ModelUtils;
import com.gitblit.utils.ObjectCache;
import com.gitblit.utils.StringUtils;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.jgit.storage.file.FileBasedConfig;
import org.eclipse.jgit.util.FS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ProjectManager
implements IProjectManager {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Map<String, ProjectModel> projectCache = new ConcurrentHashMap<String, ProjectModel>();
    private final ObjectCache<String> projectMarkdownCache = new ObjectCache();
    private final ObjectCache<String> projectRepositoriesMarkdownCache = new ObjectCache();
    private final IStoredSettings settings;
    private final IRuntimeManager runtimeManager;
    private final IUserManager userManager;
    private final IRepositoryManager repositoryManager;
    private FileBasedConfig projectConfigs;

    @Inject
    public ProjectManager(IRuntimeManager runtimeManager, IUserManager userManager, IRepositoryManager repositoryManager) {
        this.settings = runtimeManager.getSettings();
        this.runtimeManager = runtimeManager;
        this.userManager = userManager;
        this.repositoryManager = repositoryManager;
    }

    @Override
    public ProjectManager start() {
        this.projectConfigs = new FileBasedConfig(this.runtimeManager.getFileOrFolder("web.projectsFile", "${baseFolder}/projects.conf"), FS.detect());
        this.getProjectConfigs();
        return this;
    }

    @Override
    public ProjectManager stop() {
        return this;
    }

    private void reloadProjectMarkdown(ProjectModel project) {
        File rmkd;
        File pmkd = new File(this.repositoryManager.getRepositoriesFolder(), (project.isRoot ? "" : project.name) + "/project.mkd");
        if (pmkd.exists()) {
            Date lm = new Date(pmkd.lastModified());
            if (!this.projectMarkdownCache.hasCurrent(project.name, lm)) {
                String mkd = FileUtils.readContent(pmkd, "\n");
                this.projectMarkdownCache.updateObject(project.name, lm, mkd);
            }
            project.projectMarkdown = this.projectMarkdownCache.getObject(project.name);
        }
        if ((rmkd = new File(this.repositoryManager.getRepositoriesFolder(), (project.isRoot ? "" : project.name) + "/repositories.mkd")).exists()) {
            Date lm = new Date(rmkd.lastModified());
            if (!this.projectRepositoriesMarkdownCache.hasCurrent(project.name, lm)) {
                String mkd = FileUtils.readContent(rmkd, "\n");
                this.projectRepositoriesMarkdownCache.updateObject(project.name, lm, mkd);
            }
            project.repositoriesMarkdown = this.projectRepositoriesMarkdownCache.getObject(project.name);
        }
    }

    private Map<String, ProjectModel> getProjectConfigs() {
        if (this.projectCache.isEmpty() || this.projectConfigs.isOutdated()) {
            try {
                this.projectConfigs.load();
            }
            catch (Exception exception) {
                // empty catch block
            }
            String rootName = this.settings.getString("web.repositoryRootGroupName", "main");
            ProjectModel rootProject = new ProjectModel(rootName, true);
            HashMap<String, ProjectModel> configs = new HashMap<String, ProjectModel>();
            configs.put("", rootProject);
            configs.put(rootProject.name.toLowerCase(), rootProject);
            for (String name : this.projectConfigs.getSubsections("project")) {
                ProjectModel project = name.equalsIgnoreCase(rootName) ? rootProject : new ProjectModel(name);
                project.title = this.projectConfigs.getString("project", name, "title");
                project.description = this.projectConfigs.getString("project", name, "description");
                this.reloadProjectMarkdown(project);
                configs.put(name.toLowerCase(), project);
            }
            this.projectCache.clear();
            this.projectCache.putAll(configs);
        }
        return this.projectCache;
    }

    @Override
    public List<ProjectModel> getProjectModels(UserModel user, boolean includeUsers) {
        ArrayList<Object> projects;
        Map<String, ProjectModel> configs = this.getProjectConfigs();
        TreeMap<String, ProjectModel> map = new TreeMap<String, ProjectModel>();
        map.put("", configs.get(""));
        for (RepositoryModel model : this.repositoryManager.getRepositoryModels(user)) {
            String projectPath = StringUtils.getRootPath(model.name);
            String projectKey = projectPath.toLowerCase();
            if (!map.containsKey(projectKey)) {
                ProjectModel project = configs.containsKey(projectKey) ? DeepCopier.copy(configs.get(projectKey)) : new ProjectModel(projectPath);
                map.put(projectKey, project);
            }
            ((ProjectModel)map.get(projectKey)).addRepository(model);
        }
        if (includeUsers) {
            projects = new ArrayList(map.values());
            Collections.sort(projects);
            projects.remove(map.get(""));
            projects.add(0, map.get(""));
        } else {
            projects = new ArrayList();
            ProjectModel root = (ProjectModel)map.remove("");
            for (ProjectModel model : map.values()) {
                if (model.isUserProject()) continue;
                projects.add(model);
            }
            Collections.sort(projects);
            projects.add(0, root);
        }
        return projects;
    }

    @Override
    public ProjectModel getProjectModel(String name, UserModel user) {
        for (ProjectModel project : this.getProjectModels(user, true)) {
            if (!project.name.equalsIgnoreCase(name)) continue;
            return project;
        }
        return null;
    }

    @Override
    public ProjectModel getProjectModel(String name) {
        Map<String, ProjectModel> configs = this.getProjectConfigs();
        ProjectModel project = configs.get(name.toLowerCase());
        if (project == null) {
            Object user;
            project = new ProjectModel(name);
            if (ModelUtils.isPersonalRepository(name) && (user = this.userManager.getUserModel(ModelUtils.getUserNameFromRepoPath(name))) != null) {
                project.title = ((UserModel)user).getDisplayName();
                project.description = "personal repositories";
            }
        } else {
            project = DeepCopier.copy(project);
        }
        if (StringUtils.isEmpty(name)) {
            for (String repository : this.repositoryManager.getRepositoryList()) {
                if (repository.indexOf(47) != -1) continue;
                project.addRepository(repository);
            }
        } else {
            String folder = name.toLowerCase() + "/";
            for (String repository : this.repositoryManager.getRepositoryList()) {
                if (!repository.toLowerCase().startsWith(folder)) continue;
                project.addRepository(repository);
            }
        }
        if (project.repositories.size() == 0) {
            return null;
        }
        this.reloadProjectMarkdown(project);
        return project;
    }

    @Override
    public List<ProjectModel> getProjectModels(List<RepositoryModel> repositoryModels, boolean includeUsers) {
        LinkedHashMap<String, ProjectModel> projects = new LinkedHashMap<String, ProjectModel>();
        for (RepositoryModel repository : repositoryModels) {
            ProjectModel project;
            if (!includeUsers && repository.isPersonalRepository()) continue;
            if (!projects.containsKey(repository.projectPath)) {
                project = this.getProjectModel(repository.projectPath);
                if (project == null) {
                    this.logger.warn(MessageFormat.format("excluding project \"{0}\" from project list because it is empty!", repository.projectPath));
                    continue;
                }
                projects.put(repository.projectPath, project);
                project.repositories.clear();
                project.repositories.add(repository.name);
                project.lastChange = repository.lastChange;
                continue;
            }
            project = (ProjectModel)projects.get(repository.projectPath);
            project.repositories.add(repository.name);
            if (!project.lastChange.before(repository.lastChange)) continue;
            project.lastChange = repository.lastChange;
        }
        return new ArrayList<ProjectModel>(projects.values());
    }
}

