/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.manager;

import com.gitblit.Constants;
import com.gitblit.IStoredSettings;
import com.gitblit.fanout.FanoutNioService;
import com.gitblit.fanout.FanoutService;
import com.gitblit.fanout.FanoutSocketService;
import com.gitblit.manager.IGitblit;
import com.gitblit.manager.IServicesManager;
import com.gitblit.models.FederationModel;
import com.gitblit.models.RepositoryModel;
import com.gitblit.models.RepositoryUrl;
import com.gitblit.models.UserModel;
import com.gitblit.service.FederationPullService;
import com.gitblit.transport.git.GitDaemon;
import com.gitblit.transport.ssh.SshDaemon;
import com.gitblit.utils.HttpUtils;
import com.gitblit.utils.StringUtils;
import com.gitblit.utils.TimeUtils;
import com.gitblit.utils.WorkQueue;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.io.IOException;
import java.net.URI;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ServicesManager
implements IServicesManager {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ScheduledExecutorService scheduledExecutor = Executors.newScheduledThreadPool(5);
    private final Provider<WorkQueue> workQueueProvider;
    private final IStoredSettings settings;
    private final IGitblit gitblit;
    private FanoutService fanoutService;
    private GitDaemon gitDaemon;
    private SshDaemon sshDaemon;

    @Inject
    public ServicesManager(Provider<WorkQueue> workQueueProvider, IStoredSettings settings, IGitblit gitblit) {
        this.workQueueProvider = workQueueProvider;
        this.settings = settings;
        this.gitblit = gitblit;
    }

    @Override
    public ServicesManager start() {
        this.configureFederation();
        this.configureFanout();
        this.configureGitDaemon();
        this.configureSshDaemon();
        return this;
    }

    @Override
    public ServicesManager stop() {
        this.scheduledExecutor.shutdownNow();
        if (this.fanoutService != null) {
            this.fanoutService.stop();
        }
        if (this.gitDaemon != null) {
            this.gitDaemon.stop();
        }
        if (this.sshDaemon != null) {
            this.sshDaemon.stop();
        }
        ((WorkQueue)this.workQueueProvider.get()).stop();
        return this;
    }

    protected String getRepositoryUrl(HttpServletRequest request, String username, RepositoryModel repository) {
        String gitblitUrl = this.settings.getString("web.canonicalUrl", null);
        if (StringUtils.isEmpty(gitblitUrl)) {
            gitblitUrl = HttpUtils.getGitblitURL(request);
        }
        StringBuilder sb = new StringBuilder();
        sb.append(gitblitUrl);
        sb.append("/r/");
        sb.append(repository.name);
        if (repository.accessRestriction.exceeds(Constants.AccessRestrictionType.NONE) && !StringUtils.isEmpty(username)) {
            sb.insert(sb.indexOf("://") + 3, username + "@");
        }
        return sb.toString();
    }

    @Override
    public List<RepositoryUrl> getRepositoryUrls(HttpServletRequest request, UserModel user, RepositoryModel repository) {
        Constants.AccessPermission permission;
        String gitDaemonUrl;
        Constants.AccessPermission permission2;
        String sshDaemonUrl;
        Constants.AccessPermission permission3;
        if (user == null) {
            user = UserModel.ANONYMOUS;
        }
        String username = StringUtils.encodeUsername(UserModel.ANONYMOUS.equals(user) ? "" : user.username);
        ArrayList<RepositoryUrl> list = new ArrayList<RepositoryUrl>();
        if (this.settings.getBoolean("git.enableGitServlet", true) && this.settings.getBoolean("web.showHttpServletUrls", true) && (permission3 = user.getRepositoryPermission((RepositoryModel)repository).permission).exceeds(Constants.AccessPermission.NONE)) {
            String repoUrl = this.getRepositoryUrl(request, username, repository);
            Constants.Transport transport = Constants.Transport.fromUrl(repoUrl);
            if (permission3.atLeast(Constants.AccessPermission.PUSH) && !this.acceptsPush(transport)) {
                permission3 = Constants.AccessPermission.CLONE;
            }
            list.add(new RepositoryUrl(repoUrl, permission3));
        }
        if (!StringUtils.isEmpty(sshDaemonUrl = this.getSshDaemonUrl(request, user, repository)) && this.settings.getBoolean("web.showSshDaemonUrls", true) && (permission2 = user.getRepositoryPermission((RepositoryModel)repository).permission).exceeds(Constants.AccessPermission.NONE)) {
            if (permission2.atLeast(Constants.AccessPermission.PUSH) && !this.acceptsPush(Constants.Transport.SSH)) {
                permission2 = Constants.AccessPermission.CLONE;
            }
            list.add(new RepositoryUrl(sshDaemonUrl, permission2));
        }
        if (!StringUtils.isEmpty(gitDaemonUrl = this.getGitDaemonUrl(request, user, repository)) && this.settings.getBoolean("web.showGitDaemonUrls", true) && (permission = this.getGitDaemonAccessPermission(user, repository)).exceeds(Constants.AccessPermission.NONE)) {
            if (permission.atLeast(Constants.AccessPermission.PUSH) && !this.acceptsPush(Constants.Transport.GIT)) {
                permission = Constants.AccessPermission.CLONE;
            }
            list.add(new RepositoryUrl(gitDaemonUrl, permission));
        }
        boolean advertisePermsForOther = this.settings.getBoolean("web.advertiseAccessPermissionForOtherUrls", false);
        for (String url : this.settings.getStrings("web.otherUrls")) {
            String externalUrl = null;
            if (url.contains("{1}")) {
                if (StringUtils.isEmpty(username)) continue;
                externalUrl = MessageFormat.format(url, repository.name, username);
            } else {
                externalUrl = MessageFormat.format(url, repository.name);
            }
            Constants.AccessPermission permission4 = null;
            if (advertisePermsForOther && (permission4 = user.getRepositoryPermission((RepositoryModel)repository).permission).exceeds(Constants.AccessPermission.NONE)) {
                Constants.Transport transport = Constants.Transport.fromUrl(externalUrl);
                if (permission4.atLeast(Constants.AccessPermission.PUSH) && !this.acceptsPush(transport)) {
                    permission4 = Constants.AccessPermission.CLONE;
                }
            }
            list.add(new RepositoryUrl(externalUrl, permission4));
        }
        Collections.sort(list, new Comparator<RepositoryUrl>(){

            @Override
            public int compare(RepositoryUrl o1, RepositoryUrl o2) {
                if (o1.hasPermission() && !o2.hasPermission()) {
                    return -1;
                }
                if (!o1.hasPermission() && o2.hasPermission()) {
                    return 1;
                }
                if (!o1.hasPermission() && !o2.hasPermission()) {
                    return o1.transport.compareTo(o2.transport);
                }
                if (o1.permission.exceeds(o2.permission)) {
                    return -1;
                }
                if (o2.permission.exceeds(o1.permission)) {
                    return 1;
                }
                return o1.transport.compareTo(o2.transport);
            }
        });
        RepositoryUrl preferredUrl = null;
        Constants.Transport preferredTransport = user.getPreferences().getTransport();
        if (preferredTransport != null) {
            Iterator itr = list.iterator();
            while (itr.hasNext()) {
                RepositoryUrl url = (RepositoryUrl)itr.next();
                if (!url.transport.equals((Object)preferredTransport)) continue;
                itr.remove();
                preferredUrl = url;
                break;
            }
        }
        if (preferredUrl != null) {
            list.add(0, preferredUrl);
        }
        return list;
    }

    @Override
    public boolean isServingRepositories() {
        return this.isServingHTTPS() || this.isServingHTTP() || this.isServingGIT() || this.isServingSSH();
    }

    @Override
    public boolean isServingHTTP() {
        return this.settings.getBoolean("git.enableGitServlet", true) && (this.gitblit.getStatus().isGO && this.settings.getInteger("server.httpPort", 0) > 0 || !this.gitblit.getStatus().isGO);
    }

    @Override
    public boolean isServingHTTPS() {
        return this.settings.getBoolean("git.enableGitServlet", true) && (this.gitblit.getStatus().isGO && this.settings.getInteger("server.httpsPort", 0) > 0 || !this.gitblit.getStatus().isGO);
    }

    @Override
    public boolean isServingGIT() {
        return this.gitDaemon != null && this.gitDaemon.isRunning();
    }

    @Override
    public boolean isServingSSH() {
        return this.sshDaemon != null && this.sshDaemon.isRunning();
    }

    protected void configureFederation() {
        List<FederationModel> registrations;
        boolean validPassphrase = true;
        String passphrase = this.settings.getString("federation.passphrase", "");
        if (StringUtils.isEmpty(passphrase)) {
            this.logger.info("Federation passphrase is blank! This server can not be PULLED from.");
            validPassphrase = false;
        }
        if (validPassphrase) {
            for (Constants.FederationToken tokenType : Constants.FederationToken.values()) {
                this.logger.info(MessageFormat.format("Federation {0} token = {1}", tokenType.name(), this.gitblit.getFederationToken(tokenType)));
            }
            for (String set : this.settings.getStrings("federation.sets")) {
                this.logger.info(MessageFormat.format("Federation Set {0} token = {1}", set, this.gitblit.getFederationToken(set)));
            }
        }
        if ((registrations = this.gitblit.getFederationRegistrations()).size() > 0) {
            FederationPuller executor = new FederationPuller(registrations);
            this.scheduledExecutor.schedule(executor, 1L, TimeUnit.MINUTES);
        }
    }

    @Override
    public boolean acceptsPush(Constants.Transport byTransport) {
        if (byTransport == null) {
            this.logger.info("Unknown transport, push rejected!");
            return false;
        }
        HashSet<Constants.Transport> transports = new HashSet<Constants.Transport>();
        for (String value : this.settings.getStrings("git.acceptedPushTransports")) {
            Constants.Transport transport = Constants.Transport.fromString(value);
            if (transport == null) {
                this.logger.info(String.format("Ignoring unknown registered transport %s", value));
                continue;
            }
            transports.add(transport);
        }
        if (transports.isEmpty()) {
            return true;
        }
        return transports.contains((Object)byTransport);
    }

    protected void configureGitDaemon() {
        int port = this.settings.getInteger("git.daemonPort", 0);
        String bindInterface = this.settings.getString("git.daemonBindInterface", "localhost");
        if (port > 0) {
            try {
                this.gitDaemon = new GitDaemon(this.gitblit);
                this.gitDaemon.start();
            }
            catch (IOException e) {
                this.gitDaemon = null;
                this.logger.error(MessageFormat.format("Failed to start Git Daemon on {0}:{1,number,0}", bindInterface, port), (Throwable)e);
            }
        } else {
            this.logger.info("Git Daemon is disabled.");
        }
    }

    protected void configureSshDaemon() {
        int port = this.settings.getInteger("git.sshPort", 0);
        String bindInterface = this.settings.getString("git.sshBindInterface", "localhost");
        if (port > 0) {
            try {
                this.sshDaemon = new SshDaemon(this.gitblit, (WorkQueue)this.workQueueProvider.get());
                this.sshDaemon.start();
            }
            catch (IOException e) {
                this.sshDaemon = null;
                this.logger.error(MessageFormat.format("Failed to start SSH daemon on {0}:{1,number,0}", bindInterface, port), (Throwable)e);
            }
        }
    }

    protected void configureFanout() {
        if (this.settings.getInteger("fanout.port", 0) > 0) {
            String bindInterface = this.settings.getString("fanout.bindInterface", null);
            int port = this.settings.getInteger("fanout.port", 17000);
            boolean useNio = this.settings.getBoolean("fanout.useNio", true);
            int limit = this.settings.getInteger("fanout.connectionLimit", 0);
            this.fanoutService = useNio ? (StringUtils.isEmpty(bindInterface) ? new FanoutNioService(port) : new FanoutNioService(bindInterface, port)) : (StringUtils.isEmpty(bindInterface) ? new FanoutSocketService(port) : new FanoutSocketService(bindInterface, port));
            this.fanoutService.setConcurrentConnectionLimit(limit);
            this.fanoutService.setAllowAllChannelAnnouncements(false);
            this.fanoutService.start();
        } else {
            this.logger.info("Fanout PubSub service is disabled.");
        }
    }

    public String getGitDaemonUrl(HttpServletRequest request, UserModel user, RepositoryModel repository) {
        if (this.gitDaemon != null) {
            String bindInterface = this.settings.getString("git.daemonBindInterface", "localhost");
            if (bindInterface.equals("localhost") && !request.getServerName().equals("localhost") && !request.getServerName().equals("127.0.0.1")) {
                return null;
            }
            if (user.canClone(repository)) {
                String hostname = this.getHostname(request);
                String url = this.gitDaemon.formatUrl(hostname, repository.name);
                return url;
            }
        }
        return null;
    }

    public Constants.AccessPermission getGitDaemonAccessPermission(UserModel user, RepositoryModel repository) {
        if (this.gitDaemon != null && user.canClone(repository)) {
            Constants.AccessPermission gitDaemonPermission = user.getRepositoryPermission((RepositoryModel)repository).permission;
            if (gitDaemonPermission.atLeast(Constants.AccessPermission.CLONE)) {
                if (repository.accessRestriction.atLeast(Constants.AccessRestrictionType.CLONE)) {
                    gitDaemonPermission = Constants.AccessPermission.NONE;
                } else if (repository.accessRestriction.atLeast(Constants.AccessRestrictionType.PUSH)) {
                    gitDaemonPermission = Constants.AccessPermission.CLONE;
                }
            }
            return gitDaemonPermission;
        }
        return Constants.AccessPermission.NONE;
    }

    public String getSshDaemonUrl(HttpServletRequest request, UserModel user, RepositoryModel repository) {
        if (user == null || UserModel.ANONYMOUS.equals(user)) {
            return null;
        }
        if (this.sshDaemon != null) {
            String bindInterface = this.settings.getString("git.sshBindInterface", "localhost");
            if (bindInterface.equals("localhost") && !request.getServerName().equals("localhost") && !request.getServerName().equals("127.0.0.1")) {
                return null;
            }
            if (user.canClone(repository)) {
                String hostname = this.getHostname(request);
                String url = this.sshDaemon.formatUrl(user.username, hostname, repository.name);
                return url;
            }
        }
        return null;
    }

    protected String getHostname(HttpServletRequest request) {
        String hostname = request.getServerName();
        String canonicalUrl = this.settings.getString("web.canonicalUrl", null);
        if (!StringUtils.isEmpty(canonicalUrl)) {
            try {
                URI uri = new URI(canonicalUrl);
                String host = uri.getHost();
                if (!StringUtils.isEmpty(host) && !"localhost".equals(host)) {
                    hostname = host;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return hostname;
    }

    private class FederationPuller
    extends FederationPullService {
        public FederationPuller(FederationModel registration) {
            super(ServicesManager.this.gitblit, Arrays.asList(registration));
        }

        public FederationPuller(List<FederationModel> registrations) {
            super(ServicesManager.this.gitblit, registrations);
        }

        @Override
        public void reschedule(FederationModel registration) {
            int mins = TimeUtils.convertFrequencyToMinutes(registration.frequency, 5);
            registration.nextPull = new Date(System.currentTimeMillis() + (long)(mins * 60) * 1000L);
            ServicesManager.this.scheduledExecutor.schedule(new FederationPuller(registration), (long)mins, TimeUnit.MINUTES);
            ServicesManager.this.logger.info(MessageFormat.format("Next pull of {0} @ {1} scheduled for {2,date,yyyy-MM-dd HH:mm}", registration.name, registration.url, registration.nextPull));
        }
    }
}

